/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Represents a buy from the Planning inventory store.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InventoryItem extends com.google.api.client.json.GenericJson {

  /**
   * Account ID of this inventory item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * Ad slots of this inventory item. If this inventory item represents a standalone placement,
   * there will be exactly one ad slot. If this inventory item represents a placement group, there
   * will be more than one ad slot, each representing one child placement in that placement group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AdSlot> adSlots;

  static {
    // hack to force ProGuard to consider AdSlot used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AdSlot.class);
  }

  /**
   * Advertiser ID of this inventory item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long advertiserId;

  /**
   * Content category ID of this inventory item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long contentCategoryId;

  /**
   * Estimated click-through rate of this inventory item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long estimatedClickThroughRate;

  /**
   * Estimated conversion rate of this inventory item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long estimatedConversionRate;

  /**
   * ID of this inventory item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Whether this inventory item is in plan.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean inPlan;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#inventoryItem".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Information about the most recent modification of this inventory item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LastModifiedInfo lastModifiedInfo;

  /**
   * Name of this inventory item. For standalone inventory items, this is the same name as that of
   * its only ad slot. For group inventory items, this can differ from the name of any of its ad
   * slots.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Negotiation channel ID of this inventory item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long negotiationChannelId;

  /**
   * Order ID of this inventory item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long orderId;

  /**
   * Placement strategy ID of this inventory item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long placementStrategyId;

  /**
   * Pricing of this inventory item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Pricing pricing;

  /**
   * Project ID of this inventory item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long projectId;

  /**
   * RFP ID of this inventory item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long rfpId;

  /**
   * ID of the site this inventory item is associated with.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long siteId;

  /**
   * Subaccount ID of this inventory item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long subaccountId;

  /**
   * Type of inventory item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Account ID of this inventory item.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * Account ID of this inventory item.
   * @param accountId accountId or {@code null} for none
   */
  public InventoryItem setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Ad slots of this inventory item. If this inventory item represents a standalone placement,
   * there will be exactly one ad slot. If this inventory item represents a placement group, there
   * will be more than one ad slot, each representing one child placement in that placement group.
   * @return value or {@code null} for none
   */
  public java.util.List<AdSlot> getAdSlots() {
    return adSlots;
  }

  /**
   * Ad slots of this inventory item. If this inventory item represents a standalone placement,
   * there will be exactly one ad slot. If this inventory item represents a placement group, there
   * will be more than one ad slot, each representing one child placement in that placement group.
   * @param adSlots adSlots or {@code null} for none
   */
  public InventoryItem setAdSlots(java.util.List<AdSlot> adSlots) {
    this.adSlots = adSlots;
    return this;
  }

  /**
   * Advertiser ID of this inventory item.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAdvertiserId() {
    return advertiserId;
  }

  /**
   * Advertiser ID of this inventory item.
   * @param advertiserId advertiserId or {@code null} for none
   */
  public InventoryItem setAdvertiserId(java.lang.Long advertiserId) {
    this.advertiserId = advertiserId;
    return this;
  }

  /**
   * Content category ID of this inventory item.
   * @return value or {@code null} for none
   */
  public java.lang.Long getContentCategoryId() {
    return contentCategoryId;
  }

  /**
   * Content category ID of this inventory item.
   * @param contentCategoryId contentCategoryId or {@code null} for none
   */
  public InventoryItem setContentCategoryId(java.lang.Long contentCategoryId) {
    this.contentCategoryId = contentCategoryId;
    return this;
  }

  /**
   * Estimated click-through rate of this inventory item.
   * @return value or {@code null} for none
   */
  public java.lang.Long getEstimatedClickThroughRate() {
    return estimatedClickThroughRate;
  }

  /**
   * Estimated click-through rate of this inventory item.
   * @param estimatedClickThroughRate estimatedClickThroughRate or {@code null} for none
   */
  public InventoryItem setEstimatedClickThroughRate(java.lang.Long estimatedClickThroughRate) {
    this.estimatedClickThroughRate = estimatedClickThroughRate;
    return this;
  }

  /**
   * Estimated conversion rate of this inventory item.
   * @return value or {@code null} for none
   */
  public java.lang.Long getEstimatedConversionRate() {
    return estimatedConversionRate;
  }

  /**
   * Estimated conversion rate of this inventory item.
   * @param estimatedConversionRate estimatedConversionRate or {@code null} for none
   */
  public InventoryItem setEstimatedConversionRate(java.lang.Long estimatedConversionRate) {
    this.estimatedConversionRate = estimatedConversionRate;
    return this;
  }

  /**
   * ID of this inventory item.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this inventory item.
   * @param id id or {@code null} for none
   */
  public InventoryItem setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Whether this inventory item is in plan.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getInPlan() {
    return inPlan;
  }

  /**
   * Whether this inventory item is in plan.
   * @param inPlan inPlan or {@code null} for none
   */
  public InventoryItem setInPlan(java.lang.Boolean inPlan) {
    this.inPlan = inPlan;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#inventoryItem".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#inventoryItem".
   * @param kind kind or {@code null} for none
   */
  public InventoryItem setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Information about the most recent modification of this inventory item.
   * @return value or {@code null} for none
   */
  public LastModifiedInfo getLastModifiedInfo() {
    return lastModifiedInfo;
  }

  /**
   * Information about the most recent modification of this inventory item.
   * @param lastModifiedInfo lastModifiedInfo or {@code null} for none
   */
  public InventoryItem setLastModifiedInfo(LastModifiedInfo lastModifiedInfo) {
    this.lastModifiedInfo = lastModifiedInfo;
    return this;
  }

  /**
   * Name of this inventory item. For standalone inventory items, this is the same name as that of
   * its only ad slot. For group inventory items, this can differ from the name of any of its ad
   * slots.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this inventory item. For standalone inventory items, this is the same name as that of
   * its only ad slot. For group inventory items, this can differ from the name of any of its ad
   * slots.
   * @param name name or {@code null} for none
   */
  public InventoryItem setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Negotiation channel ID of this inventory item.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNegotiationChannelId() {
    return negotiationChannelId;
  }

  /**
   * Negotiation channel ID of this inventory item.
   * @param negotiationChannelId negotiationChannelId or {@code null} for none
   */
  public InventoryItem setNegotiationChannelId(java.lang.Long negotiationChannelId) {
    this.negotiationChannelId = negotiationChannelId;
    return this;
  }

  /**
   * Order ID of this inventory item.
   * @return value or {@code null} for none
   */
  public java.lang.Long getOrderId() {
    return orderId;
  }

  /**
   * Order ID of this inventory item.
   * @param orderId orderId or {@code null} for none
   */
  public InventoryItem setOrderId(java.lang.Long orderId) {
    this.orderId = orderId;
    return this;
  }

  /**
   * Placement strategy ID of this inventory item.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPlacementStrategyId() {
    return placementStrategyId;
  }

  /**
   * Placement strategy ID of this inventory item.
   * @param placementStrategyId placementStrategyId or {@code null} for none
   */
  public InventoryItem setPlacementStrategyId(java.lang.Long placementStrategyId) {
    this.placementStrategyId = placementStrategyId;
    return this;
  }

  /**
   * Pricing of this inventory item.
   * @return value or {@code null} for none
   */
  public Pricing getPricing() {
    return pricing;
  }

  /**
   * Pricing of this inventory item.
   * @param pricing pricing or {@code null} for none
   */
  public InventoryItem setPricing(Pricing pricing) {
    this.pricing = pricing;
    return this;
  }

  /**
   * Project ID of this inventory item.
   * @return value or {@code null} for none
   */
  public java.lang.Long getProjectId() {
    return projectId;
  }

  /**
   * Project ID of this inventory item.
   * @param projectId projectId or {@code null} for none
   */
  public InventoryItem setProjectId(java.lang.Long projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * RFP ID of this inventory item.
   * @return value or {@code null} for none
   */
  public java.lang.Long getRfpId() {
    return rfpId;
  }

  /**
   * RFP ID of this inventory item.
   * @param rfpId rfpId or {@code null} for none
   */
  public InventoryItem setRfpId(java.lang.Long rfpId) {
    this.rfpId = rfpId;
    return this;
  }

  /**
   * ID of the site this inventory item is associated with.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSiteId() {
    return siteId;
  }

  /**
   * ID of the site this inventory item is associated with.
   * @param siteId siteId or {@code null} for none
   */
  public InventoryItem setSiteId(java.lang.Long siteId) {
    this.siteId = siteId;
    return this;
  }

  /**
   * Subaccount ID of this inventory item.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSubaccountId() {
    return subaccountId;
  }

  /**
   * Subaccount ID of this inventory item.
   * @param subaccountId subaccountId or {@code null} for none
   */
  public InventoryItem setSubaccountId(java.lang.Long subaccountId) {
    this.subaccountId = subaccountId;
    return this;
  }

  /**
   * Type of inventory item.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of inventory item.
   * @param type type or {@code null} for none
   */
  public InventoryItem setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public InventoryItem set(String fieldName, Object value) {
    return (InventoryItem) super.set(fieldName, value);
  }

  @Override
  public InventoryItem clone() {
    return (InventoryItem) super.clone();
  }

}
