/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains information about where a user's browser is taken after the user clicks an ad.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LandingPage extends com.google.api.client.json.GenericJson {

  /**
   * Advertiser ID of this landing page. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long advertiserId;

  /**
   * Whether this landing page has been archived.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean archived;

  /**
   * Links that will direct the user to a mobile app, if installed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DeepLink> deepLinks;

  static {
    // hack to force ProGuard to consider DeepLink used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DeepLink.class);
  }

  /**
   * ID of this landing page. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#landingPage".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of this landing page. This is a required field. It must be less than 256 characters long.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * URL of this landing page. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String url;

  /**
   * Advertiser ID of this landing page. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAdvertiserId() {
    return advertiserId;
  }

  /**
   * Advertiser ID of this landing page. This is a required field.
   * @param advertiserId advertiserId or {@code null} for none
   */
  public LandingPage setAdvertiserId(java.lang.Long advertiserId) {
    this.advertiserId = advertiserId;
    return this;
  }

  /**
   * Whether this landing page has been archived.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getArchived() {
    return archived;
  }

  /**
   * Whether this landing page has been archived.
   * @param archived archived or {@code null} for none
   */
  public LandingPage setArchived(java.lang.Boolean archived) {
    this.archived = archived;
    return this;
  }

  /**
   * Links that will direct the user to a mobile app, if installed.
   * @return value or {@code null} for none
   */
  public java.util.List<DeepLink> getDeepLinks() {
    return deepLinks;
  }

  /**
   * Links that will direct the user to a mobile app, if installed.
   * @param deepLinks deepLinks or {@code null} for none
   */
  public LandingPage setDeepLinks(java.util.List<DeepLink> deepLinks) {
    this.deepLinks = deepLinks;
    return this;
  }

  /**
   * ID of this landing page. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this landing page. This is a read-only, auto-generated field.
   * @param id id or {@code null} for none
   */
  public LandingPage setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#landingPage".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#landingPage".
   * @param kind kind or {@code null} for none
   */
  public LandingPage setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of this landing page. This is a required field. It must be less than 256 characters long.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this landing page. This is a required field. It must be less than 256 characters long.
   * @param name name or {@code null} for none
   */
  public LandingPage setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * URL of this landing page. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.String getUrl() {
    return url;
  }

  /**
   * URL of this landing page. This is a required field.
   * @param url url or {@code null} for none
   */
  public LandingPage setUrl(java.lang.String url) {
    this.url = url;
    return this;
  }

  @Override
  public LandingPage set(String fieldName, Object value) {
    return (LandingPage) super.set(fieldName, value);
  }

  @Override
  public LandingPage clone() {
    return (LandingPage) super.clone();
  }

}
