/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Object Filter.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ObjectFilter extends com.google.api.client.json.GenericJson {

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#objectFilter".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Applicable when status is ASSIGNED. The user has access to objects with these object IDs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> objectIds;

  /**
   * Status of the filter. NONE means the user has access to none of the objects. ALL means the user
   * has access to all objects. ASSIGNED means the user has access to the objects with IDs in the
   * objectIds list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#objectFilter".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#objectFilter".
   * @param kind kind or {@code null} for none
   */
  public ObjectFilter setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Applicable when status is ASSIGNED. The user has access to objects with these object IDs.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getObjectIds() {
    return objectIds;
  }

  /**
   * Applicable when status is ASSIGNED. The user has access to objects with these object IDs.
   * @param objectIds objectIds or {@code null} for none
   */
  public ObjectFilter setObjectIds(java.util.List<java.lang.Long> objectIds) {
    this.objectIds = objectIds;
    return this;
  }

  /**
   * Status of the filter. NONE means the user has access to none of the objects. ALL means the user
   * has access to all objects. ASSIGNED means the user has access to the objects with IDs in the
   * objectIds list.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Status of the filter. NONE means the user has access to none of the objects. ALL means the user
   * has access to all objects. ASSIGNED means the user has access to the objects with IDs in the
   * objectIds list.
   * @param status status or {@code null} for none
   */
  public ObjectFilter setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public ObjectFilter set(String fieldName, Object value) {
    return (ObjectFilter) super.set(fieldName, value);
  }

  @Override
  public ObjectFilter clone() {
    return (ObjectFilter) super.clone();
  }

}
