/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains information about an operating system that can be targeted by ads.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OperatingSystem extends com.google.api.client.json.GenericJson {

  /**
   * DART ID of this operating system. This is the ID used for targeting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long dartId;

  /**
   * Whether this operating system is for desktop.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean desktop;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#operatingSystem".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Whether this operating system is for mobile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean mobile;

  /**
   * Name of this operating system.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * DART ID of this operating system. This is the ID used for targeting.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDartId() {
    return dartId;
  }

  /**
   * DART ID of this operating system. This is the ID used for targeting.
   * @param dartId dartId or {@code null} for none
   */
  public OperatingSystem setDartId(java.lang.Long dartId) {
    this.dartId = dartId;
    return this;
  }

  /**
   * Whether this operating system is for desktop.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDesktop() {
    return desktop;
  }

  /**
   * Whether this operating system is for desktop.
   * @param desktop desktop or {@code null} for none
   */
  public OperatingSystem setDesktop(java.lang.Boolean desktop) {
    this.desktop = desktop;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#operatingSystem".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#operatingSystem".
   * @param kind kind or {@code null} for none
   */
  public OperatingSystem setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Whether this operating system is for mobile.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMobile() {
    return mobile;
  }

  /**
   * Whether this operating system is for mobile.
   * @param mobile mobile or {@code null} for none
   */
  public OperatingSystem setMobile(java.lang.Boolean mobile) {
    this.mobile = mobile;
    return this;
  }

  /**
   * Name of this operating system.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this operating system.
   * @param name name or {@code null} for none
   */
  public OperatingSystem setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public OperatingSystem set(String fieldName, Object value) {
    return (OperatingSystem) super.set(fieldName, value);
  }

  @Override
  public OperatingSystem clone() {
    return (OperatingSystem) super.clone();
  }

}
