/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contact of an order.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderContact extends com.google.api.client.json.GenericJson {

  /**
   * Free-form information about this contact. It could be any information related to this contact
   * in addition to type, title, name, and signature user profile ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contactInfo;

  /**
   * Name of this contact.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contactName;

  /**
   * Title of this contact.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contactTitle;

  /**
   * Type of this contact.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contactType;

  /**
   * ID of the user profile containing the signature that will be embedded into order documents.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long signatureUserProfileId;

  /**
   * Free-form information about this contact. It could be any information related to this contact
   * in addition to type, title, name, and signature user profile ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getContactInfo() {
    return contactInfo;
  }

  /**
   * Free-form information about this contact. It could be any information related to this contact
   * in addition to type, title, name, and signature user profile ID.
   * @param contactInfo contactInfo or {@code null} for none
   */
  public OrderContact setContactInfo(java.lang.String contactInfo) {
    this.contactInfo = contactInfo;
    return this;
  }

  /**
   * Name of this contact.
   * @return value or {@code null} for none
   */
  public java.lang.String getContactName() {
    return contactName;
  }

  /**
   * Name of this contact.
   * @param contactName contactName or {@code null} for none
   */
  public OrderContact setContactName(java.lang.String contactName) {
    this.contactName = contactName;
    return this;
  }

  /**
   * Title of this contact.
   * @return value or {@code null} for none
   */
  public java.lang.String getContactTitle() {
    return contactTitle;
  }

  /**
   * Title of this contact.
   * @param contactTitle contactTitle or {@code null} for none
   */
  public OrderContact setContactTitle(java.lang.String contactTitle) {
    this.contactTitle = contactTitle;
    return this;
  }

  /**
   * Type of this contact.
   * @return value or {@code null} for none
   */
  public java.lang.String getContactType() {
    return contactType;
  }

  /**
   * Type of this contact.
   * @param contactType contactType or {@code null} for none
   */
  public OrderContact setContactType(java.lang.String contactType) {
    this.contactType = contactType;
    return this;
  }

  /**
   * ID of the user profile containing the signature that will be embedded into order documents.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSignatureUserProfileId() {
    return signatureUserProfileId;
  }

  /**
   * ID of the user profile containing the signature that will be embedded into order documents.
   * @param signatureUserProfileId signatureUserProfileId or {@code null} for none
   */
  public OrderContact setSignatureUserProfileId(java.lang.Long signatureUserProfileId) {
    this.signatureUserProfileId = signatureUserProfileId;
    return this;
  }

  @Override
  public OrderContact set(String fieldName, Object value) {
    return (OrderContact) super.set(fieldName, value);
  }

  @Override
  public OrderContact clone() {
    return (OrderContact) super.clone();
  }

}
