/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains properties of a Planning order document.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderDocument extends com.google.api.client.json.GenericJson {

  /**
   * Account ID of this order document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * Advertiser ID of this order document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long advertiserId;

  /**
   * The amended order document ID of this order document. An order document can be created by
   * optionally amending another order document so that the change history can be preserved.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long amendedOrderDocumentId;

  /**
   * IDs of users who have approved this order document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> approvedByUserProfileIds;

  /**
   * Whether this order document is cancelled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean cancelled;

  /**
   * Information about the creation of this order document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LastModifiedInfo createdInfo;

  /**
   * Effective date of this order document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime effectiveDate;

  /**
   * ID of this order document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#orderDocument".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * List of email addresses that received the last sent document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> lastSentRecipients;

  /**
   * Timestamp of the last email sent with this order document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime lastSentTime;

  /**
   * ID of the order from which this order document is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long orderId;

  /**
   * Project ID of this order document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long projectId;

  /**
   * Whether this order document has been signed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean signed;

  /**
   * Subaccount ID of this order document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long subaccountId;

  /**
   * Title of this order document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * Type of this order document
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Account ID of this order document.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * Account ID of this order document.
   * @param accountId accountId or {@code null} for none
   */
  public OrderDocument setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Advertiser ID of this order document.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAdvertiserId() {
    return advertiserId;
  }

  /**
   * Advertiser ID of this order document.
   * @param advertiserId advertiserId or {@code null} for none
   */
  public OrderDocument setAdvertiserId(java.lang.Long advertiserId) {
    this.advertiserId = advertiserId;
    return this;
  }

  /**
   * The amended order document ID of this order document. An order document can be created by
   * optionally amending another order document so that the change history can be preserved.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAmendedOrderDocumentId() {
    return amendedOrderDocumentId;
  }

  /**
   * The amended order document ID of this order document. An order document can be created by
   * optionally amending another order document so that the change history can be preserved.
   * @param amendedOrderDocumentId amendedOrderDocumentId or {@code null} for none
   */
  public OrderDocument setAmendedOrderDocumentId(java.lang.Long amendedOrderDocumentId) {
    this.amendedOrderDocumentId = amendedOrderDocumentId;
    return this;
  }

  /**
   * IDs of users who have approved this order document.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getApprovedByUserProfileIds() {
    return approvedByUserProfileIds;
  }

  /**
   * IDs of users who have approved this order document.
   * @param approvedByUserProfileIds approvedByUserProfileIds or {@code null} for none
   */
  public OrderDocument setApprovedByUserProfileIds(java.util.List<java.lang.Long> approvedByUserProfileIds) {
    this.approvedByUserProfileIds = approvedByUserProfileIds;
    return this;
  }

  /**
   * Whether this order document is cancelled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCancelled() {
    return cancelled;
  }

  /**
   * Whether this order document is cancelled.
   * @param cancelled cancelled or {@code null} for none
   */
  public OrderDocument setCancelled(java.lang.Boolean cancelled) {
    this.cancelled = cancelled;
    return this;
  }

  /**
   * Information about the creation of this order document.
   * @return value or {@code null} for none
   */
  public LastModifiedInfo getCreatedInfo() {
    return createdInfo;
  }

  /**
   * Information about the creation of this order document.
   * @param createdInfo createdInfo or {@code null} for none
   */
  public OrderDocument setCreatedInfo(LastModifiedInfo createdInfo) {
    this.createdInfo = createdInfo;
    return this;
  }

  /**
   * Effective date of this order document.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getEffectiveDate() {
    return effectiveDate;
  }

  /**
   * Effective date of this order document.
   * @param effectiveDate effectiveDate or {@code null} for none
   */
  public OrderDocument setEffectiveDate(com.google.api.client.util.DateTime effectiveDate) {
    this.effectiveDate = effectiveDate;
    return this;
  }

  /**
   * ID of this order document.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this order document.
   * @param id id or {@code null} for none
   */
  public OrderDocument setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#orderDocument".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#orderDocument".
   * @param kind kind or {@code null} for none
   */
  public OrderDocument setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * List of email addresses that received the last sent document.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLastSentRecipients() {
    return lastSentRecipients;
  }

  /**
   * List of email addresses that received the last sent document.
   * @param lastSentRecipients lastSentRecipients or {@code null} for none
   */
  public OrderDocument setLastSentRecipients(java.util.List<java.lang.String> lastSentRecipients) {
    this.lastSentRecipients = lastSentRecipients;
    return this;
  }

  /**
   * Timestamp of the last email sent with this order document.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getLastSentTime() {
    return lastSentTime;
  }

  /**
   * Timestamp of the last email sent with this order document.
   * @param lastSentTime lastSentTime or {@code null} for none
   */
  public OrderDocument setLastSentTime(com.google.api.client.util.DateTime lastSentTime) {
    this.lastSentTime = lastSentTime;
    return this;
  }

  /**
   * ID of the order from which this order document is created.
   * @return value or {@code null} for none
   */
  public java.lang.Long getOrderId() {
    return orderId;
  }

  /**
   * ID of the order from which this order document is created.
   * @param orderId orderId or {@code null} for none
   */
  public OrderDocument setOrderId(java.lang.Long orderId) {
    this.orderId = orderId;
    return this;
  }

  /**
   * Project ID of this order document.
   * @return value or {@code null} for none
   */
  public java.lang.Long getProjectId() {
    return projectId;
  }

  /**
   * Project ID of this order document.
   * @param projectId projectId or {@code null} for none
   */
  public OrderDocument setProjectId(java.lang.Long projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Whether this order document has been signed.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSigned() {
    return signed;
  }

  /**
   * Whether this order document has been signed.
   * @param signed signed or {@code null} for none
   */
  public OrderDocument setSigned(java.lang.Boolean signed) {
    this.signed = signed;
    return this;
  }

  /**
   * Subaccount ID of this order document.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSubaccountId() {
    return subaccountId;
  }

  /**
   * Subaccount ID of this order document.
   * @param subaccountId subaccountId or {@code null} for none
   */
  public OrderDocument setSubaccountId(java.lang.Long subaccountId) {
    this.subaccountId = subaccountId;
    return this;
  }

  /**
   * Title of this order document.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Title of this order document.
   * @param title title or {@code null} for none
   */
  public OrderDocument setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * Type of this order document
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of this order document
   * @param type type or {@code null} for none
   */
  public OrderDocument setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public OrderDocument set(String fieldName, Object value) {
    return (OrderDocument) super.set(fieldName, value);
  }

  @Override
  public OrderDocument clone() {
    return (OrderDocument) super.clone();
  }

}
