/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains properties of a package or roadblock.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PlacementGroup extends com.google.api.client.json.GenericJson {

  /**
   * Account ID of this placement group. This is a read-only field that can be left blank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * Advertiser ID of this placement group. This is a required field on insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long advertiserId;

  /**
   * Dimension value for the ID of the advertiser. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue advertiserIdDimensionValue;

  /**
   * Whether this placement group is archived.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean archived;

  /**
   * Campaign ID of this placement group. This field is required on insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long campaignId;

  /**
   * Dimension value for the ID of the campaign. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue campaignIdDimensionValue;

  /**
   * IDs of placements which are assigned to this placement group. This is a read-only, auto-
   * generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> childPlacementIds;

  /**
   * Comments for this placement group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String comment;

  /**
   * ID of the content category assigned to this placement group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long contentCategoryId;

  /**
   * Information about the creation of this placement group. This is a read-only field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LastModifiedInfo createInfo;

  /**
   * Directory site ID associated with this placement group. On insert, you must set either this
   * field or the site_id field to specify the site associated with this placement group. This is a
   * required field that is read-only after insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long directorySiteId;

  /**
   * Dimension value for the ID of the directory site. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue directorySiteIdDimensionValue;

  /**
   * External ID for this placement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String externalId;

  /**
   * ID of this placement group. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Dimension value for the ID of this placement group. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue idDimensionValue;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#placementGroup".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Information about the most recent modification of this placement group. This is a read-only
   * field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LastModifiedInfo lastModifiedInfo;

  /**
   * Name of this placement group. This is a required field and must be less than 256 characters
   * long.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Type of this placement group. A package is a simple group of placements that acts as a single
   * pricing point for a group of tags. A roadblock is a group of placements that not only acts as a
   * single pricing point, but also assumes that all the tags in it will be served at the same time.
   * A roadblock requires one of its assigned placements to be marked as primary for reporting. This
   * field is required on insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String placementGroupType;

  /**
   * ID of the placement strategy assigned to this placement group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long placementStrategyId;

  /**
   * Pricing schedule of this placement group. This field is required on insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PricingSchedule pricingSchedule;

  /**
   * ID of the primary placement, used to calculate the media cost of a roadblock (placement group).
   * Modifying this field will automatically modify the primary field on all affected roadblock
   * child placements.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long primaryPlacementId;

  /**
   * Dimension value for the ID of the primary placement. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue primaryPlacementIdDimensionValue;

  /**
   * Site ID associated with this placement group. On insert, you must set either this field or the
   * directorySiteId field to specify the site associated with this placement group. This is a
   * required field that is read-only after insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long siteId;

  /**
   * Dimension value for the ID of the site. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue siteIdDimensionValue;

  /**
   * Subaccount ID of this placement group. This is a read-only field that can be left blank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long subaccountId;

  /**
   * Account ID of this placement group. This is a read-only field that can be left blank.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * Account ID of this placement group. This is a read-only field that can be left blank.
   * @param accountId accountId or {@code null} for none
   */
  public PlacementGroup setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Advertiser ID of this placement group. This is a required field on insertion.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAdvertiserId() {
    return advertiserId;
  }

  /**
   * Advertiser ID of this placement group. This is a required field on insertion.
   * @param advertiserId advertiserId or {@code null} for none
   */
  public PlacementGroup setAdvertiserId(java.lang.Long advertiserId) {
    this.advertiserId = advertiserId;
    return this;
  }

  /**
   * Dimension value for the ID of the advertiser. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getAdvertiserIdDimensionValue() {
    return advertiserIdDimensionValue;
  }

  /**
   * Dimension value for the ID of the advertiser. This is a read-only, auto-generated field.
   * @param advertiserIdDimensionValue advertiserIdDimensionValue or {@code null} for none
   */
  public PlacementGroup setAdvertiserIdDimensionValue(DimensionValue advertiserIdDimensionValue) {
    this.advertiserIdDimensionValue = advertiserIdDimensionValue;
    return this;
  }

  /**
   * Whether this placement group is archived.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getArchived() {
    return archived;
  }

  /**
   * Whether this placement group is archived.
   * @param archived archived or {@code null} for none
   */
  public PlacementGroup setArchived(java.lang.Boolean archived) {
    this.archived = archived;
    return this;
  }

  /**
   * Campaign ID of this placement group. This field is required on insertion.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCampaignId() {
    return campaignId;
  }

  /**
   * Campaign ID of this placement group. This field is required on insertion.
   * @param campaignId campaignId or {@code null} for none
   */
  public PlacementGroup setCampaignId(java.lang.Long campaignId) {
    this.campaignId = campaignId;
    return this;
  }

  /**
   * Dimension value for the ID of the campaign. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getCampaignIdDimensionValue() {
    return campaignIdDimensionValue;
  }

  /**
   * Dimension value for the ID of the campaign. This is a read-only, auto-generated field.
   * @param campaignIdDimensionValue campaignIdDimensionValue or {@code null} for none
   */
  public PlacementGroup setCampaignIdDimensionValue(DimensionValue campaignIdDimensionValue) {
    this.campaignIdDimensionValue = campaignIdDimensionValue;
    return this;
  }

  /**
   * IDs of placements which are assigned to this placement group. This is a read-only, auto-
   * generated field.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getChildPlacementIds() {
    return childPlacementIds;
  }

  /**
   * IDs of placements which are assigned to this placement group. This is a read-only, auto-
   * generated field.
   * @param childPlacementIds childPlacementIds or {@code null} for none
   */
  public PlacementGroup setChildPlacementIds(java.util.List<java.lang.Long> childPlacementIds) {
    this.childPlacementIds = childPlacementIds;
    return this;
  }

  /**
   * Comments for this placement group.
   * @return value or {@code null} for none
   */
  public java.lang.String getComment() {
    return comment;
  }

  /**
   * Comments for this placement group.
   * @param comment comment or {@code null} for none
   */
  public PlacementGroup setComment(java.lang.String comment) {
    this.comment = comment;
    return this;
  }

  /**
   * ID of the content category assigned to this placement group.
   * @return value or {@code null} for none
   */
  public java.lang.Long getContentCategoryId() {
    return contentCategoryId;
  }

  /**
   * ID of the content category assigned to this placement group.
   * @param contentCategoryId contentCategoryId or {@code null} for none
   */
  public PlacementGroup setContentCategoryId(java.lang.Long contentCategoryId) {
    this.contentCategoryId = contentCategoryId;
    return this;
  }

  /**
   * Information about the creation of this placement group. This is a read-only field.
   * @return value or {@code null} for none
   */
  public LastModifiedInfo getCreateInfo() {
    return createInfo;
  }

  /**
   * Information about the creation of this placement group. This is a read-only field.
   * @param createInfo createInfo or {@code null} for none
   */
  public PlacementGroup setCreateInfo(LastModifiedInfo createInfo) {
    this.createInfo = createInfo;
    return this;
  }

  /**
   * Directory site ID associated with this placement group. On insert, you must set either this
   * field or the site_id field to specify the site associated with this placement group. This is a
   * required field that is read-only after insertion.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDirectorySiteId() {
    return directorySiteId;
  }

  /**
   * Directory site ID associated with this placement group. On insert, you must set either this
   * field or the site_id field to specify the site associated with this placement group. This is a
   * required field that is read-only after insertion.
   * @param directorySiteId directorySiteId or {@code null} for none
   */
  public PlacementGroup setDirectorySiteId(java.lang.Long directorySiteId) {
    this.directorySiteId = directorySiteId;
    return this;
  }

  /**
   * Dimension value for the ID of the directory site. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getDirectorySiteIdDimensionValue() {
    return directorySiteIdDimensionValue;
  }

  /**
   * Dimension value for the ID of the directory site. This is a read-only, auto-generated field.
   * @param directorySiteIdDimensionValue directorySiteIdDimensionValue or {@code null} for none
   */
  public PlacementGroup setDirectorySiteIdDimensionValue(DimensionValue directorySiteIdDimensionValue) {
    this.directorySiteIdDimensionValue = directorySiteIdDimensionValue;
    return this;
  }

  /**
   * External ID for this placement.
   * @return value or {@code null} for none
   */
  public java.lang.String getExternalId() {
    return externalId;
  }

  /**
   * External ID for this placement.
   * @param externalId externalId or {@code null} for none
   */
  public PlacementGroup setExternalId(java.lang.String externalId) {
    this.externalId = externalId;
    return this;
  }

  /**
   * ID of this placement group. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this placement group. This is a read-only, auto-generated field.
   * @param id id or {@code null} for none
   */
  public PlacementGroup setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Dimension value for the ID of this placement group. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getIdDimensionValue() {
    return idDimensionValue;
  }

  /**
   * Dimension value for the ID of this placement group. This is a read-only, auto-generated field.
   * @param idDimensionValue idDimensionValue or {@code null} for none
   */
  public PlacementGroup setIdDimensionValue(DimensionValue idDimensionValue) {
    this.idDimensionValue = idDimensionValue;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#placementGroup".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#placementGroup".
   * @param kind kind or {@code null} for none
   */
  public PlacementGroup setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Information about the most recent modification of this placement group. This is a read-only
   * field.
   * @return value or {@code null} for none
   */
  public LastModifiedInfo getLastModifiedInfo() {
    return lastModifiedInfo;
  }

  /**
   * Information about the most recent modification of this placement group. This is a read-only
   * field.
   * @param lastModifiedInfo lastModifiedInfo or {@code null} for none
   */
  public PlacementGroup setLastModifiedInfo(LastModifiedInfo lastModifiedInfo) {
    this.lastModifiedInfo = lastModifiedInfo;
    return this;
  }

  /**
   * Name of this placement group. This is a required field and must be less than 256 characters
   * long.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this placement group. This is a required field and must be less than 256 characters
   * long.
   * @param name name or {@code null} for none
   */
  public PlacementGroup setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Type of this placement group. A package is a simple group of placements that acts as a single
   * pricing point for a group of tags. A roadblock is a group of placements that not only acts as a
   * single pricing point, but also assumes that all the tags in it will be served at the same time.
   * A roadblock requires one of its assigned placements to be marked as primary for reporting. This
   * field is required on insertion.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlacementGroupType() {
    return placementGroupType;
  }

  /**
   * Type of this placement group. A package is a simple group of placements that acts as a single
   * pricing point for a group of tags. A roadblock is a group of placements that not only acts as a
   * single pricing point, but also assumes that all the tags in it will be served at the same time.
   * A roadblock requires one of its assigned placements to be marked as primary for reporting. This
   * field is required on insertion.
   * @param placementGroupType placementGroupType or {@code null} for none
   */
  public PlacementGroup setPlacementGroupType(java.lang.String placementGroupType) {
    this.placementGroupType = placementGroupType;
    return this;
  }

  /**
   * ID of the placement strategy assigned to this placement group.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPlacementStrategyId() {
    return placementStrategyId;
  }

  /**
   * ID of the placement strategy assigned to this placement group.
   * @param placementStrategyId placementStrategyId or {@code null} for none
   */
  public PlacementGroup setPlacementStrategyId(java.lang.Long placementStrategyId) {
    this.placementStrategyId = placementStrategyId;
    return this;
  }

  /**
   * Pricing schedule of this placement group. This field is required on insertion.
   * @return value or {@code null} for none
   */
  public PricingSchedule getPricingSchedule() {
    return pricingSchedule;
  }

  /**
   * Pricing schedule of this placement group. This field is required on insertion.
   * @param pricingSchedule pricingSchedule or {@code null} for none
   */
  public PlacementGroup setPricingSchedule(PricingSchedule pricingSchedule) {
    this.pricingSchedule = pricingSchedule;
    return this;
  }

  /**
   * ID of the primary placement, used to calculate the media cost of a roadblock (placement group).
   * Modifying this field will automatically modify the primary field on all affected roadblock
   * child placements.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPrimaryPlacementId() {
    return primaryPlacementId;
  }

  /**
   * ID of the primary placement, used to calculate the media cost of a roadblock (placement group).
   * Modifying this field will automatically modify the primary field on all affected roadblock
   * child placements.
   * @param primaryPlacementId primaryPlacementId or {@code null} for none
   */
  public PlacementGroup setPrimaryPlacementId(java.lang.Long primaryPlacementId) {
    this.primaryPlacementId = primaryPlacementId;
    return this;
  }

  /**
   * Dimension value for the ID of the primary placement. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getPrimaryPlacementIdDimensionValue() {
    return primaryPlacementIdDimensionValue;
  }

  /**
   * Dimension value for the ID of the primary placement. This is a read-only, auto-generated field.
   * @param primaryPlacementIdDimensionValue primaryPlacementIdDimensionValue or {@code null} for none
   */
  public PlacementGroup setPrimaryPlacementIdDimensionValue(DimensionValue primaryPlacementIdDimensionValue) {
    this.primaryPlacementIdDimensionValue = primaryPlacementIdDimensionValue;
    return this;
  }

  /**
   * Site ID associated with this placement group. On insert, you must set either this field or the
   * directorySiteId field to specify the site associated with this placement group. This is a
   * required field that is read-only after insertion.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSiteId() {
    return siteId;
  }

  /**
   * Site ID associated with this placement group. On insert, you must set either this field or the
   * directorySiteId field to specify the site associated with this placement group. This is a
   * required field that is read-only after insertion.
   * @param siteId siteId or {@code null} for none
   */
  public PlacementGroup setSiteId(java.lang.Long siteId) {
    this.siteId = siteId;
    return this;
  }

  /**
   * Dimension value for the ID of the site. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getSiteIdDimensionValue() {
    return siteIdDimensionValue;
  }

  /**
   * Dimension value for the ID of the site. This is a read-only, auto-generated field.
   * @param siteIdDimensionValue siteIdDimensionValue or {@code null} for none
   */
  public PlacementGroup setSiteIdDimensionValue(DimensionValue siteIdDimensionValue) {
    this.siteIdDimensionValue = siteIdDimensionValue;
    return this;
  }

  /**
   * Subaccount ID of this placement group. This is a read-only field that can be left blank.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSubaccountId() {
    return subaccountId;
  }

  /**
   * Subaccount ID of this placement group. This is a read-only field that can be left blank.
   * @param subaccountId subaccountId or {@code null} for none
   */
  public PlacementGroup setSubaccountId(java.lang.Long subaccountId) {
    this.subaccountId = subaccountId;
    return this;
  }

  @Override
  public PlacementGroup set(String fieldName, Object value) {
    return (PlacementGroup) super.set(fieldName, value);
  }

  @Override
  public PlacementGroup clone() {
    return (PlacementGroup) super.clone();
  }

}
