/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Pricing Period
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PricingSchedulePricingPeriod extends com.google.api.client.json.GenericJson {

  /**
   * Pricing period end date. This date must be later than, or the same day as, the pricing period
   * start date, but not later than the placement end date. The period end date can be the same date
   * as the period start date. If, for example, you set 6/25/2015 as both the start and end dates,
   * the effective pricing period date is just that day only, 6/25/2015. The hours, minutes, and
   * seconds of the end date should not be set, as doing so will result in an error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime endDate;

  /**
   * Comments for this pricing period.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pricingComment;

  /**
   * Rate or cost of this pricing period in nanos (i.e., multipled by 1000000000). Acceptable values
   * are 0 to 1000000000000000000, inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long rateOrCostNanos;

  /**
   * Pricing period start date. This date must be later than, or the same day as, the placement
   * start date. The hours, minutes, and seconds of the start date should not be set, as doing so
   * will result in an error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime startDate;

  /**
   * Units of this pricing period. Acceptable values are 0 to 10000000000, inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long units;

  /**
   * Pricing period end date. This date must be later than, or the same day as, the pricing period
   * start date, but not later than the placement end date. The period end date can be the same date
   * as the period start date. If, for example, you set 6/25/2015 as both the start and end dates,
   * the effective pricing period date is just that day only, 6/25/2015. The hours, minutes, and
   * seconds of the end date should not be set, as doing so will result in an error.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getEndDate() {
    return endDate;
  }

  /**
   * Pricing period end date. This date must be later than, or the same day as, the pricing period
   * start date, but not later than the placement end date. The period end date can be the same date
   * as the period start date. If, for example, you set 6/25/2015 as both the start and end dates,
   * the effective pricing period date is just that day only, 6/25/2015. The hours, minutes, and
   * seconds of the end date should not be set, as doing so will result in an error.
   * @param endDate endDate or {@code null} for none
   */
  public PricingSchedulePricingPeriod setEndDate(com.google.api.client.util.DateTime endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * Comments for this pricing period.
   * @return value or {@code null} for none
   */
  public java.lang.String getPricingComment() {
    return pricingComment;
  }

  /**
   * Comments for this pricing period.
   * @param pricingComment pricingComment or {@code null} for none
   */
  public PricingSchedulePricingPeriod setPricingComment(java.lang.String pricingComment) {
    this.pricingComment = pricingComment;
    return this;
  }

  /**
   * Rate or cost of this pricing period in nanos (i.e., multipled by 1000000000). Acceptable values
   * are 0 to 1000000000000000000, inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Long getRateOrCostNanos() {
    return rateOrCostNanos;
  }

  /**
   * Rate or cost of this pricing period in nanos (i.e., multipled by 1000000000). Acceptable values
   * are 0 to 1000000000000000000, inclusive.
   * @param rateOrCostNanos rateOrCostNanos or {@code null} for none
   */
  public PricingSchedulePricingPeriod setRateOrCostNanos(java.lang.Long rateOrCostNanos) {
    this.rateOrCostNanos = rateOrCostNanos;
    return this;
  }

  /**
   * Pricing period start date. This date must be later than, or the same day as, the placement
   * start date. The hours, minutes, and seconds of the start date should not be set, as doing so
   * will result in an error.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getStartDate() {
    return startDate;
  }

  /**
   * Pricing period start date. This date must be later than, or the same day as, the placement
   * start date. The hours, minutes, and seconds of the start date should not be set, as doing so
   * will result in an error.
   * @param startDate startDate or {@code null} for none
   */
  public PricingSchedulePricingPeriod setStartDate(com.google.api.client.util.DateTime startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * Units of this pricing period. Acceptable values are 0 to 10000000000, inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Long getUnits() {
    return units;
  }

  /**
   * Units of this pricing period. Acceptable values are 0 to 10000000000, inclusive.
   * @param units units or {@code null} for none
   */
  public PricingSchedulePricingPeriod setUnits(java.lang.Long units) {
    this.units = units;
    return this;
  }

  @Override
  public PricingSchedulePricingPeriod set(String fieldName, Object value) {
    return (PricingSchedulePricingPeriod) super.set(fieldName, value);
  }

  @Override
  public PricingSchedulePricingPeriod clone() {
    return (PricingSchedulePricingPeriod) super.clone();
  }

}
