/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains information about a region that can be targeted by ads.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Region extends com.google.api.client.json.GenericJson {

  /**
   * Country code of the country to which this region belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String countryCode;

  /**
   * DART ID of the country to which this region belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long countryDartId;

  /**
   * DART ID of this region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long dartId;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#region".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of this region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Region code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String regionCode;

  /**
   * Country code of the country to which this region belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountryCode() {
    return countryCode;
  }

  /**
   * Country code of the country to which this region belongs.
   * @param countryCode countryCode or {@code null} for none
   */
  public Region setCountryCode(java.lang.String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * DART ID of the country to which this region belongs.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCountryDartId() {
    return countryDartId;
  }

  /**
   * DART ID of the country to which this region belongs.
   * @param countryDartId countryDartId or {@code null} for none
   */
  public Region setCountryDartId(java.lang.Long countryDartId) {
    this.countryDartId = countryDartId;
    return this;
  }

  /**
   * DART ID of this region.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDartId() {
    return dartId;
  }

  /**
   * DART ID of this region.
   * @param dartId dartId or {@code null} for none
   */
  public Region setDartId(java.lang.Long dartId) {
    this.dartId = dartId;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#region".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#region".
   * @param kind kind or {@code null} for none
   */
  public Region setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of this region.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this region.
   * @param name name or {@code null} for none
   */
  public Region setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Region code.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegionCode() {
    return regionCode;
  }

  /**
   * Region code.
   * @param regionCode regionCode or {@code null} for none
   */
  public Region setRegionCode(java.lang.String regionCode) {
    this.regionCode = regionCode;
    return this;
  }

  @Override
  public Region set(String fieldName, Object value) {
    return (Region) super.set(fieldName, value);
  }

  @Override
  public Region clone() {
    return (Region) super.clone();
  }

}
