/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains properties of a remarketing list. Remarketing enables you to create lists of users who
 * have performed specific actions on a site, then target ads to members of those lists. This
 * resource can be used to manage remarketing lists that are owned by your advertisers. To see all
 * remarketing lists that are visible to your advertisers, including those that are shared to your
 * advertiser or account, use the TargetableRemarketingLists resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RemarketingList extends com.google.api.client.json.GenericJson {

  /**
   * Account ID of this remarketing list. This is a read-only, auto-generated field that is only
   * returned in GET requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * Whether this remarketing list is active.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean active;

  /**
   * Dimension value for the advertiser ID that owns this remarketing list. This is a required
   * field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long advertiserId;

  /**
   * Dimension value for the ID of the advertiser. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue advertiserIdDimensionValue;

  /**
   * Remarketing list description.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Remarketing list ID. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#remarketingList".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Number of days that a user should remain in the remarketing list without an impression.
   * Acceptable values are 1 to 540, inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long lifeSpan;

  /**
   * Rule used to populate the remarketing list with users.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ListPopulationRule listPopulationRule;

  /**
   * Number of users currently in the list. This is a read-only field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long listSize;

  /**
   * Product from which this remarketing list was originated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String listSource;

  /**
   * Name of the remarketing list. This is a required field. Must be no greater than 128 characters
   * long.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Subaccount ID of this remarketing list. This is a read-only, auto-generated field that is only
   * returned in GET requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long subaccountId;

  /**
   * Account ID of this remarketing list. This is a read-only, auto-generated field that is only
   * returned in GET requests.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * Account ID of this remarketing list. This is a read-only, auto-generated field that is only
   * returned in GET requests.
   * @param accountId accountId or {@code null} for none
   */
  public RemarketingList setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Whether this remarketing list is active.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getActive() {
    return active;
  }

  /**
   * Whether this remarketing list is active.
   * @param active active or {@code null} for none
   */
  public RemarketingList setActive(java.lang.Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * Dimension value for the advertiser ID that owns this remarketing list. This is a required
   * field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAdvertiserId() {
    return advertiserId;
  }

  /**
   * Dimension value for the advertiser ID that owns this remarketing list. This is a required
   * field.
   * @param advertiserId advertiserId or {@code null} for none
   */
  public RemarketingList setAdvertiserId(java.lang.Long advertiserId) {
    this.advertiserId = advertiserId;
    return this;
  }

  /**
   * Dimension value for the ID of the advertiser. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getAdvertiserIdDimensionValue() {
    return advertiserIdDimensionValue;
  }

  /**
   * Dimension value for the ID of the advertiser. This is a read-only, auto-generated field.
   * @param advertiserIdDimensionValue advertiserIdDimensionValue or {@code null} for none
   */
  public RemarketingList setAdvertiserIdDimensionValue(DimensionValue advertiserIdDimensionValue) {
    this.advertiserIdDimensionValue = advertiserIdDimensionValue;
    return this;
  }

  /**
   * Remarketing list description.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Remarketing list description.
   * @param description description or {@code null} for none
   */
  public RemarketingList setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Remarketing list ID. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * Remarketing list ID. This is a read-only, auto-generated field.
   * @param id id or {@code null} for none
   */
  public RemarketingList setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#remarketingList".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#remarketingList".
   * @param kind kind or {@code null} for none
   */
  public RemarketingList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Number of days that a user should remain in the remarketing list without an impression.
   * Acceptable values are 1 to 540, inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLifeSpan() {
    return lifeSpan;
  }

  /**
   * Number of days that a user should remain in the remarketing list without an impression.
   * Acceptable values are 1 to 540, inclusive.
   * @param lifeSpan lifeSpan or {@code null} for none
   */
  public RemarketingList setLifeSpan(java.lang.Long lifeSpan) {
    this.lifeSpan = lifeSpan;
    return this;
  }

  /**
   * Rule used to populate the remarketing list with users.
   * @return value or {@code null} for none
   */
  public ListPopulationRule getListPopulationRule() {
    return listPopulationRule;
  }

  /**
   * Rule used to populate the remarketing list with users.
   * @param listPopulationRule listPopulationRule or {@code null} for none
   */
  public RemarketingList setListPopulationRule(ListPopulationRule listPopulationRule) {
    this.listPopulationRule = listPopulationRule;
    return this;
  }

  /**
   * Number of users currently in the list. This is a read-only field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getListSize() {
    return listSize;
  }

  /**
   * Number of users currently in the list. This is a read-only field.
   * @param listSize listSize or {@code null} for none
   */
  public RemarketingList setListSize(java.lang.Long listSize) {
    this.listSize = listSize;
    return this;
  }

  /**
   * Product from which this remarketing list was originated.
   * @return value or {@code null} for none
   */
  public java.lang.String getListSource() {
    return listSource;
  }

  /**
   * Product from which this remarketing list was originated.
   * @param listSource listSource or {@code null} for none
   */
  public RemarketingList setListSource(java.lang.String listSource) {
    this.listSource = listSource;
    return this;
  }

  /**
   * Name of the remarketing list. This is a required field. Must be no greater than 128 characters
   * long.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the remarketing list. This is a required field. Must be no greater than 128 characters
   * long.
   * @param name name or {@code null} for none
   */
  public RemarketingList setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Subaccount ID of this remarketing list. This is a read-only, auto-generated field that is only
   * returned in GET requests.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSubaccountId() {
    return subaccountId;
  }

  /**
   * Subaccount ID of this remarketing list. This is a read-only, auto-generated field that is only
   * returned in GET requests.
   * @param subaccountId subaccountId or {@code null} for none
   */
  public RemarketingList setSubaccountId(java.lang.Long subaccountId) {
    this.subaccountId = subaccountId;
    return this;
  }

  @Override
  public RemarketingList set(String fieldName, Object value) {
    return (RemarketingList) super.set(fieldName, value);
  }

  @Override
  public RemarketingList clone() {
    return (RemarketingList) super.clone();
  }

}
