/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * A rule associates an asset with a targeting template for asset-level targeting. Applicable to
 * INSTREAM_VIDEO creatives.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Rule extends com.google.api.client.json.GenericJson {

  /**
   * A creativeAssets[].id. This should refer to one of the parent assets in this creative. This is
   * a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long assetId;

  /**
   * A user-friendly name for this rule. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * A targeting template ID. The targeting from the targeting template will be used to determine
   * whether this asset should be served. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long targetingTemplateId;

  /**
   * A creativeAssets[].id. This should refer to one of the parent assets in this creative. This is
   * a required field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAssetId() {
    return assetId;
  }

  /**
   * A creativeAssets[].id. This should refer to one of the parent assets in this creative. This is
   * a required field.
   * @param assetId assetId or {@code null} for none
   */
  public Rule setAssetId(java.lang.Long assetId) {
    this.assetId = assetId;
    return this;
  }

  /**
   * A user-friendly name for this rule. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * A user-friendly name for this rule. This is a required field.
   * @param name name or {@code null} for none
   */
  public Rule setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * A targeting template ID. The targeting from the targeting template will be used to determine
   * whether this asset should be served. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTargetingTemplateId() {
    return targetingTemplateId;
  }

  /**
   * A targeting template ID. The targeting from the targeting template will be used to determine
   * whether this asset should be served. This is a required field.
   * @param targetingTemplateId targetingTemplateId or {@code null} for none
   */
  public Rule setTargetingTemplateId(java.lang.Long targetingTemplateId) {
    this.targetingTemplateId = targetingTemplateId;
    return this;
  }

  @Override
  public Rule set(String fieldName, Object value) {
    return (Rule) super.set(fieldName, value);
  }

  @Override
  public Rule clone() {
    return (Rule) super.clone();
  }

}
