/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Tag Settings
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TagSetting extends com.google.api.client.json.GenericJson {

  /**
   * Additional key-values to be included in tags. Each key-value pair must be of the form
   * key=value, and pairs must be separated by a semicolon (;). Keys and values must not contain
   * commas. For example, id=2;color=red is a valid value for this field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String additionalKeyValues;

  /**
   * Whether static landing page URLs should be included in the tags. This setting applies only to
   * placements.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean includeClickThroughUrls;

  /**
   * Whether click-tracking string should be included in the tags.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean includeClickTracking;

  /**
   * Option specifying how keywords are embedded in ad tags. This setting can be used to specify
   * whether keyword placeholders are inserted in placement tags for this site. Publishers can then
   * add keywords to those placeholders.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String keywordOption;

  /**
   * Additional key-values to be included in tags. Each key-value pair must be of the form
   * key=value, and pairs must be separated by a semicolon (;). Keys and values must not contain
   * commas. For example, id=2;color=red is a valid value for this field.
   * @return value or {@code null} for none
   */
  public java.lang.String getAdditionalKeyValues() {
    return additionalKeyValues;
  }

  /**
   * Additional key-values to be included in tags. Each key-value pair must be of the form
   * key=value, and pairs must be separated by a semicolon (;). Keys and values must not contain
   * commas. For example, id=2;color=red is a valid value for this field.
   * @param additionalKeyValues additionalKeyValues or {@code null} for none
   */
  public TagSetting setAdditionalKeyValues(java.lang.String additionalKeyValues) {
    this.additionalKeyValues = additionalKeyValues;
    return this;
  }

  /**
   * Whether static landing page URLs should be included in the tags. This setting applies only to
   * placements.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIncludeClickThroughUrls() {
    return includeClickThroughUrls;
  }

  /**
   * Whether static landing page URLs should be included in the tags. This setting applies only to
   * placements.
   * @param includeClickThroughUrls includeClickThroughUrls or {@code null} for none
   */
  public TagSetting setIncludeClickThroughUrls(java.lang.Boolean includeClickThroughUrls) {
    this.includeClickThroughUrls = includeClickThroughUrls;
    return this;
  }

  /**
   * Whether click-tracking string should be included in the tags.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIncludeClickTracking() {
    return includeClickTracking;
  }

  /**
   * Whether click-tracking string should be included in the tags.
   * @param includeClickTracking includeClickTracking or {@code null} for none
   */
  public TagSetting setIncludeClickTracking(java.lang.Boolean includeClickTracking) {
    this.includeClickTracking = includeClickTracking;
    return this;
  }

  /**
   * Option specifying how keywords are embedded in ad tags. This setting can be used to specify
   * whether keyword placeholders are inserted in placement tags for this site. Publishers can then
   * add keywords to those placeholders.
   * @return value or {@code null} for none
   */
  public java.lang.String getKeywordOption() {
    return keywordOption;
  }

  /**
   * Option specifying how keywords are embedded in ad tags. This setting can be used to specify
   * whether keyword placeholders are inserted in placement tags for this site. Publishers can then
   * add keywords to those placeholders.
   * @param keywordOption keywordOption or {@code null} for none
   */
  public TagSetting setKeywordOption(java.lang.String keywordOption) {
    this.keywordOption = keywordOption;
    return this;
  }

  @Override
  public TagSetting set(String fieldName, Object value) {
    return (TagSetting) super.set(fieldName, value);
  }

  @Override
  public TagSetting clone() {
    return (TagSetting) super.clone();
  }

}
