/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Represents the list of user profiles.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UserProfileList extends com.google.api.client.json.GenericJson {

  /**
   * The eTag of this response for caching purposes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The user profiles returned in this response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UserProfile> items;

  static {
    // hack to force ProGuard to consider UserProfile used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(UserProfile.class);
  }

  /**
   * The kind of list this is, in this case dfareporting#userProfileList.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The eTag of this response for caching purposes.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * The eTag of this response for caching purposes.
   * @param etag etag or {@code null} for none
   */
  public UserProfileList setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The user profiles returned in this response.
   * @return value or {@code null} for none
   */
  public java.util.List<UserProfile> getItems() {
    return items;
  }

  /**
   * The user profiles returned in this response.
   * @param items items or {@code null} for none
   */
  public UserProfileList setItems(java.util.List<UserProfile> items) {
    this.items = items;
    return this;
  }

  /**
   * The kind of list this is, in this case dfareporting#userProfileList.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of list this is, in this case dfareporting#userProfileList.
   * @param kind kind or {@code null} for none
   */
  public UserProfileList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public UserProfileList set(String fieldName, Object value) {
    return (UserProfileList) super.set(fieldName, value);
  }

  @Override
  public UserProfileList clone() {
    return (UserProfileList) super.clone();
  }

}
