/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains properties of auser role, which is used to manage user access.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UserRole extends com.google.api.client.json.GenericJson {

  /**
   * Account ID of this user role. This is a read-only field that can be left blank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * Whether this is a default user role. Default user roles are created by the system for the
   * account/subaccount and cannot be modified or deleted. Each default user role comes with a basic
   * set of preassigned permissions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean defaultUserRole;

  /**
   * ID of this user role. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#userRole".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of this user role. This is a required field. Must be less than 256 characters long. If
   * this user role is under a subaccount, the name must be unique among sites of the same
   * subaccount. Otherwise, this user role is a top-level user role, and the name must be unique
   * among top-level user roles of the same account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * ID of the user role that this user role is based on or copied from. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long parentUserRoleId;

  /**
   * List of permissions associated with this user role.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UserRolePermission> permissions;

  /**
   * Subaccount ID of this user role. This is a read-only field that can be left blank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long subaccountId;

  /**
   * Account ID of this user role. This is a read-only field that can be left blank.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * Account ID of this user role. This is a read-only field that can be left blank.
   * @param accountId accountId or {@code null} for none
   */
  public UserRole setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Whether this is a default user role. Default user roles are created by the system for the
   * account/subaccount and cannot be modified or deleted. Each default user role comes with a basic
   * set of preassigned permissions.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDefaultUserRole() {
    return defaultUserRole;
  }

  /**
   * Whether this is a default user role. Default user roles are created by the system for the
   * account/subaccount and cannot be modified or deleted. Each default user role comes with a basic
   * set of preassigned permissions.
   * @param defaultUserRole defaultUserRole or {@code null} for none
   */
  public UserRole setDefaultUserRole(java.lang.Boolean defaultUserRole) {
    this.defaultUserRole = defaultUserRole;
    return this;
  }

  /**
   * ID of this user role. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this user role. This is a read-only, auto-generated field.
   * @param id id or {@code null} for none
   */
  public UserRole setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#userRole".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#userRole".
   * @param kind kind or {@code null} for none
   */
  public UserRole setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of this user role. This is a required field. Must be less than 256 characters long. If
   * this user role is under a subaccount, the name must be unique among sites of the same
   * subaccount. Otherwise, this user role is a top-level user role, and the name must be unique
   * among top-level user roles of the same account.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this user role. This is a required field. Must be less than 256 characters long. If
   * this user role is under a subaccount, the name must be unique among sites of the same
   * subaccount. Otherwise, this user role is a top-level user role, and the name must be unique
   * among top-level user roles of the same account.
   * @param name name or {@code null} for none
   */
  public UserRole setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * ID of the user role that this user role is based on or copied from. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getParentUserRoleId() {
    return parentUserRoleId;
  }

  /**
   * ID of the user role that this user role is based on or copied from. This is a required field.
   * @param parentUserRoleId parentUserRoleId or {@code null} for none
   */
  public UserRole setParentUserRoleId(java.lang.Long parentUserRoleId) {
    this.parentUserRoleId = parentUserRoleId;
    return this;
  }

  /**
   * List of permissions associated with this user role.
   * @return value or {@code null} for none
   */
  public java.util.List<UserRolePermission> getPermissions() {
    return permissions;
  }

  /**
   * List of permissions associated with this user role.
   * @param permissions permissions or {@code null} for none
   */
  public UserRole setPermissions(java.util.List<UserRolePermission> permissions) {
    this.permissions = permissions;
    return this;
  }

  /**
   * Subaccount ID of this user role. This is a read-only field that can be left blank.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSubaccountId() {
    return subaccountId;
  }

  /**
   * Subaccount ID of this user role. This is a read-only field that can be left blank.
   * @param subaccountId subaccountId or {@code null} for none
   */
  public UserRole setSubaccountId(java.lang.Long subaccountId) {
    this.subaccountId = subaccountId;
    return this;
  }

  @Override
  public UserRole set(String fieldName, Object value) {
    return (UserRole) super.set(fieldName, value);
  }

  @Override
  public UserRole clone() {
    return (UserRole) super.clone();
  }

}
