/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains properties of a user role permission.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UserRolePermission extends com.google.api.client.json.GenericJson {

  /**
   * Levels of availability for a user role permission.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String availability;

  /**
   * ID of this user role permission.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#userRolePermission".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of this user role permission.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * ID of the permission group that this user role permission belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long permissionGroupId;

  /**
   * Levels of availability for a user role permission.
   * @return value or {@code null} for none
   */
  public java.lang.String getAvailability() {
    return availability;
  }

  /**
   * Levels of availability for a user role permission.
   * @param availability availability or {@code null} for none
   */
  public UserRolePermission setAvailability(java.lang.String availability) {
    this.availability = availability;
    return this;
  }

  /**
   * ID of this user role permission.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this user role permission.
   * @param id id or {@code null} for none
   */
  public UserRolePermission setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#userRolePermission".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#userRolePermission".
   * @param kind kind or {@code null} for none
   */
  public UserRolePermission setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of this user role permission.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this user role permission.
   * @param name name or {@code null} for none
   */
  public UserRolePermission setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * ID of the permission group that this user role permission belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPermissionGroupId() {
    return permissionGroupId;
  }

  /**
   * ID of the permission group that this user role permission belongs to.
   * @param permissionGroupId permissionGroupId or {@code null} for none
   */
  public UserRolePermission setPermissionGroupId(java.lang.Long permissionGroupId) {
    this.permissionGroupId = permissionGroupId;
    return this;
  }

  @Override
  public UserRolePermission set(String fieldName, Object value) {
    return (UserRolePermission) super.set(fieldName, value);
  }

  @Override
  public UserRolePermission clone() {
    return (UserRolePermission) super.clone();
  }

}
