/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains information about supported video formats.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VideoFormat extends com.google.api.client.json.GenericJson {

  /**
   * File type of the video format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileType;

  /**
   * ID of the video format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#videoFormat".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The resolution of this video format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Size resolution;

  /**
   * The target bit rate of this video format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer targetBitRate;

  /**
   * File type of the video format.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileType() {
    return fileType;
  }

  /**
   * File type of the video format.
   * @param fileType fileType or {@code null} for none
   */
  public VideoFormat setFileType(java.lang.String fileType) {
    this.fileType = fileType;
    return this;
  }

  /**
   * ID of the video format.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getId() {
    return id;
  }

  /**
   * ID of the video format.
   * @param id id or {@code null} for none
   */
  public VideoFormat setId(java.lang.Integer id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#videoFormat".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#videoFormat".
   * @param kind kind or {@code null} for none
   */
  public VideoFormat setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The resolution of this video format.
   * @return value or {@code null} for none
   */
  public Size getResolution() {
    return resolution;
  }

  /**
   * The resolution of this video format.
   * @param resolution resolution or {@code null} for none
   */
  public VideoFormat setResolution(Size resolution) {
    this.resolution = resolution;
    return this;
  }

  /**
   * The target bit rate of this video format.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTargetBitRate() {
    return targetBitRate;
  }

  /**
   * The target bit rate of this video format.
   * @param targetBitRate targetBitRate or {@code null} for none
   */
  public VideoFormat setTargetBitRate(java.lang.Integer targetBitRate) {
    this.targetBitRate = targetBitRate;
    return this;
  }

  @Override
  public VideoFormat set(String fieldName, Object value) {
    return (VideoFormat) super.set(fieldName, value);
  }

  @Override
  public VideoFormat clone() {
    return (VideoFormat) super.clone();
  }

}
