# Campaign Manager 360 API Client Library for Java

Build applications to efficiently manage large or complex trafficking, reporting, and attribution workflows for Campaign Manager 360.

This page contains information about getting started with the Campaign Manager 360 API
using the Google API Client Library for Java. In addition, you may be interested
in the following documentation:

* Browse the [Javadoc reference for the Campaign Manager 360 API][javadoc]
* Read the [Developer's Guide for the Google API Client Library for Java][google-api-client].
* Interact with this API in your browser using the [APIs Explorer for the Campaign Manager 360 API][api-explorer]

## Installation

### Maven

Add the following lines to your `pom.xml` file:

```xml
<project>
  <dependencies>
    <dependency>
      <groupId>com.google.apis</groupId>
      <artifactId>google-api-services-dfareporting</artifactId>
      <version>v4-rev20220920-2.0.0</version>
    </dependency>
  </dependencies>
</project>
```

### Gradle

```gradle
repositories {
  mavenCentral()
}
dependencies {
  implementation 'com.google.apis:google-api-services-dfareporting:v4-rev20220920-2.0.0'
}
```

[javadoc]: https://googleapis.dev/java/google-api-services-dfareporting/latest/index.html
[google-api-client]: https://github.com/googleapis/google-api-java-client/
[api-explorer]: https://developers.google.com/apis-explorer/#p/dfareporting/v1/
