/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Identifies a creative which has been associated with a given campaign.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CampaignCreativeAssociation extends com.google.api.client.json.GenericJson {

  /**
   * ID of the creative associated with the campaign. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long creativeId;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#campaignCreativeAssociation".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * ID of the creative associated with the campaign. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCreativeId() {
    return creativeId;
  }

  /**
   * ID of the creative associated with the campaign. This is a required field.
   * @param creativeId creativeId or {@code null} for none
   */
  public CampaignCreativeAssociation setCreativeId(java.lang.Long creativeId) {
    this.creativeId = creativeId;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#campaignCreativeAssociation".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#campaignCreativeAssociation".
   * @param kind kind or {@code null} for none
   */
  public CampaignCreativeAssociation setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public CampaignCreativeAssociation set(String fieldName, Object value) {
    return (CampaignCreativeAssociation) super.set(fieldName, value);
  }

  @Override
  public CampaignCreativeAssociation clone() {
    return (CampaignCreativeAssociation) super.clone();
  }

}
