/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Represents a summarized campaign information associated with this invoice.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CampaignSummary extends com.google.api.client.json.GenericJson {

  /**
   * Campaign billing invoice code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String billingInvoiceCode;

  /**
   * Campaign ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long campaignId;

  /**
   * The pre-tax amount for this campaign, in micros of the invoice's currency.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long preTaxAmountMicros;

  /**
   * The tax amount for this campaign, in micros of the invoice's currency.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long taxAmountMicros;

  /**
   * The total amount of charges for this campaign, in micros of the invoice's currency.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long totalAmountMicros;

  /**
   * Campaign billing invoice code.
   * @return value or {@code null} for none
   */
  public java.lang.String getBillingInvoiceCode() {
    return billingInvoiceCode;
  }

  /**
   * Campaign billing invoice code.
   * @param billingInvoiceCode billingInvoiceCode or {@code null} for none
   */
  public CampaignSummary setBillingInvoiceCode(java.lang.String billingInvoiceCode) {
    this.billingInvoiceCode = billingInvoiceCode;
    return this;
  }

  /**
   * Campaign ID.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCampaignId() {
    return campaignId;
  }

  /**
   * Campaign ID.
   * @param campaignId campaignId or {@code null} for none
   */
  public CampaignSummary setCampaignId(java.lang.Long campaignId) {
    this.campaignId = campaignId;
    return this;
  }

  /**
   * The pre-tax amount for this campaign, in micros of the invoice's currency.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPreTaxAmountMicros() {
    return preTaxAmountMicros;
  }

  /**
   * The pre-tax amount for this campaign, in micros of the invoice's currency.
   * @param preTaxAmountMicros preTaxAmountMicros or {@code null} for none
   */
  public CampaignSummary setPreTaxAmountMicros(java.lang.Long preTaxAmountMicros) {
    this.preTaxAmountMicros = preTaxAmountMicros;
    return this;
  }

  /**
   * The tax amount for this campaign, in micros of the invoice's currency.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTaxAmountMicros() {
    return taxAmountMicros;
  }

  /**
   * The tax amount for this campaign, in micros of the invoice's currency.
   * @param taxAmountMicros taxAmountMicros or {@code null} for none
   */
  public CampaignSummary setTaxAmountMicros(java.lang.Long taxAmountMicros) {
    this.taxAmountMicros = taxAmountMicros;
    return this;
  }

  /**
   * The total amount of charges for this campaign, in micros of the invoice's currency.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTotalAmountMicros() {
    return totalAmountMicros;
  }

  /**
   * The total amount of charges for this campaign, in micros of the invoice's currency.
   * @param totalAmountMicros totalAmountMicros or {@code null} for none
   */
  public CampaignSummary setTotalAmountMicros(java.lang.Long totalAmountMicros) {
    this.totalAmountMicros = totalAmountMicros;
    return this;
  }

  @Override
  public CampaignSummary set(String fieldName, Object value) {
    return (CampaignSummary) super.set(fieldName, value);
  }

  @Override
  public CampaignSummary clone() {
    return (CampaignSummary) super.clone();
  }

}
