/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Publisher Dynamic Tag
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FloodlightActivityPublisherDynamicTag extends com.google.api.client.json.GenericJson {

  /**
   * Whether this tag is applicable only for click-throughs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean clickThrough;

  /**
   * Directory site ID of this dynamic tag. This is a write-only field that can be used as an
   * alternative to the siteId field. When this resource is retrieved, only the siteId field will be
   * populated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long directorySiteId;

  /**
   * Dynamic floodlight tag.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FloodlightActivityDynamicTag dynamicTag;

  /**
   * Site ID of this dynamic tag.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long siteId;

  /**
   * Dimension value for the ID of the site. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue siteIdDimensionValue;

  /**
   * Whether this tag is applicable only for view-throughs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean viewThrough;

  /**
   * Whether this tag is applicable only for click-throughs.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getClickThrough() {
    return clickThrough;
  }

  /**
   * Whether this tag is applicable only for click-throughs.
   * @param clickThrough clickThrough or {@code null} for none
   */
  public FloodlightActivityPublisherDynamicTag setClickThrough(java.lang.Boolean clickThrough) {
    this.clickThrough = clickThrough;
    return this;
  }

  /**
   * Directory site ID of this dynamic tag. This is a write-only field that can be used as an
   * alternative to the siteId field. When this resource is retrieved, only the siteId field will be
   * populated.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDirectorySiteId() {
    return directorySiteId;
  }

  /**
   * Directory site ID of this dynamic tag. This is a write-only field that can be used as an
   * alternative to the siteId field. When this resource is retrieved, only the siteId field will be
   * populated.
   * @param directorySiteId directorySiteId or {@code null} for none
   */
  public FloodlightActivityPublisherDynamicTag setDirectorySiteId(java.lang.Long directorySiteId) {
    this.directorySiteId = directorySiteId;
    return this;
  }

  /**
   * Dynamic floodlight tag.
   * @return value or {@code null} for none
   */
  public FloodlightActivityDynamicTag getDynamicTag() {
    return dynamicTag;
  }

  /**
   * Dynamic floodlight tag.
   * @param dynamicTag dynamicTag or {@code null} for none
   */
  public FloodlightActivityPublisherDynamicTag setDynamicTag(FloodlightActivityDynamicTag dynamicTag) {
    this.dynamicTag = dynamicTag;
    return this;
  }

  /**
   * Site ID of this dynamic tag.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSiteId() {
    return siteId;
  }

  /**
   * Site ID of this dynamic tag.
   * @param siteId siteId or {@code null} for none
   */
  public FloodlightActivityPublisherDynamicTag setSiteId(java.lang.Long siteId) {
    this.siteId = siteId;
    return this;
  }

  /**
   * Dimension value for the ID of the site. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getSiteIdDimensionValue() {
    return siteIdDimensionValue;
  }

  /**
   * Dimension value for the ID of the site. This is a read-only, auto-generated field.
   * @param siteIdDimensionValue siteIdDimensionValue or {@code null} for none
   */
  public FloodlightActivityPublisherDynamicTag setSiteIdDimensionValue(DimensionValue siteIdDimensionValue) {
    this.siteIdDimensionValue = siteIdDimensionValue;
    return this;
  }

  /**
   * Whether this tag is applicable only for view-throughs.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getViewThrough() {
    return viewThrough;
  }

  /**
   * Whether this tag is applicable only for view-throughs.
   * @param viewThrough viewThrough or {@code null} for none
   */
  public FloodlightActivityPublisherDynamicTag setViewThrough(java.lang.Boolean viewThrough) {
    this.viewThrough = viewThrough;
    return this;
  }

  @Override
  public FloodlightActivityPublisherDynamicTag set(String fieldName, Object value) {
    return (FloodlightActivityPublisherDynamicTag) super.set(fieldName, value);
  }

  @Override
  public FloodlightActivityPublisherDynamicTag clone() {
    return (FloodlightActivityPublisherDynamicTag) super.clone();
  }

}
