/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains information about a single invoice
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Invoice extends com.google.api.client.json.GenericJson {

  /**
   * The list of summarized campaign information associated with this invoice.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("campaign_summaries")
  private java.util.List<CampaignSummary> campaignSummaries;

  static {
    // hack to force ProGuard to consider CampaignSummary used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(CampaignSummary.class);
  }

  /**
   * The originally issued invoice that is being adjusted by this invoice, if applicable. May appear
   * on invoice PDF as *Reference invoice number*.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String correctedInvoiceId;

  /**
   * Invoice currency code in ISO 4217 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currencyCode;

  /**
   * The invoice due date.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dueDate;

  /**
   * ID of this invoice.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The type of invoice document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String invoiceType;

  /**
   * The date when the invoice was issued.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String issueDate;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#invoice".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The ID of the payments account the invoice belongs to. Appears on the invoice PDF as *Billing
   * Account Number*.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String paymentsAccountId;

  /**
   * The ID of the payments profile the invoice belongs to. Appears on the invoice PDF as *Billing
   * ID*.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String paymentsProfileId;

  /**
   * The URL to download a PDF copy of the invoice. Note that this URL is user specific and requires
   * a valid OAuth 2.0 access token to access. The access token must be provided in an
   * *Authorization: Bearer* HTTP header. The URL will only be usable for 7 days from when the api
   * is called.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pdfUrl;

  /**
   * Purchase order number associated with the invoice.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String purchaseOrderNumber;

  /**
   * The originally issued invoice(s) that is being cancelled by this invoice, if applicable. May
   * appear on invoice PDF as *Replaced invoice numbers*. Note: There may be multiple replaced
   * invoices due to consolidation of multiple invoices into a single invoice.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> replacedInvoiceIds;

  /**
   * The invoice service end date.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String serviceEndDate;

  /**
   * The invoice service start date.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String serviceStartDate;

  /**
   * The pre-tax subtotal amount, in micros of the invoice's currency.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long subtotalAmountMicros;

  /**
   * The invoice total amount, in micros of the invoice's currency.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long totalAmountMicros;

  /**
   * The sum of all taxes in invoice, in micros of the invoice's currency.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long totalTaxAmountMicros;

  /**
   * The list of summarized campaign information associated with this invoice.
   * @return value or {@code null} for none
   */
  public java.util.List<CampaignSummary> getCampaignSummaries() {
    return campaignSummaries;
  }

  /**
   * The list of summarized campaign information associated with this invoice.
   * @param campaignSummaries campaignSummaries or {@code null} for none
   */
  public Invoice setCampaignSummaries(java.util.List<CampaignSummary> campaignSummaries) {
    this.campaignSummaries = campaignSummaries;
    return this;
  }

  /**
   * The originally issued invoice that is being adjusted by this invoice, if applicable. May appear
   * on invoice PDF as *Reference invoice number*.
   * @return value or {@code null} for none
   */
  public java.lang.String getCorrectedInvoiceId() {
    return correctedInvoiceId;
  }

  /**
   * The originally issued invoice that is being adjusted by this invoice, if applicable. May appear
   * on invoice PDF as *Reference invoice number*.
   * @param correctedInvoiceId correctedInvoiceId or {@code null} for none
   */
  public Invoice setCorrectedInvoiceId(java.lang.String correctedInvoiceId) {
    this.correctedInvoiceId = correctedInvoiceId;
    return this;
  }

  /**
   * Invoice currency code in ISO 4217 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrencyCode() {
    return currencyCode;
  }

  /**
   * Invoice currency code in ISO 4217 format.
   * @param currencyCode currencyCode or {@code null} for none
   */
  public Invoice setCurrencyCode(java.lang.String currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * The invoice due date.
   * @return value or {@code null} for none
   */
  public java.lang.String getDueDate() {
    return dueDate;
  }

  /**
   * The invoice due date.
   * @param dueDate dueDate or {@code null} for none
   */
  public Invoice setDueDate(java.lang.String dueDate) {
    this.dueDate = dueDate;
    return this;
  }

  /**
   * ID of this invoice.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * ID of this invoice.
   * @param id id or {@code null} for none
   */
  public Invoice setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The type of invoice document.
   * @return value or {@code null} for none
   */
  public java.lang.String getInvoiceType() {
    return invoiceType;
  }

  /**
   * The type of invoice document.
   * @param invoiceType invoiceType or {@code null} for none
   */
  public Invoice setInvoiceType(java.lang.String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

  /**
   * The date when the invoice was issued.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssueDate() {
    return issueDate;
  }

  /**
   * The date when the invoice was issued.
   * @param issueDate issueDate or {@code null} for none
   */
  public Invoice setIssueDate(java.lang.String issueDate) {
    this.issueDate = issueDate;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#invoice".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#invoice".
   * @param kind kind or {@code null} for none
   */
  public Invoice setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The ID of the payments account the invoice belongs to. Appears on the invoice PDF as *Billing
   * Account Number*.
   * @return value or {@code null} for none
   */
  public java.lang.String getPaymentsAccountId() {
    return paymentsAccountId;
  }

  /**
   * The ID of the payments account the invoice belongs to. Appears on the invoice PDF as *Billing
   * Account Number*.
   * @param paymentsAccountId paymentsAccountId or {@code null} for none
   */
  public Invoice setPaymentsAccountId(java.lang.String paymentsAccountId) {
    this.paymentsAccountId = paymentsAccountId;
    return this;
  }

  /**
   * The ID of the payments profile the invoice belongs to. Appears on the invoice PDF as *Billing
   * ID*.
   * @return value or {@code null} for none
   */
  public java.lang.String getPaymentsProfileId() {
    return paymentsProfileId;
  }

  /**
   * The ID of the payments profile the invoice belongs to. Appears on the invoice PDF as *Billing
   * ID*.
   * @param paymentsProfileId paymentsProfileId or {@code null} for none
   */
  public Invoice setPaymentsProfileId(java.lang.String paymentsProfileId) {
    this.paymentsProfileId = paymentsProfileId;
    return this;
  }

  /**
   * The URL to download a PDF copy of the invoice. Note that this URL is user specific and requires
   * a valid OAuth 2.0 access token to access. The access token must be provided in an
   * *Authorization: Bearer* HTTP header. The URL will only be usable for 7 days from when the api
   * is called.
   * @return value or {@code null} for none
   */
  public java.lang.String getPdfUrl() {
    return pdfUrl;
  }

  /**
   * The URL to download a PDF copy of the invoice. Note that this URL is user specific and requires
   * a valid OAuth 2.0 access token to access. The access token must be provided in an
   * *Authorization: Bearer* HTTP header. The URL will only be usable for 7 days from when the api
   * is called.
   * @param pdfUrl pdfUrl or {@code null} for none
   */
  public Invoice setPdfUrl(java.lang.String pdfUrl) {
    this.pdfUrl = pdfUrl;
    return this;
  }

  /**
   * Purchase order number associated with the invoice.
   * @return value or {@code null} for none
   */
  public java.lang.String getPurchaseOrderNumber() {
    return purchaseOrderNumber;
  }

  /**
   * Purchase order number associated with the invoice.
   * @param purchaseOrderNumber purchaseOrderNumber or {@code null} for none
   */
  public Invoice setPurchaseOrderNumber(java.lang.String purchaseOrderNumber) {
    this.purchaseOrderNumber = purchaseOrderNumber;
    return this;
  }

  /**
   * The originally issued invoice(s) that is being cancelled by this invoice, if applicable. May
   * appear on invoice PDF as *Replaced invoice numbers*. Note: There may be multiple replaced
   * invoices due to consolidation of multiple invoices into a single invoice.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getReplacedInvoiceIds() {
    return replacedInvoiceIds;
  }

  /**
   * The originally issued invoice(s) that is being cancelled by this invoice, if applicable. May
   * appear on invoice PDF as *Replaced invoice numbers*. Note: There may be multiple replaced
   * invoices due to consolidation of multiple invoices into a single invoice.
   * @param replacedInvoiceIds replacedInvoiceIds or {@code null} for none
   */
  public Invoice setReplacedInvoiceIds(java.util.List<java.lang.String> replacedInvoiceIds) {
    this.replacedInvoiceIds = replacedInvoiceIds;
    return this;
  }

  /**
   * The invoice service end date.
   * @return value or {@code null} for none
   */
  public java.lang.String getServiceEndDate() {
    return serviceEndDate;
  }

  /**
   * The invoice service end date.
   * @param serviceEndDate serviceEndDate or {@code null} for none
   */
  public Invoice setServiceEndDate(java.lang.String serviceEndDate) {
    this.serviceEndDate = serviceEndDate;
    return this;
  }

  /**
   * The invoice service start date.
   * @return value or {@code null} for none
   */
  public java.lang.String getServiceStartDate() {
    return serviceStartDate;
  }

  /**
   * The invoice service start date.
   * @param serviceStartDate serviceStartDate or {@code null} for none
   */
  public Invoice setServiceStartDate(java.lang.String serviceStartDate) {
    this.serviceStartDate = serviceStartDate;
    return this;
  }

  /**
   * The pre-tax subtotal amount, in micros of the invoice's currency.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSubtotalAmountMicros() {
    return subtotalAmountMicros;
  }

  /**
   * The pre-tax subtotal amount, in micros of the invoice's currency.
   * @param subtotalAmountMicros subtotalAmountMicros or {@code null} for none
   */
  public Invoice setSubtotalAmountMicros(java.lang.Long subtotalAmountMicros) {
    this.subtotalAmountMicros = subtotalAmountMicros;
    return this;
  }

  /**
   * The invoice total amount, in micros of the invoice's currency.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTotalAmountMicros() {
    return totalAmountMicros;
  }

  /**
   * The invoice total amount, in micros of the invoice's currency.
   * @param totalAmountMicros totalAmountMicros or {@code null} for none
   */
  public Invoice setTotalAmountMicros(java.lang.Long totalAmountMicros) {
    this.totalAmountMicros = totalAmountMicros;
    return this;
  }

  /**
   * The sum of all taxes in invoice, in micros of the invoice's currency.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTotalTaxAmountMicros() {
    return totalTaxAmountMicros;
  }

  /**
   * The sum of all taxes in invoice, in micros of the invoice's currency.
   * @param totalTaxAmountMicros totalTaxAmountMicros or {@code null} for none
   */
  public Invoice setTotalTaxAmountMicros(java.lang.Long totalTaxAmountMicros) {
    this.totalTaxAmountMicros = totalTaxAmountMicros;
    return this;
  }

  @Override
  public Invoice set(String fieldName, Object value) {
    return (Invoice) super.set(fieldName, value);
  }

  @Override
  public Invoice clone() {
    return (Invoice) super.clone();
  }

}
