/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains information about a particular version of an operating system that can be targeted by
 * ads.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OperatingSystemVersion extends com.google.api.client.json.GenericJson {

  /**
   * ID of this operating system version.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#operatingSystemVersion".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Major version (leftmost number) of this operating system version.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String majorVersion;

  /**
   * Minor version (number after the first dot) of this operating system version.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String minorVersion;

  /**
   * Name of this operating system version.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Operating system of this operating system version.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OperatingSystem operatingSystem;

  /**
   * ID of this operating system version.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this operating system version.
   * @param id id or {@code null} for none
   */
  public OperatingSystemVersion setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#operatingSystemVersion".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#operatingSystemVersion".
   * @param kind kind or {@code null} for none
   */
  public OperatingSystemVersion setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Major version (leftmost number) of this operating system version.
   * @return value or {@code null} for none
   */
  public java.lang.String getMajorVersion() {
    return majorVersion;
  }

  /**
   * Major version (leftmost number) of this operating system version.
   * @param majorVersion majorVersion or {@code null} for none
   */
  public OperatingSystemVersion setMajorVersion(java.lang.String majorVersion) {
    this.majorVersion = majorVersion;
    return this;
  }

  /**
   * Minor version (number after the first dot) of this operating system version.
   * @return value or {@code null} for none
   */
  public java.lang.String getMinorVersion() {
    return minorVersion;
  }

  /**
   * Minor version (number after the first dot) of this operating system version.
   * @param minorVersion minorVersion or {@code null} for none
   */
  public OperatingSystemVersion setMinorVersion(java.lang.String minorVersion) {
    this.minorVersion = minorVersion;
    return this;
  }

  /**
   * Name of this operating system version.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this operating system version.
   * @param name name or {@code null} for none
   */
  public OperatingSystemVersion setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Operating system of this operating system version.
   * @return value or {@code null} for none
   */
  public OperatingSystem getOperatingSystem() {
    return operatingSystem;
  }

  /**
   * Operating system of this operating system version.
   * @param operatingSystem operatingSystem or {@code null} for none
   */
  public OperatingSystemVersion setOperatingSystem(OperatingSystem operatingSystem) {
    this.operatingSystem = operatingSystem;
    return this;
  }

  @Override
  public OperatingSystemVersion set(String fieldName, Object value) {
    return (OperatingSystemVersion) super.set(fieldName, value);
  }

  @Override
  public OperatingSystemVersion clone() {
    return (OperatingSystemVersion) super.clone();
  }

}
