/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Pricing Schedule
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PricingSchedule extends com.google.api.client.json.GenericJson {

  /**
   * Placement cap cost option.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String capCostOption;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime endDate;

  /**
   * Whether this placement is flighted. If true, pricing periods will be computed automatically.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean flighted;

  /**
   * Floodlight activity ID associated with this placement. This field should be set when placement
   * pricing type is set to PRICING_TYPE_CPA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long floodlightActivityId;

  /**
   * Pricing periods for this placement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PricingSchedulePricingPeriod> pricingPeriods;

  /**
   * Placement pricing type. This field is required on insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pricingType;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime startDate;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime testingStartDate;

  /**
   * Placement cap cost option.
   * @return value or {@code null} for none
   */
  public java.lang.String getCapCostOption() {
    return capCostOption;
  }

  /**
   * Placement cap cost option.
   * @param capCostOption capCostOption or {@code null} for none
   */
  public PricingSchedule setCapCostOption(java.lang.String capCostOption) {
    this.capCostOption = capCostOption;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getEndDate() {
    return endDate;
  }

  /**
   * @param endDate endDate or {@code null} for none
   */
  public PricingSchedule setEndDate(com.google.api.client.util.DateTime endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * Whether this placement is flighted. If true, pricing periods will be computed automatically.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFlighted() {
    return flighted;
  }

  /**
   * Whether this placement is flighted. If true, pricing periods will be computed automatically.
   * @param flighted flighted or {@code null} for none
   */
  public PricingSchedule setFlighted(java.lang.Boolean flighted) {
    this.flighted = flighted;
    return this;
  }

  /**
   * Floodlight activity ID associated with this placement. This field should be set when placement
   * pricing type is set to PRICING_TYPE_CPA.
   * @return value or {@code null} for none
   */
  public java.lang.Long getFloodlightActivityId() {
    return floodlightActivityId;
  }

  /**
   * Floodlight activity ID associated with this placement. This field should be set when placement
   * pricing type is set to PRICING_TYPE_CPA.
   * @param floodlightActivityId floodlightActivityId or {@code null} for none
   */
  public PricingSchedule setFloodlightActivityId(java.lang.Long floodlightActivityId) {
    this.floodlightActivityId = floodlightActivityId;
    return this;
  }

  /**
   * Pricing periods for this placement.
   * @return value or {@code null} for none
   */
  public java.util.List<PricingSchedulePricingPeriod> getPricingPeriods() {
    return pricingPeriods;
  }

  /**
   * Pricing periods for this placement.
   * @param pricingPeriods pricingPeriods or {@code null} for none
   */
  public PricingSchedule setPricingPeriods(java.util.List<PricingSchedulePricingPeriod> pricingPeriods) {
    this.pricingPeriods = pricingPeriods;
    return this;
  }

  /**
   * Placement pricing type. This field is required on insertion.
   * @return value or {@code null} for none
   */
  public java.lang.String getPricingType() {
    return pricingType;
  }

  /**
   * Placement pricing type. This field is required on insertion.
   * @param pricingType pricingType or {@code null} for none
   */
  public PricingSchedule setPricingType(java.lang.String pricingType) {
    this.pricingType = pricingType;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getStartDate() {
    return startDate;
  }

  /**
   * @param startDate startDate or {@code null} for none
   */
  public PricingSchedule setStartDate(com.google.api.client.util.DateTime startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getTestingStartDate() {
    return testingStartDate;
  }

  /**
   * @param testingStartDate testingStartDate or {@code null} for none
   */
  public PricingSchedule setTestingStartDate(com.google.api.client.util.DateTime testingStartDate) {
    this.testingStartDate = testingStartDate;
    return this;
  }

  @Override
  public PricingSchedule set(String fieldName, Object value) {
    return (PricingSchedule) super.set(fieldName, value);
  }

  @Override
  public PricingSchedule clone() {
    return (PricingSchedule) super.clone();
  }

}
