/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Represents a Report resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Report extends com.google.api.client.json.GenericJson {

  /**
   * The account ID to which this report belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * The report criteria for a report of type "STANDARD".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Criteria criteria;

  /**
   * The report criteria for a report of type "CROSS_DIMENSION_REACH".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CrossDimensionReachCriteria crossDimensionReachCriteria;

  /**
   * The report's email delivery settings.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Delivery delivery;

  /**
   * The eTag of this response for caching purposes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The filename used when generating report files for this report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileName;

  /**
   * The report criteria for a report of type "FLOODLIGHT".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FloodlightCriteria floodlightCriteria;

  /**
   * The output format of the report. If not specified, default format is "CSV". Note that the
   * actual format in the completed report file might differ if for instance the report's size
   * exceeds the format's capabilities. "CSV" will then be the fallback format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String format;

  /**
   * The unique ID identifying this report resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * The kind of resource this is, in this case dfareporting#report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The timestamp (in milliseconds since epoch) of when this report was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger lastModifiedTime;

  /**
   * The name of the report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The user profile id of the owner of this report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long ownerProfileId;

  /**
   * The report criteria for a report of type "PATH_ATTRIBUTION".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PathAttributionCriteria pathAttributionCriteria;

  /**
   * The report criteria for a report of type "PATH".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PathCriteria pathCriteria;

  /**
   * The report criteria for a report of type "PATH_TO_CONVERSION".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PathToConversionCriteria pathToConversionCriteria;

  /**
   * The report criteria for a report of type "REACH".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReachCriteria reachCriteria;

  /**
   * The report's schedule. Can only be set if the report's 'dateRange' is a relative date range and
   * the relative date range is not "TODAY".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Schedule schedule;

  /**
   * The subaccount ID to which this report belongs if applicable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long subAccountId;

  /**
   * The type of the report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The account ID to which this report belongs.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * The account ID to which this report belongs.
   * @param accountId accountId or {@code null} for none
   */
  public Report setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * The report criteria for a report of type "STANDARD".
   * @return value or {@code null} for none
   */
  public Criteria getCriteria() {
    return criteria;
  }

  /**
   * The report criteria for a report of type "STANDARD".
   * @param criteria criteria or {@code null} for none
   */
  public Report setCriteria(Criteria criteria) {
    this.criteria = criteria;
    return this;
  }

  /**
   * The report criteria for a report of type "CROSS_DIMENSION_REACH".
   * @return value or {@code null} for none
   */
  public CrossDimensionReachCriteria getCrossDimensionReachCriteria() {
    return crossDimensionReachCriteria;
  }

  /**
   * The report criteria for a report of type "CROSS_DIMENSION_REACH".
   * @param crossDimensionReachCriteria crossDimensionReachCriteria or {@code null} for none
   */
  public Report setCrossDimensionReachCriteria(CrossDimensionReachCriteria crossDimensionReachCriteria) {
    this.crossDimensionReachCriteria = crossDimensionReachCriteria;
    return this;
  }

  /**
   * The report's email delivery settings.
   * @return value or {@code null} for none
   */
  public Delivery getDelivery() {
    return delivery;
  }

  /**
   * The report's email delivery settings.
   * @param delivery delivery or {@code null} for none
   */
  public Report setDelivery(Delivery delivery) {
    this.delivery = delivery;
    return this;
  }

  /**
   * The eTag of this response for caching purposes.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * The eTag of this response for caching purposes.
   * @param etag etag or {@code null} for none
   */
  public Report setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The filename used when generating report files for this report.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileName() {
    return fileName;
  }

  /**
   * The filename used when generating report files for this report.
   * @param fileName fileName or {@code null} for none
   */
  public Report setFileName(java.lang.String fileName) {
    this.fileName = fileName;
    return this;
  }

  /**
   * The report criteria for a report of type "FLOODLIGHT".
   * @return value or {@code null} for none
   */
  public FloodlightCriteria getFloodlightCriteria() {
    return floodlightCriteria;
  }

  /**
   * The report criteria for a report of type "FLOODLIGHT".
   * @param floodlightCriteria floodlightCriteria or {@code null} for none
   */
  public Report setFloodlightCriteria(FloodlightCriteria floodlightCriteria) {
    this.floodlightCriteria = floodlightCriteria;
    return this;
  }

  /**
   * The output format of the report. If not specified, default format is "CSV". Note that the
   * actual format in the completed report file might differ if for instance the report's size
   * exceeds the format's capabilities. "CSV" will then be the fallback format.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormat() {
    return format;
  }

  /**
   * The output format of the report. If not specified, default format is "CSV". Note that the
   * actual format in the completed report file might differ if for instance the report's size
   * exceeds the format's capabilities. "CSV" will then be the fallback format.
   * @param format format or {@code null} for none
   */
  public Report setFormat(java.lang.String format) {
    this.format = format;
    return this;
  }

  /**
   * The unique ID identifying this report resource.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * The unique ID identifying this report resource.
   * @param id id or {@code null} for none
   */
  public Report setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * The kind of resource this is, in this case dfareporting#report.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of resource this is, in this case dfareporting#report.
   * @param kind kind or {@code null} for none
   */
  public Report setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The timestamp (in milliseconds since epoch) of when this report was last modified.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getLastModifiedTime() {
    return lastModifiedTime;
  }

  /**
   * The timestamp (in milliseconds since epoch) of when this report was last modified.
   * @param lastModifiedTime lastModifiedTime or {@code null} for none
   */
  public Report setLastModifiedTime(java.math.BigInteger lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * The name of the report.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the report.
   * @param name name or {@code null} for none
   */
  public Report setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The user profile id of the owner of this report.
   * @return value or {@code null} for none
   */
  public java.lang.Long getOwnerProfileId() {
    return ownerProfileId;
  }

  /**
   * The user profile id of the owner of this report.
   * @param ownerProfileId ownerProfileId or {@code null} for none
   */
  public Report setOwnerProfileId(java.lang.Long ownerProfileId) {
    this.ownerProfileId = ownerProfileId;
    return this;
  }

  /**
   * The report criteria for a report of type "PATH_ATTRIBUTION".
   * @return value or {@code null} for none
   */
  public PathAttributionCriteria getPathAttributionCriteria() {
    return pathAttributionCriteria;
  }

  /**
   * The report criteria for a report of type "PATH_ATTRIBUTION".
   * @param pathAttributionCriteria pathAttributionCriteria or {@code null} for none
   */
  public Report setPathAttributionCriteria(PathAttributionCriteria pathAttributionCriteria) {
    this.pathAttributionCriteria = pathAttributionCriteria;
    return this;
  }

  /**
   * The report criteria for a report of type "PATH".
   * @return value or {@code null} for none
   */
  public PathCriteria getPathCriteria() {
    return pathCriteria;
  }

  /**
   * The report criteria for a report of type "PATH".
   * @param pathCriteria pathCriteria or {@code null} for none
   */
  public Report setPathCriteria(PathCriteria pathCriteria) {
    this.pathCriteria = pathCriteria;
    return this;
  }

  /**
   * The report criteria for a report of type "PATH_TO_CONVERSION".
   * @return value or {@code null} for none
   */
  public PathToConversionCriteria getPathToConversionCriteria() {
    return pathToConversionCriteria;
  }

  /**
   * The report criteria for a report of type "PATH_TO_CONVERSION".
   * @param pathToConversionCriteria pathToConversionCriteria or {@code null} for none
   */
  public Report setPathToConversionCriteria(PathToConversionCriteria pathToConversionCriteria) {
    this.pathToConversionCriteria = pathToConversionCriteria;
    return this;
  }

  /**
   * The report criteria for a report of type "REACH".
   * @return value or {@code null} for none
   */
  public ReachCriteria getReachCriteria() {
    return reachCriteria;
  }

  /**
   * The report criteria for a report of type "REACH".
   * @param reachCriteria reachCriteria or {@code null} for none
   */
  public Report setReachCriteria(ReachCriteria reachCriteria) {
    this.reachCriteria = reachCriteria;
    return this;
  }

  /**
   * The report's schedule. Can only be set if the report's 'dateRange' is a relative date range and
   * the relative date range is not "TODAY".
   * @return value or {@code null} for none
   */
  public Schedule getSchedule() {
    return schedule;
  }

  /**
   * The report's schedule. Can only be set if the report's 'dateRange' is a relative date range and
   * the relative date range is not "TODAY".
   * @param schedule schedule or {@code null} for none
   */
  public Report setSchedule(Schedule schedule) {
    this.schedule = schedule;
    return this;
  }

  /**
   * The subaccount ID to which this report belongs if applicable.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSubAccountId() {
    return subAccountId;
  }

  /**
   * The subaccount ID to which this report belongs if applicable.
   * @param subAccountId subAccountId or {@code null} for none
   */
  public Report setSubAccountId(java.lang.Long subAccountId) {
    this.subAccountId = subAccountId;
    return this;
  }

  /**
   * The type of the report.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the report.
   * @param type type or {@code null} for none
   */
  public Report setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Report set(String fieldName, Object value) {
    return (Report) super.set(fieldName, value);
  }

  @Override
  public Report clone() {
    return (Report) super.clone();
  }

  /**
   * The report criteria for a report of type "STANDARD".
   */
  public static final class Criteria extends com.google.api.client.json.GenericJson {

    /**
     * Activity group.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Activities activities;

    /**
     * Custom Rich Media Events group.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private CustomRichMediaEvents customRichMediaEvents;

    /**
     * The date range for which this report should be run.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private DateRange dateRange;

    /**
     * The list of filters on which dimensions are filtered. Filters for different dimensions are
     * ANDed, filters for the same dimension are grouped together and ORed.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<DimensionValue> dimensionFilters;

    static {
      // hack to force ProGuard to consider DimensionValue used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(DimensionValue.class);
    }

    /**
     * The list of standard dimensions the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<SortedDimension> dimensions;

    /**
     * The list of names of metrics the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> metricNames;

    /**
     * Activity group.
     * @return value or {@code null} for none
     */
    public Activities getActivities() {
      return activities;
    }

    /**
     * Activity group.
     * @param activities activities or {@code null} for none
     */
    public Criteria setActivities(Activities activities) {
      this.activities = activities;
      return this;
    }

    /**
     * Custom Rich Media Events group.
     * @return value or {@code null} for none
     */
    public CustomRichMediaEvents getCustomRichMediaEvents() {
      return customRichMediaEvents;
    }

    /**
     * Custom Rich Media Events group.
     * @param customRichMediaEvents customRichMediaEvents or {@code null} for none
     */
    public Criteria setCustomRichMediaEvents(CustomRichMediaEvents customRichMediaEvents) {
      this.customRichMediaEvents = customRichMediaEvents;
      return this;
    }

    /**
     * The date range for which this report should be run.
     * @return value or {@code null} for none
     */
    public DateRange getDateRange() {
      return dateRange;
    }

    /**
     * The date range for which this report should be run.
     * @param dateRange dateRange or {@code null} for none
     */
    public Criteria setDateRange(DateRange dateRange) {
      this.dateRange = dateRange;
      return this;
    }

    /**
     * The list of filters on which dimensions are filtered. Filters for different dimensions are
     * ANDed, filters for the same dimension are grouped together and ORed.
     * @return value or {@code null} for none
     */
    public java.util.List<DimensionValue> getDimensionFilters() {
      return dimensionFilters;
    }

    /**
     * The list of filters on which dimensions are filtered. Filters for different dimensions are
     * ANDed, filters for the same dimension are grouped together and ORed.
     * @param dimensionFilters dimensionFilters or {@code null} for none
     */
    public Criteria setDimensionFilters(java.util.List<DimensionValue> dimensionFilters) {
      this.dimensionFilters = dimensionFilters;
      return this;
    }

    /**
     * The list of standard dimensions the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<SortedDimension> getDimensions() {
      return dimensions;
    }

    /**
     * The list of standard dimensions the report should include.
     * @param dimensions dimensions or {@code null} for none
     */
    public Criteria setDimensions(java.util.List<SortedDimension> dimensions) {
      this.dimensions = dimensions;
      return this;
    }

    /**
     * The list of names of metrics the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getMetricNames() {
      return metricNames;
    }

    /**
     * The list of names of metrics the report should include.
     * @param metricNames metricNames or {@code null} for none
     */
    public Criteria setMetricNames(java.util.List<java.lang.String> metricNames) {
      this.metricNames = metricNames;
      return this;
    }

    @Override
    public Criteria set(String fieldName, Object value) {
      return (Criteria) super.set(fieldName, value);
    }

    @Override
    public Criteria clone() {
      return (Criteria) super.clone();
    }

  }

  /**
   * The report criteria for a report of type "CROSS_DIMENSION_REACH".
   */
  public static final class CrossDimensionReachCriteria extends com.google.api.client.json.GenericJson {

    /**
     * The list of dimensions the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<SortedDimension> breakdown;

    /**
     * The date range this report should be run for.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private DateRange dateRange;

    /**
     * The dimension option.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String dimension;

    /**
     * The list of filters on which dimensions are filtered.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<DimensionValue> dimensionFilters;

    static {
      // hack to force ProGuard to consider DimensionValue used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(DimensionValue.class);
    }

    /**
     * The list of names of metrics the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> metricNames;

    /**
     * The list of names of overlap metrics the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> overlapMetricNames;

    /**
     * Whether the report is pivoted or not. Defaults to true.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean pivoted;

    /**
     * The list of dimensions the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<SortedDimension> getBreakdown() {
      return breakdown;
    }

    /**
     * The list of dimensions the report should include.
     * @param breakdown breakdown or {@code null} for none
     */
    public CrossDimensionReachCriteria setBreakdown(java.util.List<SortedDimension> breakdown) {
      this.breakdown = breakdown;
      return this;
    }

    /**
     * The date range this report should be run for.
     * @return value or {@code null} for none
     */
    public DateRange getDateRange() {
      return dateRange;
    }

    /**
     * The date range this report should be run for.
     * @param dateRange dateRange or {@code null} for none
     */
    public CrossDimensionReachCriteria setDateRange(DateRange dateRange) {
      this.dateRange = dateRange;
      return this;
    }

    /**
     * The dimension option.
     * @return value or {@code null} for none
     */
    public java.lang.String getDimension() {
      return dimension;
    }

    /**
     * The dimension option.
     * @param dimension dimension or {@code null} for none
     */
    public CrossDimensionReachCriteria setDimension(java.lang.String dimension) {
      this.dimension = dimension;
      return this;
    }

    /**
     * The list of filters on which dimensions are filtered.
     * @return value or {@code null} for none
     */
    public java.util.List<DimensionValue> getDimensionFilters() {
      return dimensionFilters;
    }

    /**
     * The list of filters on which dimensions are filtered.
     * @param dimensionFilters dimensionFilters or {@code null} for none
     */
    public CrossDimensionReachCriteria setDimensionFilters(java.util.List<DimensionValue> dimensionFilters) {
      this.dimensionFilters = dimensionFilters;
      return this;
    }

    /**
     * The list of names of metrics the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getMetricNames() {
      return metricNames;
    }

    /**
     * The list of names of metrics the report should include.
     * @param metricNames metricNames or {@code null} for none
     */
    public CrossDimensionReachCriteria setMetricNames(java.util.List<java.lang.String> metricNames) {
      this.metricNames = metricNames;
      return this;
    }

    /**
     * The list of names of overlap metrics the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getOverlapMetricNames() {
      return overlapMetricNames;
    }

    /**
     * The list of names of overlap metrics the report should include.
     * @param overlapMetricNames overlapMetricNames or {@code null} for none
     */
    public CrossDimensionReachCriteria setOverlapMetricNames(java.util.List<java.lang.String> overlapMetricNames) {
      this.overlapMetricNames = overlapMetricNames;
      return this;
    }

    /**
     * Whether the report is pivoted or not. Defaults to true.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getPivoted() {
      return pivoted;
    }

    /**
     * Whether the report is pivoted or not. Defaults to true.
     * @param pivoted pivoted or {@code null} for none
     */
    public CrossDimensionReachCriteria setPivoted(java.lang.Boolean pivoted) {
      this.pivoted = pivoted;
      return this;
    }

    @Override
    public CrossDimensionReachCriteria set(String fieldName, Object value) {
      return (CrossDimensionReachCriteria) super.set(fieldName, value);
    }

    @Override
    public CrossDimensionReachCriteria clone() {
      return (CrossDimensionReachCriteria) super.clone();
    }

  }

  /**
   * The report's email delivery settings.
   */
  public static final class Delivery extends com.google.api.client.json.GenericJson {

    /**
     * Whether the report should be emailed to the report owner.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean emailOwner;

    /**
     * The type of delivery for the owner to receive, if enabled.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String emailOwnerDeliveryType;

    /**
     * The message to be sent with each email.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String message;

    /**
     * The list of recipients to which to email the report.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Recipient> recipients;

    static {
      // hack to force ProGuard to consider Recipient used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(Recipient.class);
    }

    /**
     * Whether the report should be emailed to the report owner.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getEmailOwner() {
      return emailOwner;
    }

    /**
     * Whether the report should be emailed to the report owner.
     * @param emailOwner emailOwner or {@code null} for none
     */
    public Delivery setEmailOwner(java.lang.Boolean emailOwner) {
      this.emailOwner = emailOwner;
      return this;
    }

    /**
     * The type of delivery for the owner to receive, if enabled.
     * @return value or {@code null} for none
     */
    public java.lang.String getEmailOwnerDeliveryType() {
      return emailOwnerDeliveryType;
    }

    /**
     * The type of delivery for the owner to receive, if enabled.
     * @param emailOwnerDeliveryType emailOwnerDeliveryType or {@code null} for none
     */
    public Delivery setEmailOwnerDeliveryType(java.lang.String emailOwnerDeliveryType) {
      this.emailOwnerDeliveryType = emailOwnerDeliveryType;
      return this;
    }

    /**
     * The message to be sent with each email.
     * @return value or {@code null} for none
     */
    public java.lang.String getMessage() {
      return message;
    }

    /**
     * The message to be sent with each email.
     * @param message message or {@code null} for none
     */
    public Delivery setMessage(java.lang.String message) {
      this.message = message;
      return this;
    }

    /**
     * The list of recipients to which to email the report.
     * @return value or {@code null} for none
     */
    public java.util.List<Recipient> getRecipients() {
      return recipients;
    }

    /**
     * The list of recipients to which to email the report.
     * @param recipients recipients or {@code null} for none
     */
    public Delivery setRecipients(java.util.List<Recipient> recipients) {
      this.recipients = recipients;
      return this;
    }

    @Override
    public Delivery set(String fieldName, Object value) {
      return (Delivery) super.set(fieldName, value);
    }

    @Override
    public Delivery clone() {
      return (Delivery) super.clone();
    }

  }

  /**
   * The report criteria for a report of type "FLOODLIGHT".
   */
  public static final class FloodlightCriteria extends com.google.api.client.json.GenericJson {

    /**
     * The list of custom rich media events to include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<DimensionValue> customRichMediaEvents;

    static {
      // hack to force ProGuard to consider DimensionValue used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(DimensionValue.class);
    }

    /**
     * The date range this report should be run for.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private DateRange dateRange;

    /**
     * The list of filters on which dimensions are filtered. Filters for different dimensions are
     * ANDed, filters for the same dimension are grouped together and ORed.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<DimensionValue> dimensionFilters;

    static {
      // hack to force ProGuard to consider DimensionValue used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(DimensionValue.class);
    }

    /**
     * The list of dimensions the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<SortedDimension> dimensions;

    /**
     * The floodlight ID for which to show data in this report. All advertisers associated with that
     * ID will automatically be added. The dimension of the value needs to be
     * 'dfa:floodlightConfigId'.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private DimensionValue floodlightConfigId;

    /**
     * The list of names of metrics the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> metricNames;

    /**
     * The properties of the report.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private ReportProperties reportProperties;

    /**
     * The list of custom rich media events to include.
     * @return value or {@code null} for none
     */
    public java.util.List<DimensionValue> getCustomRichMediaEvents() {
      return customRichMediaEvents;
    }

    /**
     * The list of custom rich media events to include.
     * @param customRichMediaEvents customRichMediaEvents or {@code null} for none
     */
    public FloodlightCriteria setCustomRichMediaEvents(java.util.List<DimensionValue> customRichMediaEvents) {
      this.customRichMediaEvents = customRichMediaEvents;
      return this;
    }

    /**
     * The date range this report should be run for.
     * @return value or {@code null} for none
     */
    public DateRange getDateRange() {
      return dateRange;
    }

    /**
     * The date range this report should be run for.
     * @param dateRange dateRange or {@code null} for none
     */
    public FloodlightCriteria setDateRange(DateRange dateRange) {
      this.dateRange = dateRange;
      return this;
    }

    /**
     * The list of filters on which dimensions are filtered. Filters for different dimensions are
     * ANDed, filters for the same dimension are grouped together and ORed.
     * @return value or {@code null} for none
     */
    public java.util.List<DimensionValue> getDimensionFilters() {
      return dimensionFilters;
    }

    /**
     * The list of filters on which dimensions are filtered. Filters for different dimensions are
     * ANDed, filters for the same dimension are grouped together and ORed.
     * @param dimensionFilters dimensionFilters or {@code null} for none
     */
    public FloodlightCriteria setDimensionFilters(java.util.List<DimensionValue> dimensionFilters) {
      this.dimensionFilters = dimensionFilters;
      return this;
    }

    /**
     * The list of dimensions the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<SortedDimension> getDimensions() {
      return dimensions;
    }

    /**
     * The list of dimensions the report should include.
     * @param dimensions dimensions or {@code null} for none
     */
    public FloodlightCriteria setDimensions(java.util.List<SortedDimension> dimensions) {
      this.dimensions = dimensions;
      return this;
    }

    /**
     * The floodlight ID for which to show data in this report. All advertisers associated with that
     * ID will automatically be added. The dimension of the value needs to be
     * 'dfa:floodlightConfigId'.
     * @return value or {@code null} for none
     */
    public DimensionValue getFloodlightConfigId() {
      return floodlightConfigId;
    }

    /**
     * The floodlight ID for which to show data in this report. All advertisers associated with that
     * ID will automatically be added. The dimension of the value needs to be
     * 'dfa:floodlightConfigId'.
     * @param floodlightConfigId floodlightConfigId or {@code null} for none
     */
    public FloodlightCriteria setFloodlightConfigId(DimensionValue floodlightConfigId) {
      this.floodlightConfigId = floodlightConfigId;
      return this;
    }

    /**
     * The list of names of metrics the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getMetricNames() {
      return metricNames;
    }

    /**
     * The list of names of metrics the report should include.
     * @param metricNames metricNames or {@code null} for none
     */
    public FloodlightCriteria setMetricNames(java.util.List<java.lang.String> metricNames) {
      this.metricNames = metricNames;
      return this;
    }

    /**
     * The properties of the report.
     * @return value or {@code null} for none
     */
    public ReportProperties getReportProperties() {
      return reportProperties;
    }

    /**
     * The properties of the report.
     * @param reportProperties reportProperties or {@code null} for none
     */
    public FloodlightCriteria setReportProperties(ReportProperties reportProperties) {
      this.reportProperties = reportProperties;
      return this;
    }

    @Override
    public FloodlightCriteria set(String fieldName, Object value) {
      return (FloodlightCriteria) super.set(fieldName, value);
    }

    @Override
    public FloodlightCriteria clone() {
      return (FloodlightCriteria) super.clone();
    }

    /**
     * The properties of the report.
     */
    public static final class ReportProperties extends com.google.api.client.json.GenericJson {

      /**
       * Include conversions that have no cookie, but do have an exposure path.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeAttributedIPConversions;

      /**
       * Include conversions of users with a DoubleClick cookie but without an exposure. That means the
       * user did not click or see an ad from the advertiser within the Floodlight group, or that the
       * interaction happened outside the lookback window.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeUnattributedCookieConversions;

      /**
       * Include conversions that have no associated cookies and no exposures. It’s therefore impossible
       * to know how the user was exposed to your ads during the lookback window prior to a conversion.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeUnattributedIPConversions;

      /**
       * Include conversions that have no cookie, but do have an exposure path.
       * @return value or {@code null} for none
       */
      public java.lang.Boolean getIncludeAttributedIPConversions() {
        return includeAttributedIPConversions;
      }

      /**
       * Include conversions that have no cookie, but do have an exposure path.
       * @param includeAttributedIPConversions includeAttributedIPConversions or {@code null} for none
       */
      public ReportProperties setIncludeAttributedIPConversions(java.lang.Boolean includeAttributedIPConversions) {
        this.includeAttributedIPConversions = includeAttributedIPConversions;
        return this;
      }

      /**
       * Include conversions of users with a DoubleClick cookie but without an exposure. That means the
       * user did not click or see an ad from the advertiser within the Floodlight group, or that the
       * interaction happened outside the lookback window.
       * @return value or {@code null} for none
       */
      public java.lang.Boolean getIncludeUnattributedCookieConversions() {
        return includeUnattributedCookieConversions;
      }

      /**
       * Include conversions of users with a DoubleClick cookie but without an exposure. That means the
       * user did not click or see an ad from the advertiser within the Floodlight group, or that the
       * interaction happened outside the lookback window.
       * @param includeUnattributedCookieConversions includeUnattributedCookieConversions or {@code null} for none
       */
      public ReportProperties setIncludeUnattributedCookieConversions(java.lang.Boolean includeUnattributedCookieConversions) {
        this.includeUnattributedCookieConversions = includeUnattributedCookieConversions;
        return this;
      }

      /**
       * Include conversions that have no associated cookies and no exposures. It’s therefore impossible
       * to know how the user was exposed to your ads during the lookback window prior to a conversion.
       * @return value or {@code null} for none
       */
      public java.lang.Boolean getIncludeUnattributedIPConversions() {
        return includeUnattributedIPConversions;
      }

      /**
       * Include conversions that have no associated cookies and no exposures. It’s therefore impossible
       * to know how the user was exposed to your ads during the lookback window prior to a conversion.
       * @param includeUnattributedIPConversions includeUnattributedIPConversions or {@code null} for none
       */
      public ReportProperties setIncludeUnattributedIPConversions(java.lang.Boolean includeUnattributedIPConversions) {
        this.includeUnattributedIPConversions = includeUnattributedIPConversions;
        return this;
      }

      @Override
      public ReportProperties set(String fieldName, Object value) {
        return (ReportProperties) super.set(fieldName, value);
      }

      @Override
      public ReportProperties clone() {
        return (ReportProperties) super.clone();
      }

    }
  }

  /**
   * The report criteria for a report of type "PATH_ATTRIBUTION".
   */
  public static final class PathAttributionCriteria extends com.google.api.client.json.GenericJson {

    /**
     * The list of 'dfa:activity' values to filter on.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<DimensionValue> activityFilters;

    static {
      // hack to force ProGuard to consider DimensionValue used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(DimensionValue.class);
    }

    /**
     * Channel Grouping.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private ChannelGrouping customChannelGrouping;

    /**
     * The date range this report should be run for.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private DateRange dateRange;

    /**
     * The list of dimensions the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<SortedDimension> dimensions;

    /**
     * The floodlight ID for which to show data in this report. All advertisers associated with that
     * ID will automatically be added. The dimension of the value needs to be
     * 'dfa:floodlightConfigId'.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private DimensionValue floodlightConfigId;

    /**
     * The list of names of metrics the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> metricNames;

    /**
     * Path Filters.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<PathFilter> pathFilters;

    static {
      // hack to force ProGuard to consider PathFilter used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(PathFilter.class);
    }

    /**
     * The list of 'dfa:activity' values to filter on.
     * @return value or {@code null} for none
     */
    public java.util.List<DimensionValue> getActivityFilters() {
      return activityFilters;
    }

    /**
     * The list of 'dfa:activity' values to filter on.
     * @param activityFilters activityFilters or {@code null} for none
     */
    public PathAttributionCriteria setActivityFilters(java.util.List<DimensionValue> activityFilters) {
      this.activityFilters = activityFilters;
      return this;
    }

    /**
     * Channel Grouping.
     * @return value or {@code null} for none
     */
    public ChannelGrouping getCustomChannelGrouping() {
      return customChannelGrouping;
    }

    /**
     * Channel Grouping.
     * @param customChannelGrouping customChannelGrouping or {@code null} for none
     */
    public PathAttributionCriteria setCustomChannelGrouping(ChannelGrouping customChannelGrouping) {
      this.customChannelGrouping = customChannelGrouping;
      return this;
    }

    /**
     * The date range this report should be run for.
     * @return value or {@code null} for none
     */
    public DateRange getDateRange() {
      return dateRange;
    }

    /**
     * The date range this report should be run for.
     * @param dateRange dateRange or {@code null} for none
     */
    public PathAttributionCriteria setDateRange(DateRange dateRange) {
      this.dateRange = dateRange;
      return this;
    }

    /**
     * The list of dimensions the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<SortedDimension> getDimensions() {
      return dimensions;
    }

    /**
     * The list of dimensions the report should include.
     * @param dimensions dimensions or {@code null} for none
     */
    public PathAttributionCriteria setDimensions(java.util.List<SortedDimension> dimensions) {
      this.dimensions = dimensions;
      return this;
    }

    /**
     * The floodlight ID for which to show data in this report. All advertisers associated with that
     * ID will automatically be added. The dimension of the value needs to be
     * 'dfa:floodlightConfigId'.
     * @return value or {@code null} for none
     */
    public DimensionValue getFloodlightConfigId() {
      return floodlightConfigId;
    }

    /**
     * The floodlight ID for which to show data in this report. All advertisers associated with that
     * ID will automatically be added. The dimension of the value needs to be
     * 'dfa:floodlightConfigId'.
     * @param floodlightConfigId floodlightConfigId or {@code null} for none
     */
    public PathAttributionCriteria setFloodlightConfigId(DimensionValue floodlightConfigId) {
      this.floodlightConfigId = floodlightConfigId;
      return this;
    }

    /**
     * The list of names of metrics the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getMetricNames() {
      return metricNames;
    }

    /**
     * The list of names of metrics the report should include.
     * @param metricNames metricNames or {@code null} for none
     */
    public PathAttributionCriteria setMetricNames(java.util.List<java.lang.String> metricNames) {
      this.metricNames = metricNames;
      return this;
    }

    /**
     * Path Filters.
     * @return value or {@code null} for none
     */
    public java.util.List<PathFilter> getPathFilters() {
      return pathFilters;
    }

    /**
     * Path Filters.
     * @param pathFilters pathFilters or {@code null} for none
     */
    public PathAttributionCriteria setPathFilters(java.util.List<PathFilter> pathFilters) {
      this.pathFilters = pathFilters;
      return this;
    }

    @Override
    public PathAttributionCriteria set(String fieldName, Object value) {
      return (PathAttributionCriteria) super.set(fieldName, value);
    }

    @Override
    public PathAttributionCriteria clone() {
      return (PathAttributionCriteria) super.clone();
    }

  }

  /**
   * The report criteria for a report of type "PATH".
   */
  public static final class PathCriteria extends com.google.api.client.json.GenericJson {

    /**
     * The list of 'dfa:activity' values to filter on.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<DimensionValue> activityFilters;

    static {
      // hack to force ProGuard to consider DimensionValue used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(DimensionValue.class);
    }

    /**
     * Channel Grouping.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private ChannelGrouping customChannelGrouping;

    /**
     * The date range this report should be run for.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private DateRange dateRange;

    /**
     * The list of dimensions the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<SortedDimension> dimensions;

    /**
     * The floodlight ID for which to show data in this report. All advertisers associated with that
     * ID will automatically be added. The dimension of the value needs to be
     * 'dfa:floodlightConfigId'.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private DimensionValue floodlightConfigId;

    /**
     * The list of names of metrics the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> metricNames;

    /**
     * Path Filters.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<PathFilter> pathFilters;

    static {
      // hack to force ProGuard to consider PathFilter used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(PathFilter.class);
    }

    /**
     * The list of 'dfa:activity' values to filter on.
     * @return value or {@code null} for none
     */
    public java.util.List<DimensionValue> getActivityFilters() {
      return activityFilters;
    }

    /**
     * The list of 'dfa:activity' values to filter on.
     * @param activityFilters activityFilters or {@code null} for none
     */
    public PathCriteria setActivityFilters(java.util.List<DimensionValue> activityFilters) {
      this.activityFilters = activityFilters;
      return this;
    }

    /**
     * Channel Grouping.
     * @return value or {@code null} for none
     */
    public ChannelGrouping getCustomChannelGrouping() {
      return customChannelGrouping;
    }

    /**
     * Channel Grouping.
     * @param customChannelGrouping customChannelGrouping or {@code null} for none
     */
    public PathCriteria setCustomChannelGrouping(ChannelGrouping customChannelGrouping) {
      this.customChannelGrouping = customChannelGrouping;
      return this;
    }

    /**
     * The date range this report should be run for.
     * @return value or {@code null} for none
     */
    public DateRange getDateRange() {
      return dateRange;
    }

    /**
     * The date range this report should be run for.
     * @param dateRange dateRange or {@code null} for none
     */
    public PathCriteria setDateRange(DateRange dateRange) {
      this.dateRange = dateRange;
      return this;
    }

    /**
     * The list of dimensions the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<SortedDimension> getDimensions() {
      return dimensions;
    }

    /**
     * The list of dimensions the report should include.
     * @param dimensions dimensions or {@code null} for none
     */
    public PathCriteria setDimensions(java.util.List<SortedDimension> dimensions) {
      this.dimensions = dimensions;
      return this;
    }

    /**
     * The floodlight ID for which to show data in this report. All advertisers associated with that
     * ID will automatically be added. The dimension of the value needs to be
     * 'dfa:floodlightConfigId'.
     * @return value or {@code null} for none
     */
    public DimensionValue getFloodlightConfigId() {
      return floodlightConfigId;
    }

    /**
     * The floodlight ID for which to show data in this report. All advertisers associated with that
     * ID will automatically be added. The dimension of the value needs to be
     * 'dfa:floodlightConfigId'.
     * @param floodlightConfigId floodlightConfigId or {@code null} for none
     */
    public PathCriteria setFloodlightConfigId(DimensionValue floodlightConfigId) {
      this.floodlightConfigId = floodlightConfigId;
      return this;
    }

    /**
     * The list of names of metrics the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getMetricNames() {
      return metricNames;
    }

    /**
     * The list of names of metrics the report should include.
     * @param metricNames metricNames or {@code null} for none
     */
    public PathCriteria setMetricNames(java.util.List<java.lang.String> metricNames) {
      this.metricNames = metricNames;
      return this;
    }

    /**
     * Path Filters.
     * @return value or {@code null} for none
     */
    public java.util.List<PathFilter> getPathFilters() {
      return pathFilters;
    }

    /**
     * Path Filters.
     * @param pathFilters pathFilters or {@code null} for none
     */
    public PathCriteria setPathFilters(java.util.List<PathFilter> pathFilters) {
      this.pathFilters = pathFilters;
      return this;
    }

    @Override
    public PathCriteria set(String fieldName, Object value) {
      return (PathCriteria) super.set(fieldName, value);
    }

    @Override
    public PathCriteria clone() {
      return (PathCriteria) super.clone();
    }

  }

  /**
   * The report criteria for a report of type "PATH_TO_CONVERSION".
   */
  public static final class PathToConversionCriteria extends com.google.api.client.json.GenericJson {

    /**
     * The list of 'dfa:activity' values to filter on.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<DimensionValue> activityFilters;

    static {
      // hack to force ProGuard to consider DimensionValue used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(DimensionValue.class);
    }

    /**
     * The list of conversion dimensions the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<SortedDimension> conversionDimensions;

    /**
     * The list of custom floodlight variables the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<SortedDimension> customFloodlightVariables;

    /**
     * The list of custom rich media events to include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<DimensionValue> customRichMediaEvents;

    static {
      // hack to force ProGuard to consider DimensionValue used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(DimensionValue.class);
    }

    /**
     * The date range this report should be run for.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private DateRange dateRange;

    /**
     * The floodlight ID for which to show data in this report. All advertisers associated with that
     * ID will automatically be added. The dimension of the value needs to be
     * 'dfa:floodlightConfigId'.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private DimensionValue floodlightConfigId;

    /**
     * The list of names of metrics the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> metricNames;

    /**
     * The list of per interaction dimensions the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<SortedDimension> perInteractionDimensions;

    /**
     * The properties of the report.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private ReportProperties reportProperties;

    /**
     * The list of 'dfa:activity' values to filter on.
     * @return value or {@code null} for none
     */
    public java.util.List<DimensionValue> getActivityFilters() {
      return activityFilters;
    }

    /**
     * The list of 'dfa:activity' values to filter on.
     * @param activityFilters activityFilters or {@code null} for none
     */
    public PathToConversionCriteria setActivityFilters(java.util.List<DimensionValue> activityFilters) {
      this.activityFilters = activityFilters;
      return this;
    }

    /**
     * The list of conversion dimensions the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<SortedDimension> getConversionDimensions() {
      return conversionDimensions;
    }

    /**
     * The list of conversion dimensions the report should include.
     * @param conversionDimensions conversionDimensions or {@code null} for none
     */
    public PathToConversionCriteria setConversionDimensions(java.util.List<SortedDimension> conversionDimensions) {
      this.conversionDimensions = conversionDimensions;
      return this;
    }

    /**
     * The list of custom floodlight variables the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<SortedDimension> getCustomFloodlightVariables() {
      return customFloodlightVariables;
    }

    /**
     * The list of custom floodlight variables the report should include.
     * @param customFloodlightVariables customFloodlightVariables or {@code null} for none
     */
    public PathToConversionCriteria setCustomFloodlightVariables(java.util.List<SortedDimension> customFloodlightVariables) {
      this.customFloodlightVariables = customFloodlightVariables;
      return this;
    }

    /**
     * The list of custom rich media events to include.
     * @return value or {@code null} for none
     */
    public java.util.List<DimensionValue> getCustomRichMediaEvents() {
      return customRichMediaEvents;
    }

    /**
     * The list of custom rich media events to include.
     * @param customRichMediaEvents customRichMediaEvents or {@code null} for none
     */
    public PathToConversionCriteria setCustomRichMediaEvents(java.util.List<DimensionValue> customRichMediaEvents) {
      this.customRichMediaEvents = customRichMediaEvents;
      return this;
    }

    /**
     * The date range this report should be run for.
     * @return value or {@code null} for none
     */
    public DateRange getDateRange() {
      return dateRange;
    }

    /**
     * The date range this report should be run for.
     * @param dateRange dateRange or {@code null} for none
     */
    public PathToConversionCriteria setDateRange(DateRange dateRange) {
      this.dateRange = dateRange;
      return this;
    }

    /**
     * The floodlight ID for which to show data in this report. All advertisers associated with that
     * ID will automatically be added. The dimension of the value needs to be
     * 'dfa:floodlightConfigId'.
     * @return value or {@code null} for none
     */
    public DimensionValue getFloodlightConfigId() {
      return floodlightConfigId;
    }

    /**
     * The floodlight ID for which to show data in this report. All advertisers associated with that
     * ID will automatically be added. The dimension of the value needs to be
     * 'dfa:floodlightConfigId'.
     * @param floodlightConfigId floodlightConfigId or {@code null} for none
     */
    public PathToConversionCriteria setFloodlightConfigId(DimensionValue floodlightConfigId) {
      this.floodlightConfigId = floodlightConfigId;
      return this;
    }

    /**
     * The list of names of metrics the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getMetricNames() {
      return metricNames;
    }

    /**
     * The list of names of metrics the report should include.
     * @param metricNames metricNames or {@code null} for none
     */
    public PathToConversionCriteria setMetricNames(java.util.List<java.lang.String> metricNames) {
      this.metricNames = metricNames;
      return this;
    }

    /**
     * The list of per interaction dimensions the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<SortedDimension> getPerInteractionDimensions() {
      return perInteractionDimensions;
    }

    /**
     * The list of per interaction dimensions the report should include.
     * @param perInteractionDimensions perInteractionDimensions or {@code null} for none
     */
    public PathToConversionCriteria setPerInteractionDimensions(java.util.List<SortedDimension> perInteractionDimensions) {
      this.perInteractionDimensions = perInteractionDimensions;
      return this;
    }

    /**
     * The properties of the report.
     * @return value or {@code null} for none
     */
    public ReportProperties getReportProperties() {
      return reportProperties;
    }

    /**
     * The properties of the report.
     * @param reportProperties reportProperties or {@code null} for none
     */
    public PathToConversionCriteria setReportProperties(ReportProperties reportProperties) {
      this.reportProperties = reportProperties;
      return this;
    }

    @Override
    public PathToConversionCriteria set(String fieldName, Object value) {
      return (PathToConversionCriteria) super.set(fieldName, value);
    }

    @Override
    public PathToConversionCriteria clone() {
      return (PathToConversionCriteria) super.clone();
    }

    /**
     * The properties of the report.
     */
    public static final class ReportProperties extends com.google.api.client.json.GenericJson {

      /**
       * CM360 checks to see if a click interaction occurred within the specified period of time before
       * a conversion. By default the value is pulled from Floodlight or you can manually enter a custom
       * value. Valid values: 1-90.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer clicksLookbackWindow;

      /**
       * CM360 checks to see if an impression interaction occurred within the specified period of time
       * before a conversion. By default the value is pulled from Floodlight or you can manually enter a
       * custom value. Valid values: 1-90.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer impressionsLookbackWindow;

      /**
       * Deprecated: has no effect.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeAttributedIPConversions;

      /**
       * Include conversions of users with a DoubleClick cookie but without an exposure. That means the
       * user did not click or see an ad from the advertiser within the Floodlight group, or that the
       * interaction happened outside the lookback window.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeUnattributedCookieConversions;

      /**
       * Include conversions that have no associated cookies and no exposures. It’s therefore impossible
       * to know how the user was exposed to your ads during the lookback window prior to a conversion.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeUnattributedIPConversions;

      /**
       * The maximum number of click interactions to include in the report. Advertisers currently paying
       * for E2C reports get up to 200 (100 clicks, 100 impressions). If another advertiser in your
       * network is paying for E2C, you can have up to 5 total exposures per report.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maximumClickInteractions;

      /**
       * The maximum number of click interactions to include in the report. Advertisers currently paying
       * for E2C reports get up to 200 (100 clicks, 100 impressions). If another advertiser in your
       * network is paying for E2C, you can have up to 5 total exposures per report.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maximumImpressionInteractions;

      /**
       * The maximum amount of time that can take place between interactions (clicks or impressions) by
       * the same user. Valid values: 1-90.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maximumInteractionGap;

      /**
       * Enable pivoting on interaction path.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean pivotOnInteractionPath;

      /**
       * CM360 checks to see if a click interaction occurred within the specified period of time before
       * a conversion. By default the value is pulled from Floodlight or you can manually enter a custom
       * value. Valid values: 1-90.
       * @return value or {@code null} for none
       */
      public java.lang.Integer getClicksLookbackWindow() {
        return clicksLookbackWindow;
      }

      /**
       * CM360 checks to see if a click interaction occurred within the specified period of time before
       * a conversion. By default the value is pulled from Floodlight or you can manually enter a custom
       * value. Valid values: 1-90.
       * @param clicksLookbackWindow clicksLookbackWindow or {@code null} for none
       */
      public ReportProperties setClicksLookbackWindow(java.lang.Integer clicksLookbackWindow) {
        this.clicksLookbackWindow = clicksLookbackWindow;
        return this;
      }

      /**
       * CM360 checks to see if an impression interaction occurred within the specified period of time
       * before a conversion. By default the value is pulled from Floodlight or you can manually enter a
       * custom value. Valid values: 1-90.
       * @return value or {@code null} for none
       */
      public java.lang.Integer getImpressionsLookbackWindow() {
        return impressionsLookbackWindow;
      }

      /**
       * CM360 checks to see if an impression interaction occurred within the specified period of time
       * before a conversion. By default the value is pulled from Floodlight or you can manually enter a
       * custom value. Valid values: 1-90.
       * @param impressionsLookbackWindow impressionsLookbackWindow or {@code null} for none
       */
      public ReportProperties setImpressionsLookbackWindow(java.lang.Integer impressionsLookbackWindow) {
        this.impressionsLookbackWindow = impressionsLookbackWindow;
        return this;
      }

      /**
       * Deprecated: has no effect.
       * @return value or {@code null} for none
       */
      public java.lang.Boolean getIncludeAttributedIPConversions() {
        return includeAttributedIPConversions;
      }

      /**
       * Deprecated: has no effect.
       * @param includeAttributedIPConversions includeAttributedIPConversions or {@code null} for none
       */
      public ReportProperties setIncludeAttributedIPConversions(java.lang.Boolean includeAttributedIPConversions) {
        this.includeAttributedIPConversions = includeAttributedIPConversions;
        return this;
      }

      /**
       * Include conversions of users with a DoubleClick cookie but without an exposure. That means the
       * user did not click or see an ad from the advertiser within the Floodlight group, or that the
       * interaction happened outside the lookback window.
       * @return value or {@code null} for none
       */
      public java.lang.Boolean getIncludeUnattributedCookieConversions() {
        return includeUnattributedCookieConversions;
      }

      /**
       * Include conversions of users with a DoubleClick cookie but without an exposure. That means the
       * user did not click or see an ad from the advertiser within the Floodlight group, or that the
       * interaction happened outside the lookback window.
       * @param includeUnattributedCookieConversions includeUnattributedCookieConversions or {@code null} for none
       */
      public ReportProperties setIncludeUnattributedCookieConversions(java.lang.Boolean includeUnattributedCookieConversions) {
        this.includeUnattributedCookieConversions = includeUnattributedCookieConversions;
        return this;
      }

      /**
       * Include conversions that have no associated cookies and no exposures. It’s therefore impossible
       * to know how the user was exposed to your ads during the lookback window prior to a conversion.
       * @return value or {@code null} for none
       */
      public java.lang.Boolean getIncludeUnattributedIPConversions() {
        return includeUnattributedIPConversions;
      }

      /**
       * Include conversions that have no associated cookies and no exposures. It’s therefore impossible
       * to know how the user was exposed to your ads during the lookback window prior to a conversion.
       * @param includeUnattributedIPConversions includeUnattributedIPConversions or {@code null} for none
       */
      public ReportProperties setIncludeUnattributedIPConversions(java.lang.Boolean includeUnattributedIPConversions) {
        this.includeUnattributedIPConversions = includeUnattributedIPConversions;
        return this;
      }

      /**
       * The maximum number of click interactions to include in the report. Advertisers currently paying
       * for E2C reports get up to 200 (100 clicks, 100 impressions). If another advertiser in your
       * network is paying for E2C, you can have up to 5 total exposures per report.
       * @return value or {@code null} for none
       */
      public java.lang.Integer getMaximumClickInteractions() {
        return maximumClickInteractions;
      }

      /**
       * The maximum number of click interactions to include in the report. Advertisers currently paying
       * for E2C reports get up to 200 (100 clicks, 100 impressions). If another advertiser in your
       * network is paying for E2C, you can have up to 5 total exposures per report.
       * @param maximumClickInteractions maximumClickInteractions or {@code null} for none
       */
      public ReportProperties setMaximumClickInteractions(java.lang.Integer maximumClickInteractions) {
        this.maximumClickInteractions = maximumClickInteractions;
        return this;
      }

      /**
       * The maximum number of click interactions to include in the report. Advertisers currently paying
       * for E2C reports get up to 200 (100 clicks, 100 impressions). If another advertiser in your
       * network is paying for E2C, you can have up to 5 total exposures per report.
       * @return value or {@code null} for none
       */
      public java.lang.Integer getMaximumImpressionInteractions() {
        return maximumImpressionInteractions;
      }

      /**
       * The maximum number of click interactions to include in the report. Advertisers currently paying
       * for E2C reports get up to 200 (100 clicks, 100 impressions). If another advertiser in your
       * network is paying for E2C, you can have up to 5 total exposures per report.
       * @param maximumImpressionInteractions maximumImpressionInteractions or {@code null} for none
       */
      public ReportProperties setMaximumImpressionInteractions(java.lang.Integer maximumImpressionInteractions) {
        this.maximumImpressionInteractions = maximumImpressionInteractions;
        return this;
      }

      /**
       * The maximum amount of time that can take place between interactions (clicks or impressions) by
       * the same user. Valid values: 1-90.
       * @return value or {@code null} for none
       */
      public java.lang.Integer getMaximumInteractionGap() {
        return maximumInteractionGap;
      }

      /**
       * The maximum amount of time that can take place between interactions (clicks or impressions) by
       * the same user. Valid values: 1-90.
       * @param maximumInteractionGap maximumInteractionGap or {@code null} for none
       */
      public ReportProperties setMaximumInteractionGap(java.lang.Integer maximumInteractionGap) {
        this.maximumInteractionGap = maximumInteractionGap;
        return this;
      }

      /**
       * Enable pivoting on interaction path.
       * @return value or {@code null} for none
       */
      public java.lang.Boolean getPivotOnInteractionPath() {
        return pivotOnInteractionPath;
      }

      /**
       * Enable pivoting on interaction path.
       * @param pivotOnInteractionPath pivotOnInteractionPath or {@code null} for none
       */
      public ReportProperties setPivotOnInteractionPath(java.lang.Boolean pivotOnInteractionPath) {
        this.pivotOnInteractionPath = pivotOnInteractionPath;
        return this;
      }

      @Override
      public ReportProperties set(String fieldName, Object value) {
        return (ReportProperties) super.set(fieldName, value);
      }

      @Override
      public ReportProperties clone() {
        return (ReportProperties) super.clone();
      }

    }
  }

  /**
   * The report criteria for a report of type "REACH".
   */
  public static final class ReachCriteria extends com.google.api.client.json.GenericJson {

    /**
     * Activity group.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Activities activities;

    /**
     * Custom Rich Media Events group.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private CustomRichMediaEvents customRichMediaEvents;

    /**
     * The date range this report should be run for.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private DateRange dateRange;

    /**
     * The list of filters on which dimensions are filtered. Filters for different dimensions are
     * ANDed, filters for the same dimension are grouped together and ORed.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<DimensionValue> dimensionFilters;

    static {
      // hack to force ProGuard to consider DimensionValue used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(DimensionValue.class);
    }

    /**
     * The list of dimensions the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<SortedDimension> dimensions;

    /**
     * Whether to enable all reach dimension combinations in the report. Defaults to false. If
     * enabled, the date range of the report should be within the last 42 days.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean enableAllDimensionCombinations;

    /**
     * The list of names of metrics the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> metricNames;

    /**
     * The list of names of Reach By Frequency metrics the report should include.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> reachByFrequencyMetricNames;

    /**
     * Activity group.
     * @return value or {@code null} for none
     */
    public Activities getActivities() {
      return activities;
    }

    /**
     * Activity group.
     * @param activities activities or {@code null} for none
     */
    public ReachCriteria setActivities(Activities activities) {
      this.activities = activities;
      return this;
    }

    /**
     * Custom Rich Media Events group.
     * @return value or {@code null} for none
     */
    public CustomRichMediaEvents getCustomRichMediaEvents() {
      return customRichMediaEvents;
    }

    /**
     * Custom Rich Media Events group.
     * @param customRichMediaEvents customRichMediaEvents or {@code null} for none
     */
    public ReachCriteria setCustomRichMediaEvents(CustomRichMediaEvents customRichMediaEvents) {
      this.customRichMediaEvents = customRichMediaEvents;
      return this;
    }

    /**
     * The date range this report should be run for.
     * @return value or {@code null} for none
     */
    public DateRange getDateRange() {
      return dateRange;
    }

    /**
     * The date range this report should be run for.
     * @param dateRange dateRange or {@code null} for none
     */
    public ReachCriteria setDateRange(DateRange dateRange) {
      this.dateRange = dateRange;
      return this;
    }

    /**
     * The list of filters on which dimensions are filtered. Filters for different dimensions are
     * ANDed, filters for the same dimension are grouped together and ORed.
     * @return value or {@code null} for none
     */
    public java.util.List<DimensionValue> getDimensionFilters() {
      return dimensionFilters;
    }

    /**
     * The list of filters on which dimensions are filtered. Filters for different dimensions are
     * ANDed, filters for the same dimension are grouped together and ORed.
     * @param dimensionFilters dimensionFilters or {@code null} for none
     */
    public ReachCriteria setDimensionFilters(java.util.List<DimensionValue> dimensionFilters) {
      this.dimensionFilters = dimensionFilters;
      return this;
    }

    /**
     * The list of dimensions the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<SortedDimension> getDimensions() {
      return dimensions;
    }

    /**
     * The list of dimensions the report should include.
     * @param dimensions dimensions or {@code null} for none
     */
    public ReachCriteria setDimensions(java.util.List<SortedDimension> dimensions) {
      this.dimensions = dimensions;
      return this;
    }

    /**
     * Whether to enable all reach dimension combinations in the report. Defaults to false. If
     * enabled, the date range of the report should be within the last 42 days.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getEnableAllDimensionCombinations() {
      return enableAllDimensionCombinations;
    }

    /**
     * Whether to enable all reach dimension combinations in the report. Defaults to false. If
     * enabled, the date range of the report should be within the last 42 days.
     * @param enableAllDimensionCombinations enableAllDimensionCombinations or {@code null} for none
     */
    public ReachCriteria setEnableAllDimensionCombinations(java.lang.Boolean enableAllDimensionCombinations) {
      this.enableAllDimensionCombinations = enableAllDimensionCombinations;
      return this;
    }

    /**
     * The list of names of metrics the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getMetricNames() {
      return metricNames;
    }

    /**
     * The list of names of metrics the report should include.
     * @param metricNames metricNames or {@code null} for none
     */
    public ReachCriteria setMetricNames(java.util.List<java.lang.String> metricNames) {
      this.metricNames = metricNames;
      return this;
    }

    /**
     * The list of names of Reach By Frequency metrics the report should include.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getReachByFrequencyMetricNames() {
      return reachByFrequencyMetricNames;
    }

    /**
     * The list of names of Reach By Frequency metrics the report should include.
     * @param reachByFrequencyMetricNames reachByFrequencyMetricNames or {@code null} for none
     */
    public ReachCriteria setReachByFrequencyMetricNames(java.util.List<java.lang.String> reachByFrequencyMetricNames) {
      this.reachByFrequencyMetricNames = reachByFrequencyMetricNames;
      return this;
    }

    @Override
    public ReachCriteria set(String fieldName, Object value) {
      return (ReachCriteria) super.set(fieldName, value);
    }

    @Override
    public ReachCriteria clone() {
      return (ReachCriteria) super.clone();
    }

  }

  /**
   * The report's schedule. Can only be set if the report's 'dateRange' is a relative date range and
   * the relative date range is not "TODAY".
   */
  public static final class Schedule extends com.google.api.client.json.GenericJson {

    /**
     * Whether the schedule is active or not. Must be set to either true or false.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean active;

    /**
     * Defines every how many days, weeks or months the report should be run. Needs to be set when
     * "repeats" is either "DAILY", "WEEKLY" or "MONTHLY".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer every;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private com.google.api.client.util.DateTime expirationDate;

    /**
     * The interval for which the report is repeated. Note: - "DAILY" also requires field "every" to
     * be set. - "WEEKLY" also requires fields "every" and "repeatsOnWeekDays" to be set. - "MONTHLY"
     * also requires fields "every" and "runsOnDayOfMonth" to be set.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String repeats;

    /**
     * List of week days "WEEKLY" on which scheduled reports should run.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> repeatsOnWeekDays;

    /**
     * Enum to define for "MONTHLY" scheduled reports whether reports should be repeated on the same
     * day of the month as "startDate" or the same day of the week of the month. Example: If
     * 'startDate' is Monday, April 2nd 2012 (2012-04-02), "DAY_OF_MONTH" would run subsequent reports
     * on the 2nd of every Month, and "WEEK_OF_MONTH" would run subsequent reports on the first Monday
     * of the month.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String runsOnDayOfMonth;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private com.google.api.client.util.DateTime startDate;

    /**
     * Whether the schedule is active or not. Must be set to either true or false.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getActive() {
      return active;
    }

    /**
     * Whether the schedule is active or not. Must be set to either true or false.
     * @param active active or {@code null} for none
     */
    public Schedule setActive(java.lang.Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Defines every how many days, weeks or months the report should be run. Needs to be set when
     * "repeats" is either "DAILY", "WEEKLY" or "MONTHLY".
     * @return value or {@code null} for none
     */
    public java.lang.Integer getEvery() {
      return every;
    }

    /**
     * Defines every how many days, weeks or months the report should be run. Needs to be set when
     * "repeats" is either "DAILY", "WEEKLY" or "MONTHLY".
     * @param every every or {@code null} for none
     */
    public Schedule setEvery(java.lang.Integer every) {
      this.every = every;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public com.google.api.client.util.DateTime getExpirationDate() {
      return expirationDate;
    }

    /**
     * @param expirationDate expirationDate or {@code null} for none
     */
    public Schedule setExpirationDate(com.google.api.client.util.DateTime expirationDate) {
      this.expirationDate = expirationDate;
      return this;
    }

    /**
     * The interval for which the report is repeated. Note: - "DAILY" also requires field "every" to
     * be set. - "WEEKLY" also requires fields "every" and "repeatsOnWeekDays" to be set. - "MONTHLY"
     * also requires fields "every" and "runsOnDayOfMonth" to be set.
     * @return value or {@code null} for none
     */
    public java.lang.String getRepeats() {
      return repeats;
    }

    /**
     * The interval for which the report is repeated. Note: - "DAILY" also requires field "every" to
     * be set. - "WEEKLY" also requires fields "every" and "repeatsOnWeekDays" to be set. - "MONTHLY"
     * also requires fields "every" and "runsOnDayOfMonth" to be set.
     * @param repeats repeats or {@code null} for none
     */
    public Schedule setRepeats(java.lang.String repeats) {
      this.repeats = repeats;
      return this;
    }

    /**
     * List of week days "WEEKLY" on which scheduled reports should run.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getRepeatsOnWeekDays() {
      return repeatsOnWeekDays;
    }

    /**
     * List of week days "WEEKLY" on which scheduled reports should run.
     * @param repeatsOnWeekDays repeatsOnWeekDays or {@code null} for none
     */
    public Schedule setRepeatsOnWeekDays(java.util.List<java.lang.String> repeatsOnWeekDays) {
      this.repeatsOnWeekDays = repeatsOnWeekDays;
      return this;
    }

    /**
     * Enum to define for "MONTHLY" scheduled reports whether reports should be repeated on the same
     * day of the month as "startDate" or the same day of the week of the month. Example: If
     * 'startDate' is Monday, April 2nd 2012 (2012-04-02), "DAY_OF_MONTH" would run subsequent reports
     * on the 2nd of every Month, and "WEEK_OF_MONTH" would run subsequent reports on the first Monday
     * of the month.
     * @return value or {@code null} for none
     */
    public java.lang.String getRunsOnDayOfMonth() {
      return runsOnDayOfMonth;
    }

    /**
     * Enum to define for "MONTHLY" scheduled reports whether reports should be repeated on the same
     * day of the month as "startDate" or the same day of the week of the month. Example: If
     * 'startDate' is Monday, April 2nd 2012 (2012-04-02), "DAY_OF_MONTH" would run subsequent reports
     * on the 2nd of every Month, and "WEEK_OF_MONTH" would run subsequent reports on the first Monday
     * of the month.
     * @param runsOnDayOfMonth runsOnDayOfMonth or {@code null} for none
     */
    public Schedule setRunsOnDayOfMonth(java.lang.String runsOnDayOfMonth) {
      this.runsOnDayOfMonth = runsOnDayOfMonth;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public com.google.api.client.util.DateTime getStartDate() {
      return startDate;
    }

    /**
     * @param startDate startDate or {@code null} for none
     */
    public Schedule setStartDate(com.google.api.client.util.DateTime startDate) {
      this.startDate = startDate;
      return this;
    }

    @Override
    public Schedule set(String fieldName, Object value) {
      return (Schedule) super.set(fieldName, value);
    }

    @Override
    public Schedule clone() {
      return (Schedule) super.clone();
    }

  }

}
