/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * A UserProfile resource lets you list all DFA user profiles that are associated with a Google user
 * account. The profile_id needs to be specified in other API requests.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UserProfile extends com.google.api.client.json.GenericJson {

  /**
   * The account ID to which this profile belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * The account name this profile belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountName;

  /**
   * Etag of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#userProfile".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The unique ID of the user profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long profileId;

  /**
   * The sub account ID this profile belongs to if applicable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long subAccountId;

  /**
   * The sub account name this profile belongs to if applicable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subAccountName;

  /**
   * The user name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userName;

  /**
   * The account ID to which this profile belongs.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * The account ID to which this profile belongs.
   * @param accountId accountId or {@code null} for none
   */
  public UserProfile setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * The account name this profile belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountName() {
    return accountName;
  }

  /**
   * The account name this profile belongs to.
   * @param accountName accountName or {@code null} for none
   */
  public UserProfile setAccountName(java.lang.String accountName) {
    this.accountName = accountName;
    return this;
  }

  /**
   * Etag of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Etag of this resource.
   * @param etag etag or {@code null} for none
   */
  public UserProfile setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#userProfile".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#userProfile".
   * @param kind kind or {@code null} for none
   */
  public UserProfile setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The unique ID of the user profile.
   * @return value or {@code null} for none
   */
  public java.lang.Long getProfileId() {
    return profileId;
  }

  /**
   * The unique ID of the user profile.
   * @param profileId profileId or {@code null} for none
   */
  public UserProfile setProfileId(java.lang.Long profileId) {
    this.profileId = profileId;
    return this;
  }

  /**
   * The sub account ID this profile belongs to if applicable.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSubAccountId() {
    return subAccountId;
  }

  /**
   * The sub account ID this profile belongs to if applicable.
   * @param subAccountId subAccountId or {@code null} for none
   */
  public UserProfile setSubAccountId(java.lang.Long subAccountId) {
    this.subAccountId = subAccountId;
    return this;
  }

  /**
   * The sub account name this profile belongs to if applicable.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubAccountName() {
    return subAccountName;
  }

  /**
   * The sub account name this profile belongs to if applicable.
   * @param subAccountName subAccountName or {@code null} for none
   */
  public UserProfile setSubAccountName(java.lang.String subAccountName) {
    this.subAccountName = subAccountName;
    return this;
  }

  /**
   * The user name.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserName() {
    return userName;
  }

  /**
   * The user name.
   * @param userName userName or {@code null} for none
   */
  public UserProfile setUserName(java.lang.String userName) {
    this.userName = userName;
    return this;
  }

  @Override
  public UserProfile set(String fieldName, Object value) {
    return (UserProfile) super.set(fieldName, value);
  }

  @Override
  public UserProfile clone() {
    return (UserProfile) super.clone();
  }

}
