/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * AccountUserProfiles contains properties of a Campaign Manager user profile. This resource is
 * specifically for managing user profiles, whereas UserProfiles is for accessing the API.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountUserProfile extends com.google.api.client.json.GenericJson {

  /**
   * Account ID of the user profile. This is a read-only field that can be left blank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * Whether this user profile is active. This defaults to false, and must be set true on insert for
   * the user profile to be usable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean active;

  /**
   * Filter that describes which advertisers are visible to the user profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ObjectFilter advertiserFilter;

  /**
   * Filter that describes which campaigns are visible to the user profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ObjectFilter campaignFilter;

  /**
   * Comments for this user profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String comments;

  /**
   * Email of the user profile. The email addresss must be linked to a Google Account. This field is
   * required on insertion and is read-only after insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * ID of the user profile. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#accountUserProfile".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Locale of the user profile. This is a required field. Acceptable values are: - "cs" (Czech) -
   * "de" (German) - "en" (English) - "en-GB" (English United Kingdom) - "es" (Spanish) - "fr"
   * (French) - "it" (Italian) - "ja" (Japanese) - "ko" (Korean) - "pl" (Polish) - "pt-BR"
   * (Portuguese Brazil) - "ru" (Russian) - "sv" (Swedish) - "tr" (Turkish) - "zh-CN" (Chinese
   * Simplified) - "zh-TW" (Chinese Traditional)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locale;

  /**
   * Name of the user profile. This is a required field. Must be less than 64 characters long, must
   * be globally unique, and cannot contain whitespace or any of the following characters:
   * "&;<>"#%,".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Filter that describes which sites are visible to the user profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ObjectFilter siteFilter;

  /**
   * Subaccount ID of the user profile. This is a read-only field that can be left blank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long subaccountId;

  /**
   * Trafficker type of this user profile. This is a read-only field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String traffickerType;

  /**
   * User type of the user profile. This is a read-only field that can be left blank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userAccessType;

  /**
   * Filter that describes which user roles are visible to the user profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ObjectFilter userRoleFilter;

  /**
   * User role ID of the user profile. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long userRoleId;

  /**
   * Account ID of the user profile. This is a read-only field that can be left blank.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * Account ID of the user profile. This is a read-only field that can be left blank.
   * @param accountId accountId or {@code null} for none
   */
  public AccountUserProfile setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Whether this user profile is active. This defaults to false, and must be set true on insert for
   * the user profile to be usable.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getActive() {
    return active;
  }

  /**
   * Whether this user profile is active. This defaults to false, and must be set true on insert for
   * the user profile to be usable.
   * @param active active or {@code null} for none
   */
  public AccountUserProfile setActive(java.lang.Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * Filter that describes which advertisers are visible to the user profile.
   * @return value or {@code null} for none
   */
  public ObjectFilter getAdvertiserFilter() {
    return advertiserFilter;
  }

  /**
   * Filter that describes which advertisers are visible to the user profile.
   * @param advertiserFilter advertiserFilter or {@code null} for none
   */
  public AccountUserProfile setAdvertiserFilter(ObjectFilter advertiserFilter) {
    this.advertiserFilter = advertiserFilter;
    return this;
  }

  /**
   * Filter that describes which campaigns are visible to the user profile.
   * @return value or {@code null} for none
   */
  public ObjectFilter getCampaignFilter() {
    return campaignFilter;
  }

  /**
   * Filter that describes which campaigns are visible to the user profile.
   * @param campaignFilter campaignFilter or {@code null} for none
   */
  public AccountUserProfile setCampaignFilter(ObjectFilter campaignFilter) {
    this.campaignFilter = campaignFilter;
    return this;
  }

  /**
   * Comments for this user profile.
   * @return value or {@code null} for none
   */
  public java.lang.String getComments() {
    return comments;
  }

  /**
   * Comments for this user profile.
   * @param comments comments or {@code null} for none
   */
  public AccountUserProfile setComments(java.lang.String comments) {
    this.comments = comments;
    return this;
  }

  /**
   * Email of the user profile. The email addresss must be linked to a Google Account. This field is
   * required on insertion and is read-only after insertion.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * Email of the user profile. The email addresss must be linked to a Google Account. This field is
   * required on insertion and is read-only after insertion.
   * @param email email or {@code null} for none
   */
  public AccountUserProfile setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * ID of the user profile. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of the user profile. This is a read-only, auto-generated field.
   * @param id id or {@code null} for none
   */
  public AccountUserProfile setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#accountUserProfile".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#accountUserProfile".
   * @param kind kind or {@code null} for none
   */
  public AccountUserProfile setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Locale of the user profile. This is a required field. Acceptable values are: - "cs" (Czech) -
   * "de" (German) - "en" (English) - "en-GB" (English United Kingdom) - "es" (Spanish) - "fr"
   * (French) - "it" (Italian) - "ja" (Japanese) - "ko" (Korean) - "pl" (Polish) - "pt-BR"
   * (Portuguese Brazil) - "ru" (Russian) - "sv" (Swedish) - "tr" (Turkish) - "zh-CN" (Chinese
   * Simplified) - "zh-TW" (Chinese Traditional)
   * @return value or {@code null} for none
   */
  public java.lang.String getLocale() {
    return locale;
  }

  /**
   * Locale of the user profile. This is a required field. Acceptable values are: - "cs" (Czech) -
   * "de" (German) - "en" (English) - "en-GB" (English United Kingdom) - "es" (Spanish) - "fr"
   * (French) - "it" (Italian) - "ja" (Japanese) - "ko" (Korean) - "pl" (Polish) - "pt-BR"
   * (Portuguese Brazil) - "ru" (Russian) - "sv" (Swedish) - "tr" (Turkish) - "zh-CN" (Chinese
   * Simplified) - "zh-TW" (Chinese Traditional)
   * @param locale locale or {@code null} for none
   */
  public AccountUserProfile setLocale(java.lang.String locale) {
    this.locale = locale;
    return this;
  }

  /**
   * Name of the user profile. This is a required field. Must be less than 64 characters long, must
   * be globally unique, and cannot contain whitespace or any of the following characters:
   * "&;<>"#%,".
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the user profile. This is a required field. Must be less than 64 characters long, must
   * be globally unique, and cannot contain whitespace or any of the following characters:
   * "&;<>"#%,".
   * @param name name or {@code null} for none
   */
  public AccountUserProfile setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Filter that describes which sites are visible to the user profile.
   * @return value or {@code null} for none
   */
  public ObjectFilter getSiteFilter() {
    return siteFilter;
  }

  /**
   * Filter that describes which sites are visible to the user profile.
   * @param siteFilter siteFilter or {@code null} for none
   */
  public AccountUserProfile setSiteFilter(ObjectFilter siteFilter) {
    this.siteFilter = siteFilter;
    return this;
  }

  /**
   * Subaccount ID of the user profile. This is a read-only field that can be left blank.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSubaccountId() {
    return subaccountId;
  }

  /**
   * Subaccount ID of the user profile. This is a read-only field that can be left blank.
   * @param subaccountId subaccountId or {@code null} for none
   */
  public AccountUserProfile setSubaccountId(java.lang.Long subaccountId) {
    this.subaccountId = subaccountId;
    return this;
  }

  /**
   * Trafficker type of this user profile. This is a read-only field.
   * @return value or {@code null} for none
   */
  public java.lang.String getTraffickerType() {
    return traffickerType;
  }

  /**
   * Trafficker type of this user profile. This is a read-only field.
   * @param traffickerType traffickerType or {@code null} for none
   */
  public AccountUserProfile setTraffickerType(java.lang.String traffickerType) {
    this.traffickerType = traffickerType;
    return this;
  }

  /**
   * User type of the user profile. This is a read-only field that can be left blank.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserAccessType() {
    return userAccessType;
  }

  /**
   * User type of the user profile. This is a read-only field that can be left blank.
   * @param userAccessType userAccessType or {@code null} for none
   */
  public AccountUserProfile setUserAccessType(java.lang.String userAccessType) {
    this.userAccessType = userAccessType;
    return this;
  }

  /**
   * Filter that describes which user roles are visible to the user profile.
   * @return value or {@code null} for none
   */
  public ObjectFilter getUserRoleFilter() {
    return userRoleFilter;
  }

  /**
   * Filter that describes which user roles are visible to the user profile.
   * @param userRoleFilter userRoleFilter or {@code null} for none
   */
  public AccountUserProfile setUserRoleFilter(ObjectFilter userRoleFilter) {
    this.userRoleFilter = userRoleFilter;
    return this;
  }

  /**
   * User role ID of the user profile. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getUserRoleId() {
    return userRoleId;
  }

  /**
   * User role ID of the user profile. This is a required field.
   * @param userRoleId userRoleId or {@code null} for none
   */
  public AccountUserProfile setUserRoleId(java.lang.Long userRoleId) {
    this.userRoleId = userRoleId;
    return this;
  }

  @Override
  public AccountUserProfile set(String fieldName, Object value) {
    return (AccountUserProfile) super.set(fieldName, value);
  }

  @Override
  public AccountUserProfile clone() {
    return (AccountUserProfile) super.clone();
  }

}
