/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Click Through URL Suffix settings.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ClickThroughUrlSuffixProperties extends com.google.api.client.json.GenericJson {

  /**
   * Click-through URL suffix to apply to all ads in this entity's scope. Must be less than 128
   * characters long.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clickThroughUrlSuffix;

  /**
   * Whether this entity should override the inherited click-through URL suffix with its own defined
   * value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean overrideInheritedSuffix;

  /**
   * Click-through URL suffix to apply to all ads in this entity's scope. Must be less than 128
   * characters long.
   * @return value or {@code null} for none
   */
  public java.lang.String getClickThroughUrlSuffix() {
    return clickThroughUrlSuffix;
  }

  /**
   * Click-through URL suffix to apply to all ads in this entity's scope. Must be less than 128
   * characters long.
   * @param clickThroughUrlSuffix clickThroughUrlSuffix or {@code null} for none
   */
  public ClickThroughUrlSuffixProperties setClickThroughUrlSuffix(java.lang.String clickThroughUrlSuffix) {
    this.clickThroughUrlSuffix = clickThroughUrlSuffix;
    return this;
  }

  /**
   * Whether this entity should override the inherited click-through URL suffix with its own defined
   * value.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getOverrideInheritedSuffix() {
    return overrideInheritedSuffix;
  }

  /**
   * Whether this entity should override the inherited click-through URL suffix with its own defined
   * value.
   * @param overrideInheritedSuffix overrideInheritedSuffix or {@code null} for none
   */
  public ClickThroughUrlSuffixProperties setOverrideInheritedSuffix(java.lang.Boolean overrideInheritedSuffix) {
    this.overrideInheritedSuffix = overrideInheritedSuffix;
    return this;
  }

  @Override
  public ClickThroughUrlSuffixProperties set(String fieldName, Object value) {
    return (ClickThroughUrlSuffixProperties) super.set(fieldName, value);
  }

  @Override
  public ClickThroughUrlSuffixProperties clone() {
    return (ClickThroughUrlSuffixProperties) super.clone();
  }

}
