/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Encapsulates the list of rules for asset selection and a default asset in case none of the rules
 * match. Applicable to INSTREAM_VIDEO creatives.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreativeAssetSelection extends com.google.api.client.json.GenericJson {

  /**
   * A creativeAssets[].id. This should refer to one of the parent assets in this creative, and will
   * be served if none of the rules match. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long defaultAssetId;

  /**
   * Rules determine which asset will be served to a viewer. Rules will be evaluated in the order in
   * which they are stored in this list. This list must contain at least one rule. Applicable to
   * INSTREAM_VIDEO creatives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Rule> rules;

  /**
   * A creativeAssets[].id. This should refer to one of the parent assets in this creative, and will
   * be served if none of the rules match. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDefaultAssetId() {
    return defaultAssetId;
  }

  /**
   * A creativeAssets[].id. This should refer to one of the parent assets in this creative, and will
   * be served if none of the rules match. This is a required field.
   * @param defaultAssetId defaultAssetId or {@code null} for none
   */
  public CreativeAssetSelection setDefaultAssetId(java.lang.Long defaultAssetId) {
    this.defaultAssetId = defaultAssetId;
    return this;
  }

  /**
   * Rules determine which asset will be served to a viewer. Rules will be evaluated in the order in
   * which they are stored in this list. This list must contain at least one rule. Applicable to
   * INSTREAM_VIDEO creatives.
   * @return value or {@code null} for none
   */
  public java.util.List<Rule> getRules() {
    return rules;
  }

  /**
   * Rules determine which asset will be served to a viewer. Rules will be evaluated in the order in
   * which they are stored in this list. This list must contain at least one rule. Applicable to
   * INSTREAM_VIDEO creatives.
   * @param rules rules or {@code null} for none
   */
  public CreativeAssetSelection setRules(java.util.List<Rule> rules) {
    this.rules = rules;
    return this;
  }

  @Override
  public CreativeAssetSelection set(String fieldName, Object value) {
    return (CreativeAssetSelection) super.set(fieldName, value);
  }

  @Override
  public CreativeAssetSelection clone() {
    return (CreativeAssetSelection) super.clone();
  }

}
