/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Represents a DfaReporting event filter.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventFilter extends com.google.api.client.json.GenericJson {

  /**
   * The dimension filter contained within this EventFilter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PathReportDimensionValue dimensionFilter;

  /**
   * The kind of resource this is, in this case dfareporting#eventFilter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Filter on a custom variable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UvarFilter uvarFilter;

  /**
   * The dimension filter contained within this EventFilter.
   * @return value or {@code null} for none
   */
  public PathReportDimensionValue getDimensionFilter() {
    return dimensionFilter;
  }

  /**
   * The dimension filter contained within this EventFilter.
   * @param dimensionFilter dimensionFilter or {@code null} for none
   */
  public EventFilter setDimensionFilter(PathReportDimensionValue dimensionFilter) {
    this.dimensionFilter = dimensionFilter;
    return this;
  }

  /**
   * The kind of resource this is, in this case dfareporting#eventFilter.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of resource this is, in this case dfareporting#eventFilter.
   * @param kind kind or {@code null} for none
   */
  public EventFilter setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Filter on a custom variable.
   * @return value or {@code null} for none
   */
  public UvarFilter getUvarFilter() {
    return uvarFilter;
  }

  /**
   * Filter on a custom variable.
   * @param uvarFilter uvarFilter or {@code null} for none
   */
  public EventFilter setUvarFilter(UvarFilter uvarFilter) {
    this.uvarFilter = uvarFilter;
    return this;
  }

  @Override
  public EventFilter set(String fieldName, Object value) {
    return (EventFilter) super.set(fieldName, value);
  }

  @Override
  public EventFilter clone() {
    return (EventFilter) super.clone();
  }

}
