/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Online Behavioral Advertiser icon.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ObaIcon extends com.google.api.client.json.GenericJson {

  /**
   * URL to redirect to when an OBA icon is clicked.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iconClickThroughUrl;

  /**
   * URL to track click when an OBA icon is clicked.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iconClickTrackingUrl;

  /**
   * URL to track view when an OBA icon is clicked.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iconViewTrackingUrl;

  /**
   * Identifies the industry initiative that the icon supports. For example, AdChoices.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String program;

  /**
   * OBA icon resource URL. Campaign Manager only supports image and JavaScript icons. Learn more
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resourceUrl;

  /**
   * OBA icon size.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Size size;

  /**
   * OBA icon x coordinate position. Accepted values are left or right.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String xPosition;

  /**
   * OBA icon y coordinate position. Accepted values are top or bottom.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String yPosition;

  /**
   * URL to redirect to when an OBA icon is clicked.
   * @return value or {@code null} for none
   */
  public java.lang.String getIconClickThroughUrl() {
    return iconClickThroughUrl;
  }

  /**
   * URL to redirect to when an OBA icon is clicked.
   * @param iconClickThroughUrl iconClickThroughUrl or {@code null} for none
   */
  public ObaIcon setIconClickThroughUrl(java.lang.String iconClickThroughUrl) {
    this.iconClickThroughUrl = iconClickThroughUrl;
    return this;
  }

  /**
   * URL to track click when an OBA icon is clicked.
   * @return value or {@code null} for none
   */
  public java.lang.String getIconClickTrackingUrl() {
    return iconClickTrackingUrl;
  }

  /**
   * URL to track click when an OBA icon is clicked.
   * @param iconClickTrackingUrl iconClickTrackingUrl or {@code null} for none
   */
  public ObaIcon setIconClickTrackingUrl(java.lang.String iconClickTrackingUrl) {
    this.iconClickTrackingUrl = iconClickTrackingUrl;
    return this;
  }

  /**
   * URL to track view when an OBA icon is clicked.
   * @return value or {@code null} for none
   */
  public java.lang.String getIconViewTrackingUrl() {
    return iconViewTrackingUrl;
  }

  /**
   * URL to track view when an OBA icon is clicked.
   * @param iconViewTrackingUrl iconViewTrackingUrl or {@code null} for none
   */
  public ObaIcon setIconViewTrackingUrl(java.lang.String iconViewTrackingUrl) {
    this.iconViewTrackingUrl = iconViewTrackingUrl;
    return this;
  }

  /**
   * Identifies the industry initiative that the icon supports. For example, AdChoices.
   * @return value or {@code null} for none
   */
  public java.lang.String getProgram() {
    return program;
  }

  /**
   * Identifies the industry initiative that the icon supports. For example, AdChoices.
   * @param program program or {@code null} for none
   */
  public ObaIcon setProgram(java.lang.String program) {
    this.program = program;
    return this;
  }

  /**
   * OBA icon resource URL. Campaign Manager only supports image and JavaScript icons. Learn more
   * @return value or {@code null} for none
   */
  public java.lang.String getResourceUrl() {
    return resourceUrl;
  }

  /**
   * OBA icon resource URL. Campaign Manager only supports image and JavaScript icons. Learn more
   * @param resourceUrl resourceUrl or {@code null} for none
   */
  public ObaIcon setResourceUrl(java.lang.String resourceUrl) {
    this.resourceUrl = resourceUrl;
    return this;
  }

  /**
   * OBA icon size.
   * @return value or {@code null} for none
   */
  public Size getSize() {
    return size;
  }

  /**
   * OBA icon size.
   * @param size size or {@code null} for none
   */
  public ObaIcon setSize(Size size) {
    this.size = size;
    return this;
  }

  /**
   * OBA icon x coordinate position. Accepted values are left or right.
   * @return value or {@code null} for none
   */
  public java.lang.String getXPosition() {
    return xPosition;
  }

  /**
   * OBA icon x coordinate position. Accepted values are left or right.
   * @param xPosition xPosition or {@code null} for none
   */
  public ObaIcon setXPosition(java.lang.String xPosition) {
    this.xPosition = xPosition;
    return this;
  }

  /**
   * OBA icon y coordinate position. Accepted values are top or bottom.
   * @return value or {@code null} for none
   */
  public java.lang.String getYPosition() {
    return yPosition;
  }

  /**
   * OBA icon y coordinate position. Accepted values are top or bottom.
   * @param yPosition yPosition or {@code null} for none
   */
  public ObaIcon setYPosition(java.lang.String yPosition) {
    this.yPosition = yPosition;
    return this;
  }

  @Override
  public ObaIcon set(String fieldName, Object value) {
    return (ObaIcon) super.set(fieldName, value);
  }

  @Override
  public ObaIcon clone() {
    return (ObaIcon) super.clone();
  }

}
