/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains properties of a Planning project.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Project extends com.google.api.client.json.GenericJson {

  /**
   * Account ID of this project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * Advertiser ID of this project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long advertiserId;

  /**
   * Audience age group of this project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String audienceAgeGroup;

  /**
   * Audience gender of this project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String audienceGender;

  /**
   * Budget of this project in the currency specified by the current account. The value stored in
   * this field represents only the non-fractional amount. For example, for USD, the smallest value
   * that can be represented by this field is 1 US dollar.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long budget;

  /**
   * Client billing code of this project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clientBillingCode;

  /**
   * Name of the project client.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clientName;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime endDate;

  /**
   * ID of this project. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#project".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Information about the most recent modification of this project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LastModifiedInfo lastModifiedInfo;

  /**
   * Name of this project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Overview of this project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String overview;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime startDate;

  /**
   * Subaccount ID of this project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long subaccountId;

  /**
   * Number of clicks that the advertiser is targeting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long targetClicks;

  /**
   * Number of conversions that the advertiser is targeting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long targetConversions;

  /**
   * CPA that the advertiser is targeting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long targetCpaNanos;

  /**
   * CPC that the advertiser is targeting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long targetCpcNanos;

  /**
   * vCPM from Active View that the advertiser is targeting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long targetCpmActiveViewNanos;

  /**
   * CPM that the advertiser is targeting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long targetCpmNanos;

  /**
   * Number of impressions that the advertiser is targeting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long targetImpressions;

  /**
   * Account ID of this project.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * Account ID of this project.
   * @param accountId accountId or {@code null} for none
   */
  public Project setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Advertiser ID of this project.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAdvertiserId() {
    return advertiserId;
  }

  /**
   * Advertiser ID of this project.
   * @param advertiserId advertiserId or {@code null} for none
   */
  public Project setAdvertiserId(java.lang.Long advertiserId) {
    this.advertiserId = advertiserId;
    return this;
  }

  /**
   * Audience age group of this project.
   * @return value or {@code null} for none
   */
  public java.lang.String getAudienceAgeGroup() {
    return audienceAgeGroup;
  }

  /**
   * Audience age group of this project.
   * @param audienceAgeGroup audienceAgeGroup or {@code null} for none
   */
  public Project setAudienceAgeGroup(java.lang.String audienceAgeGroup) {
    this.audienceAgeGroup = audienceAgeGroup;
    return this;
  }

  /**
   * Audience gender of this project.
   * @return value or {@code null} for none
   */
  public java.lang.String getAudienceGender() {
    return audienceGender;
  }

  /**
   * Audience gender of this project.
   * @param audienceGender audienceGender or {@code null} for none
   */
  public Project setAudienceGender(java.lang.String audienceGender) {
    this.audienceGender = audienceGender;
    return this;
  }

  /**
   * Budget of this project in the currency specified by the current account. The value stored in
   * this field represents only the non-fractional amount. For example, for USD, the smallest value
   * that can be represented by this field is 1 US dollar.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBudget() {
    return budget;
  }

  /**
   * Budget of this project in the currency specified by the current account. The value stored in
   * this field represents only the non-fractional amount. For example, for USD, the smallest value
   * that can be represented by this field is 1 US dollar.
   * @param budget budget or {@code null} for none
   */
  public Project setBudget(java.lang.Long budget) {
    this.budget = budget;
    return this;
  }

  /**
   * Client billing code of this project.
   * @return value or {@code null} for none
   */
  public java.lang.String getClientBillingCode() {
    return clientBillingCode;
  }

  /**
   * Client billing code of this project.
   * @param clientBillingCode clientBillingCode or {@code null} for none
   */
  public Project setClientBillingCode(java.lang.String clientBillingCode) {
    this.clientBillingCode = clientBillingCode;
    return this;
  }

  /**
   * Name of the project client.
   * @return value or {@code null} for none
   */
  public java.lang.String getClientName() {
    return clientName;
  }

  /**
   * Name of the project client.
   * @param clientName clientName or {@code null} for none
   */
  public Project setClientName(java.lang.String clientName) {
    this.clientName = clientName;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getEndDate() {
    return endDate;
  }

  /**
   * @param endDate endDate or {@code null} for none
   */
  public Project setEndDate(com.google.api.client.util.DateTime endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * ID of this project. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this project. This is a read-only, auto-generated field.
   * @param id id or {@code null} for none
   */
  public Project setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#project".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#project".
   * @param kind kind or {@code null} for none
   */
  public Project setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Information about the most recent modification of this project.
   * @return value or {@code null} for none
   */
  public LastModifiedInfo getLastModifiedInfo() {
    return lastModifiedInfo;
  }

  /**
   * Information about the most recent modification of this project.
   * @param lastModifiedInfo lastModifiedInfo or {@code null} for none
   */
  public Project setLastModifiedInfo(LastModifiedInfo lastModifiedInfo) {
    this.lastModifiedInfo = lastModifiedInfo;
    return this;
  }

  /**
   * Name of this project.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this project.
   * @param name name or {@code null} for none
   */
  public Project setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Overview of this project.
   * @return value or {@code null} for none
   */
  public java.lang.String getOverview() {
    return overview;
  }

  /**
   * Overview of this project.
   * @param overview overview or {@code null} for none
   */
  public Project setOverview(java.lang.String overview) {
    this.overview = overview;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getStartDate() {
    return startDate;
  }

  /**
   * @param startDate startDate or {@code null} for none
   */
  public Project setStartDate(com.google.api.client.util.DateTime startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * Subaccount ID of this project.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSubaccountId() {
    return subaccountId;
  }

  /**
   * Subaccount ID of this project.
   * @param subaccountId subaccountId or {@code null} for none
   */
  public Project setSubaccountId(java.lang.Long subaccountId) {
    this.subaccountId = subaccountId;
    return this;
  }

  /**
   * Number of clicks that the advertiser is targeting.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTargetClicks() {
    return targetClicks;
  }

  /**
   * Number of clicks that the advertiser is targeting.
   * @param targetClicks targetClicks or {@code null} for none
   */
  public Project setTargetClicks(java.lang.Long targetClicks) {
    this.targetClicks = targetClicks;
    return this;
  }

  /**
   * Number of conversions that the advertiser is targeting.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTargetConversions() {
    return targetConversions;
  }

  /**
   * Number of conversions that the advertiser is targeting.
   * @param targetConversions targetConversions or {@code null} for none
   */
  public Project setTargetConversions(java.lang.Long targetConversions) {
    this.targetConversions = targetConversions;
    return this;
  }

  /**
   * CPA that the advertiser is targeting.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTargetCpaNanos() {
    return targetCpaNanos;
  }

  /**
   * CPA that the advertiser is targeting.
   * @param targetCpaNanos targetCpaNanos or {@code null} for none
   */
  public Project setTargetCpaNanos(java.lang.Long targetCpaNanos) {
    this.targetCpaNanos = targetCpaNanos;
    return this;
  }

  /**
   * CPC that the advertiser is targeting.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTargetCpcNanos() {
    return targetCpcNanos;
  }

  /**
   * CPC that the advertiser is targeting.
   * @param targetCpcNanos targetCpcNanos or {@code null} for none
   */
  public Project setTargetCpcNanos(java.lang.Long targetCpcNanos) {
    this.targetCpcNanos = targetCpcNanos;
    return this;
  }

  /**
   * vCPM from Active View that the advertiser is targeting.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTargetCpmActiveViewNanos() {
    return targetCpmActiveViewNanos;
  }

  /**
   * vCPM from Active View that the advertiser is targeting.
   * @param targetCpmActiveViewNanos targetCpmActiveViewNanos or {@code null} for none
   */
  public Project setTargetCpmActiveViewNanos(java.lang.Long targetCpmActiveViewNanos) {
    this.targetCpmActiveViewNanos = targetCpmActiveViewNanos;
    return this;
  }

  /**
   * CPM that the advertiser is targeting.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTargetCpmNanos() {
    return targetCpmNanos;
  }

  /**
   * CPM that the advertiser is targeting.
   * @param targetCpmNanos targetCpmNanos or {@code null} for none
   */
  public Project setTargetCpmNanos(java.lang.Long targetCpmNanos) {
    this.targetCpmNanos = targetCpmNanos;
    return this;
  }

  /**
   * Number of impressions that the advertiser is targeting.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTargetImpressions() {
    return targetImpressions;
  }

  /**
   * Number of impressions that the advertiser is targeting.
   * @param targetImpressions targetImpressions or {@code null} for none
   */
  public Project setTargetImpressions(java.lang.Long targetImpressions) {
    this.targetImpressions = targetImpressions;
    return this;
  }

  @Override
  public Project set(String fieldName, Object value) {
    return (Project) super.set(fieldName, value);
  }

  @Override
  public Project clone() {
    return (Project) super.clone();
  }

}
