/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains properties of a remarketing list's sharing information. Sharing allows other accounts or
 * advertisers to target to your remarketing lists. This resource can be used to manage remarketing
 * list sharing to other accounts and advertisers.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RemarketingListShare extends com.google.api.client.json.GenericJson {

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#remarketingListShare".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Remarketing list ID. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long remarketingListId;

  /**
   * Accounts that the remarketing list is shared with.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> sharedAccountIds;

  /**
   * Advertisers that the remarketing list is shared with.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> sharedAdvertiserIds;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#remarketingListShare".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#remarketingListShare".
   * @param kind kind or {@code null} for none
   */
  public RemarketingListShare setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Remarketing list ID. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getRemarketingListId() {
    return remarketingListId;
  }

  /**
   * Remarketing list ID. This is a read-only, auto-generated field.
   * @param remarketingListId remarketingListId or {@code null} for none
   */
  public RemarketingListShare setRemarketingListId(java.lang.Long remarketingListId) {
    this.remarketingListId = remarketingListId;
    return this;
  }

  /**
   * Accounts that the remarketing list is shared with.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getSharedAccountIds() {
    return sharedAccountIds;
  }

  /**
   * Accounts that the remarketing list is shared with.
   * @param sharedAccountIds sharedAccountIds or {@code null} for none
   */
  public RemarketingListShare setSharedAccountIds(java.util.List<java.lang.Long> sharedAccountIds) {
    this.sharedAccountIds = sharedAccountIds;
    return this;
  }

  /**
   * Advertisers that the remarketing list is shared with.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getSharedAdvertiserIds() {
    return sharedAdvertiserIds;
  }

  /**
   * Advertisers that the remarketing list is shared with.
   * @param sharedAdvertiserIds sharedAdvertiserIds or {@code null} for none
   */
  public RemarketingListShare setSharedAdvertiserIds(java.util.List<java.lang.Long> sharedAdvertiserIds) {
    this.sharedAdvertiserIds = sharedAdvertiserIds;
    return this;
  }

  @Override
  public RemarketingListShare set(String fieldName, Object value) {
    return (RemarketingListShare) super.set(fieldName, value);
  }

  @Override
  public RemarketingListShare clone() {
    return (RemarketingListShare) super.clone();
  }

}
