/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Video Settings
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SiteVideoSettings extends com.google.api.client.json.GenericJson {

  /**
   * Settings for the companion creatives of video creatives served to this site.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SiteCompanionSetting companionSettings;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#siteVideoSettings".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Whether OBA icons are enabled for this placement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean obaEnabled;

  /**
   * Settings for the OBA icon of video creatives served to this site. This will act as default for
   * new placements created under this site.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ObaIcon obaSettings;

  /**
   * Orientation of a site template used for video. This will act as default for new placements
   * created under this site.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String orientation;

  /**
   * Publisher specification ID used to identify site-associated publisher requirements and
   * automatically populate transcode settings. If publisher specification ID is specified, it will
   * take precedence over transcode settings.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long publisherSpecificationId;

  /**
   * Settings for the skippability of video creatives served to this site. This will act as default
   * for new placements created under this site.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SiteSkippableSetting skippableSettings;

  /**
   * Settings for the transcodes of video creatives served to this site. This will act as default
   * for new placements created under this site.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SiteTranscodeSetting transcodeSettings;

  /**
   * Settings for the companion creatives of video creatives served to this site.
   * @return value or {@code null} for none
   */
  public SiteCompanionSetting getCompanionSettings() {
    return companionSettings;
  }

  /**
   * Settings for the companion creatives of video creatives served to this site.
   * @param companionSettings companionSettings or {@code null} for none
   */
  public SiteVideoSettings setCompanionSettings(SiteCompanionSetting companionSettings) {
    this.companionSettings = companionSettings;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#siteVideoSettings".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#siteVideoSettings".
   * @param kind kind or {@code null} for none
   */
  public SiteVideoSettings setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Whether OBA icons are enabled for this placement.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getObaEnabled() {
    return obaEnabled;
  }

  /**
   * Whether OBA icons are enabled for this placement.
   * @param obaEnabled obaEnabled or {@code null} for none
   */
  public SiteVideoSettings setObaEnabled(java.lang.Boolean obaEnabled) {
    this.obaEnabled = obaEnabled;
    return this;
  }

  /**
   * Settings for the OBA icon of video creatives served to this site. This will act as default for
   * new placements created under this site.
   * @return value or {@code null} for none
   */
  public ObaIcon getObaSettings() {
    return obaSettings;
  }

  /**
   * Settings for the OBA icon of video creatives served to this site. This will act as default for
   * new placements created under this site.
   * @param obaSettings obaSettings or {@code null} for none
   */
  public SiteVideoSettings setObaSettings(ObaIcon obaSettings) {
    this.obaSettings = obaSettings;
    return this;
  }

  /**
   * Orientation of a site template used for video. This will act as default for new placements
   * created under this site.
   * @return value or {@code null} for none
   */
  public java.lang.String getOrientation() {
    return orientation;
  }

  /**
   * Orientation of a site template used for video. This will act as default for new placements
   * created under this site.
   * @param orientation orientation or {@code null} for none
   */
  public SiteVideoSettings setOrientation(java.lang.String orientation) {
    this.orientation = orientation;
    return this;
  }

  /**
   * Publisher specification ID used to identify site-associated publisher requirements and
   * automatically populate transcode settings. If publisher specification ID is specified, it will
   * take precedence over transcode settings.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPublisherSpecificationId() {
    return publisherSpecificationId;
  }

  /**
   * Publisher specification ID used to identify site-associated publisher requirements and
   * automatically populate transcode settings. If publisher specification ID is specified, it will
   * take precedence over transcode settings.
   * @param publisherSpecificationId publisherSpecificationId or {@code null} for none
   */
  public SiteVideoSettings setPublisherSpecificationId(java.lang.Long publisherSpecificationId) {
    this.publisherSpecificationId = publisherSpecificationId;
    return this;
  }

  /**
   * Settings for the skippability of video creatives served to this site. This will act as default
   * for new placements created under this site.
   * @return value or {@code null} for none
   */
  public SiteSkippableSetting getSkippableSettings() {
    return skippableSettings;
  }

  /**
   * Settings for the skippability of video creatives served to this site. This will act as default
   * for new placements created under this site.
   * @param skippableSettings skippableSettings or {@code null} for none
   */
  public SiteVideoSettings setSkippableSettings(SiteSkippableSetting skippableSettings) {
    this.skippableSettings = skippableSettings;
    return this;
  }

  /**
   * Settings for the transcodes of video creatives served to this site. This will act as default
   * for new placements created under this site.
   * @return value or {@code null} for none
   */
  public SiteTranscodeSetting getTranscodeSettings() {
    return transcodeSettings;
  }

  /**
   * Settings for the transcodes of video creatives served to this site. This will act as default
   * for new placements created under this site.
   * @param transcodeSettings transcodeSettings or {@code null} for none
   */
  public SiteVideoSettings setTranscodeSettings(SiteTranscodeSetting transcodeSettings) {
    this.transcodeSettings = transcodeSettings;
    return this;
  }

  @Override
  public SiteVideoSettings set(String fieldName, Object value) {
    return (SiteVideoSettings) super.set(fieldName, value);
  }

  @Override
  public SiteVideoSettings clone() {
    return (SiteVideoSettings) super.clone();
  }

}
