/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Skippable Settings
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SkippableSetting extends com.google.api.client.json.GenericJson {

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#skippableSetting".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Amount of time to play videos served to this placement before counting a view. Applicable when
   * skippable is true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoOffset progressOffset;

  /**
   * Amount of time to play videos served to this placement before the skip button should appear.
   * Applicable when skippable is true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoOffset skipOffset;

  /**
   * Whether the user can skip creatives served to this placement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean skippable;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#skippableSetting".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#skippableSetting".
   * @param kind kind or {@code null} for none
   */
  public SkippableSetting setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Amount of time to play videos served to this placement before counting a view. Applicable when
   * skippable is true.
   * @return value or {@code null} for none
   */
  public VideoOffset getProgressOffset() {
    return progressOffset;
  }

  /**
   * Amount of time to play videos served to this placement before counting a view. Applicable when
   * skippable is true.
   * @param progressOffset progressOffset or {@code null} for none
   */
  public SkippableSetting setProgressOffset(VideoOffset progressOffset) {
    this.progressOffset = progressOffset;
    return this;
  }

  /**
   * Amount of time to play videos served to this placement before the skip button should appear.
   * Applicable when skippable is true.
   * @return value or {@code null} for none
   */
  public VideoOffset getSkipOffset() {
    return skipOffset;
  }

  /**
   * Amount of time to play videos served to this placement before the skip button should appear.
   * Applicable when skippable is true.
   * @param skipOffset skipOffset or {@code null} for none
   */
  public SkippableSetting setSkipOffset(VideoOffset skipOffset) {
    this.skipOffset = skipOffset;
    return this;
  }

  /**
   * Whether the user can skip creatives served to this placement.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSkippable() {
    return skippable;
  }

  /**
   * Whether the user can skip creatives served to this placement.
   * @param skippable skippable or {@code null} for none
   */
  public SkippableSetting setSkippable(java.lang.Boolean skippable) {
    this.skippable = skippable;
    return this;
  }

  @Override
  public SkippableSetting set(String fieldName, Object value) {
    return (SkippableSetting) super.set(fieldName, value);
  }

  @Override
  public SkippableSetting clone() {
    return (SkippableSetting) super.clone();
  }

}
