/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains properties of a targetable remarketing list. Remarketing enables you to create lists of
 * users who have performed specific actions on a site, then target ads to members of those lists.
 * This resource is a read-only view of a remarketing list to be used to faciliate targeting ads to
 * specific lists. Remarketing lists that are owned by your advertisers and those that are shared to
 * your advertisers or account are accessible via this resource. To manage remarketing lists that
 * are owned by your advertisers, use the RemarketingLists resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TargetableRemarketingList extends com.google.api.client.json.GenericJson {

  /**
   * Account ID of this remarketing list. This is a read-only, auto-generated field that is only
   * returned in GET requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * Whether this targetable remarketing list is active.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean active;

  /**
   * Dimension value for the advertiser ID that owns this targetable remarketing list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long advertiserId;

  /**
   * Dimension value for the ID of the advertiser.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue advertiserIdDimensionValue;

  /**
   * Targetable remarketing list description.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Targetable remarketing list ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#targetableRemarketingList".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Number of days that a user should remain in the targetable remarketing list without an
   * impression.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long lifeSpan;

  /**
   * Number of users currently in the list. This is a read-only field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long listSize;

  /**
   * Product from which this targetable remarketing list was originated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String listSource;

  /**
   * Name of the targetable remarketing list. Is no greater than 128 characters long.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Subaccount ID of this remarketing list. This is a read-only, auto-generated field that is only
   * returned in GET requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long subaccountId;

  /**
   * Account ID of this remarketing list. This is a read-only, auto-generated field that is only
   * returned in GET requests.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * Account ID of this remarketing list. This is a read-only, auto-generated field that is only
   * returned in GET requests.
   * @param accountId accountId or {@code null} for none
   */
  public TargetableRemarketingList setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Whether this targetable remarketing list is active.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getActive() {
    return active;
  }

  /**
   * Whether this targetable remarketing list is active.
   * @param active active or {@code null} for none
   */
  public TargetableRemarketingList setActive(java.lang.Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * Dimension value for the advertiser ID that owns this targetable remarketing list.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAdvertiserId() {
    return advertiserId;
  }

  /**
   * Dimension value for the advertiser ID that owns this targetable remarketing list.
   * @param advertiserId advertiserId or {@code null} for none
   */
  public TargetableRemarketingList setAdvertiserId(java.lang.Long advertiserId) {
    this.advertiserId = advertiserId;
    return this;
  }

  /**
   * Dimension value for the ID of the advertiser.
   * @return value or {@code null} for none
   */
  public DimensionValue getAdvertiserIdDimensionValue() {
    return advertiserIdDimensionValue;
  }

  /**
   * Dimension value for the ID of the advertiser.
   * @param advertiserIdDimensionValue advertiserIdDimensionValue or {@code null} for none
   */
  public TargetableRemarketingList setAdvertiserIdDimensionValue(DimensionValue advertiserIdDimensionValue) {
    this.advertiserIdDimensionValue = advertiserIdDimensionValue;
    return this;
  }

  /**
   * Targetable remarketing list description.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Targetable remarketing list description.
   * @param description description or {@code null} for none
   */
  public TargetableRemarketingList setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Targetable remarketing list ID.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * Targetable remarketing list ID.
   * @param id id or {@code null} for none
   */
  public TargetableRemarketingList setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#targetableRemarketingList".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#targetableRemarketingList".
   * @param kind kind or {@code null} for none
   */
  public TargetableRemarketingList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Number of days that a user should remain in the targetable remarketing list without an
   * impression.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLifeSpan() {
    return lifeSpan;
  }

  /**
   * Number of days that a user should remain in the targetable remarketing list without an
   * impression.
   * @param lifeSpan lifeSpan or {@code null} for none
   */
  public TargetableRemarketingList setLifeSpan(java.lang.Long lifeSpan) {
    this.lifeSpan = lifeSpan;
    return this;
  }

  /**
   * Number of users currently in the list. This is a read-only field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getListSize() {
    return listSize;
  }

  /**
   * Number of users currently in the list. This is a read-only field.
   * @param listSize listSize or {@code null} for none
   */
  public TargetableRemarketingList setListSize(java.lang.Long listSize) {
    this.listSize = listSize;
    return this;
  }

  /**
   * Product from which this targetable remarketing list was originated.
   * @return value or {@code null} for none
   */
  public java.lang.String getListSource() {
    return listSource;
  }

  /**
   * Product from which this targetable remarketing list was originated.
   * @param listSource listSource or {@code null} for none
   */
  public TargetableRemarketingList setListSource(java.lang.String listSource) {
    this.listSource = listSource;
    return this;
  }

  /**
   * Name of the targetable remarketing list. Is no greater than 128 characters long.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the targetable remarketing list. Is no greater than 128 characters long.
   * @param name name or {@code null} for none
   */
  public TargetableRemarketingList setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Subaccount ID of this remarketing list. This is a read-only, auto-generated field that is only
   * returned in GET requests.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSubaccountId() {
    return subaccountId;
  }

  /**
   * Subaccount ID of this remarketing list. This is a read-only, auto-generated field that is only
   * returned in GET requests.
   * @param subaccountId subaccountId or {@code null} for none
   */
  public TargetableRemarketingList setSubaccountId(java.lang.Long subaccountId) {
    this.subaccountId = subaccountId;
    return this;
  }

  @Override
  public TargetableRemarketingList set(String fieldName, Object value) {
    return (TargetableRemarketingList) super.set(fieldName, value);
  }

  @Override
  public TargetableRemarketingList clone() {
    return (TargetableRemarketingList) super.clone();
  }

}
