/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains properties of a Campaign Manager account.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Account extends com.google.api.client.json.GenericJson {

  /**
   * Account permissions assigned to this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> accountPermissionIds;

  /**
   * Profile for this account. This is a read-only field that can be left blank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountProfile;

  /**
   * Whether this account is active.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean active;

  /**
   * Maximum number of active ads allowed for this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String activeAdsLimitTier;

  /**
   * Whether to serve creatives with Active View tags. If disabled, viewability data will not be
   * available for any impressions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean activeViewOptOut;

  /**
   * User role permissions available to the user roles of this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> availablePermissionIds;

  /**
   * ID of the country associated with this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long countryId;

  /**
   * ID of currency associated with this account. This is a required field. Acceptable values are: -
   * "1" for USD - "2" for GBP - "3" for ESP - "4" for SEK - "5" for CAD - "6" for JPY - "7" for DEM
   * - "8" for AUD - "9" for FRF - "10" for ITL - "11" for DKK - "12" for NOK - "13" for FIM - "14"
   * for ZAR - "15" for IEP - "16" for NLG - "17" for EUR - "18" for KRW - "19" for TWD - "20" for
   * SGD - "21" for CNY - "22" for HKD - "23" for NZD - "24" for MYR - "25" for BRL - "26" for PTE -
   * "28" for CLP - "29" for TRY - "30" for ARS - "31" for PEN - "32" for ILS - "33" for CHF - "34"
   * for VEF - "35" for COP - "36" for GTQ - "37" for PLN - "39" for INR - "40" for THB - "41" for
   * IDR - "42" for CZK - "43" for RON - "44" for HUF - "45" for RUB - "46" for AED - "47" for BGN -
   * "48" for HRK - "49" for MXN - "50" for NGN - "51" for EGP
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long currencyId;

  /**
   * Default placement dimensions for this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long defaultCreativeSizeId;

  /**
   * Description of this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * ID of this account. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#account".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Locale of this account. Acceptable values are: - "cs" (Czech) - "de" (German) - "en" (English)
   * - "en-GB" (English United Kingdom) - "es" (Spanish) - "fr" (French) - "it" (Italian) - "ja"
   * (Japanese) - "ko" (Korean) - "pl" (Polish) - "pt-BR" (Portuguese Brazil) - "ru" (Russian) -
   * "sv" (Swedish) - "tr" (Turkish) - "zh-CN" (Chinese Simplified) - "zh-TW" (Chinese Traditional)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locale;

  /**
   * Maximum image size allowed for this account, in kilobytes. Value must be greater than or equal
   * to 1.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maximumImageSize;

  /**
   * Name of this account. This is a required field, and must be less than 128 characters long and
   * be globally unique.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Whether campaigns created in this account will be enabled for Nielsen OCR reach ratings by
   * default.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean nielsenOcrEnabled;

  /**
   * Reporting configuration of this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReportsConfiguration reportsConfiguration;

  /**
   * Share Path to Conversion reports with Twitter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean shareReportsWithTwitter;

  /**
   * File size limit in kilobytes of Rich Media teaser creatives. Acceptable values are 1 to 10240,
   * inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long teaserSizeLimit;

  /**
   * Account permissions assigned to this account.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getAccountPermissionIds() {
    return accountPermissionIds;
  }

  /**
   * Account permissions assigned to this account.
   * @param accountPermissionIds accountPermissionIds or {@code null} for none
   */
  public Account setAccountPermissionIds(java.util.List<java.lang.Long> accountPermissionIds) {
    this.accountPermissionIds = accountPermissionIds;
    return this;
  }

  /**
   * Profile for this account. This is a read-only field that can be left blank.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountProfile() {
    return accountProfile;
  }

  /**
   * Profile for this account. This is a read-only field that can be left blank.
   * @param accountProfile accountProfile or {@code null} for none
   */
  public Account setAccountProfile(java.lang.String accountProfile) {
    this.accountProfile = accountProfile;
    return this;
  }

  /**
   * Whether this account is active.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getActive() {
    return active;
  }

  /**
   * Whether this account is active.
   * @param active active or {@code null} for none
   */
  public Account setActive(java.lang.Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * Maximum number of active ads allowed for this account.
   * @return value or {@code null} for none
   */
  public java.lang.String getActiveAdsLimitTier() {
    return activeAdsLimitTier;
  }

  /**
   * Maximum number of active ads allowed for this account.
   * @param activeAdsLimitTier activeAdsLimitTier or {@code null} for none
   */
  public Account setActiveAdsLimitTier(java.lang.String activeAdsLimitTier) {
    this.activeAdsLimitTier = activeAdsLimitTier;
    return this;
  }

  /**
   * Whether to serve creatives with Active View tags. If disabled, viewability data will not be
   * available for any impressions.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getActiveViewOptOut() {
    return activeViewOptOut;
  }

  /**
   * Whether to serve creatives with Active View tags. If disabled, viewability data will not be
   * available for any impressions.
   * @param activeViewOptOut activeViewOptOut or {@code null} for none
   */
  public Account setActiveViewOptOut(java.lang.Boolean activeViewOptOut) {
    this.activeViewOptOut = activeViewOptOut;
    return this;
  }

  /**
   * User role permissions available to the user roles of this account.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getAvailablePermissionIds() {
    return availablePermissionIds;
  }

  /**
   * User role permissions available to the user roles of this account.
   * @param availablePermissionIds availablePermissionIds or {@code null} for none
   */
  public Account setAvailablePermissionIds(java.util.List<java.lang.Long> availablePermissionIds) {
    this.availablePermissionIds = availablePermissionIds;
    return this;
  }

  /**
   * ID of the country associated with this account.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCountryId() {
    return countryId;
  }

  /**
   * ID of the country associated with this account.
   * @param countryId countryId or {@code null} for none
   */
  public Account setCountryId(java.lang.Long countryId) {
    this.countryId = countryId;
    return this;
  }

  /**
   * ID of currency associated with this account. This is a required field. Acceptable values are: -
   * "1" for USD - "2" for GBP - "3" for ESP - "4" for SEK - "5" for CAD - "6" for JPY - "7" for DEM
   * - "8" for AUD - "9" for FRF - "10" for ITL - "11" for DKK - "12" for NOK - "13" for FIM - "14"
   * for ZAR - "15" for IEP - "16" for NLG - "17" for EUR - "18" for KRW - "19" for TWD - "20" for
   * SGD - "21" for CNY - "22" for HKD - "23" for NZD - "24" for MYR - "25" for BRL - "26" for PTE -
   * "28" for CLP - "29" for TRY - "30" for ARS - "31" for PEN - "32" for ILS - "33" for CHF - "34"
   * for VEF - "35" for COP - "36" for GTQ - "37" for PLN - "39" for INR - "40" for THB - "41" for
   * IDR - "42" for CZK - "43" for RON - "44" for HUF - "45" for RUB - "46" for AED - "47" for BGN -
   * "48" for HRK - "49" for MXN - "50" for NGN - "51" for EGP
   * @return value or {@code null} for none
   */
  public java.lang.Long getCurrencyId() {
    return currencyId;
  }

  /**
   * ID of currency associated with this account. This is a required field. Acceptable values are: -
   * "1" for USD - "2" for GBP - "3" for ESP - "4" for SEK - "5" for CAD - "6" for JPY - "7" for DEM
   * - "8" for AUD - "9" for FRF - "10" for ITL - "11" for DKK - "12" for NOK - "13" for FIM - "14"
   * for ZAR - "15" for IEP - "16" for NLG - "17" for EUR - "18" for KRW - "19" for TWD - "20" for
   * SGD - "21" for CNY - "22" for HKD - "23" for NZD - "24" for MYR - "25" for BRL - "26" for PTE -
   * "28" for CLP - "29" for TRY - "30" for ARS - "31" for PEN - "32" for ILS - "33" for CHF - "34"
   * for VEF - "35" for COP - "36" for GTQ - "37" for PLN - "39" for INR - "40" for THB - "41" for
   * IDR - "42" for CZK - "43" for RON - "44" for HUF - "45" for RUB - "46" for AED - "47" for BGN -
   * "48" for HRK - "49" for MXN - "50" for NGN - "51" for EGP
   * @param currencyId currencyId or {@code null} for none
   */
  public Account setCurrencyId(java.lang.Long currencyId) {
    this.currencyId = currencyId;
    return this;
  }

  /**
   * Default placement dimensions for this account.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDefaultCreativeSizeId() {
    return defaultCreativeSizeId;
  }

  /**
   * Default placement dimensions for this account.
   * @param defaultCreativeSizeId defaultCreativeSizeId or {@code null} for none
   */
  public Account setDefaultCreativeSizeId(java.lang.Long defaultCreativeSizeId) {
    this.defaultCreativeSizeId = defaultCreativeSizeId;
    return this;
  }

  /**
   * Description of this account.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Description of this account.
   * @param description description or {@code null} for none
   */
  public Account setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * ID of this account. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this account. This is a read-only, auto-generated field.
   * @param id id or {@code null} for none
   */
  public Account setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#account".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#account".
   * @param kind kind or {@code null} for none
   */
  public Account setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Locale of this account. Acceptable values are: - "cs" (Czech) - "de" (German) - "en" (English)
   * - "en-GB" (English United Kingdom) - "es" (Spanish) - "fr" (French) - "it" (Italian) - "ja"
   * (Japanese) - "ko" (Korean) - "pl" (Polish) - "pt-BR" (Portuguese Brazil) - "ru" (Russian) -
   * "sv" (Swedish) - "tr" (Turkish) - "zh-CN" (Chinese Simplified) - "zh-TW" (Chinese Traditional)
   * @return value or {@code null} for none
   */
  public java.lang.String getLocale() {
    return locale;
  }

  /**
   * Locale of this account. Acceptable values are: - "cs" (Czech) - "de" (German) - "en" (English)
   * - "en-GB" (English United Kingdom) - "es" (Spanish) - "fr" (French) - "it" (Italian) - "ja"
   * (Japanese) - "ko" (Korean) - "pl" (Polish) - "pt-BR" (Portuguese Brazil) - "ru" (Russian) -
   * "sv" (Swedish) - "tr" (Turkish) - "zh-CN" (Chinese Simplified) - "zh-TW" (Chinese Traditional)
   * @param locale locale or {@code null} for none
   */
  public Account setLocale(java.lang.String locale) {
    this.locale = locale;
    return this;
  }

  /**
   * Maximum image size allowed for this account, in kilobytes. Value must be greater than or equal
   * to 1.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaximumImageSize() {
    return maximumImageSize;
  }

  /**
   * Maximum image size allowed for this account, in kilobytes. Value must be greater than or equal
   * to 1.
   * @param maximumImageSize maximumImageSize or {@code null} for none
   */
  public Account setMaximumImageSize(java.lang.Long maximumImageSize) {
    this.maximumImageSize = maximumImageSize;
    return this;
  }

  /**
   * Name of this account. This is a required field, and must be less than 128 characters long and
   * be globally unique.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this account. This is a required field, and must be less than 128 characters long and
   * be globally unique.
   * @param name name or {@code null} for none
   */
  public Account setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Whether campaigns created in this account will be enabled for Nielsen OCR reach ratings by
   * default.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getNielsenOcrEnabled() {
    return nielsenOcrEnabled;
  }

  /**
   * Whether campaigns created in this account will be enabled for Nielsen OCR reach ratings by
   * default.
   * @param nielsenOcrEnabled nielsenOcrEnabled or {@code null} for none
   */
  public Account setNielsenOcrEnabled(java.lang.Boolean nielsenOcrEnabled) {
    this.nielsenOcrEnabled = nielsenOcrEnabled;
    return this;
  }

  /**
   * Reporting configuration of this account.
   * @return value or {@code null} for none
   */
  public ReportsConfiguration getReportsConfiguration() {
    return reportsConfiguration;
  }

  /**
   * Reporting configuration of this account.
   * @param reportsConfiguration reportsConfiguration or {@code null} for none
   */
  public Account setReportsConfiguration(ReportsConfiguration reportsConfiguration) {
    this.reportsConfiguration = reportsConfiguration;
    return this;
  }

  /**
   * Share Path to Conversion reports with Twitter.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShareReportsWithTwitter() {
    return shareReportsWithTwitter;
  }

  /**
   * Share Path to Conversion reports with Twitter.
   * @param shareReportsWithTwitter shareReportsWithTwitter or {@code null} for none
   */
  public Account setShareReportsWithTwitter(java.lang.Boolean shareReportsWithTwitter) {
    this.shareReportsWithTwitter = shareReportsWithTwitter;
    return this;
  }

  /**
   * File size limit in kilobytes of Rich Media teaser creatives. Acceptable values are 1 to 10240,
   * inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTeaserSizeLimit() {
    return teaserSizeLimit;
  }

  /**
   * File size limit in kilobytes of Rich Media teaser creatives. Acceptable values are 1 to 10240,
   * inclusive.
   * @param teaserSizeLimit teaserSizeLimit or {@code null} for none
   */
  public Account setTeaserSizeLimit(java.lang.Long teaserSizeLimit) {
    this.teaserSizeLimit = teaserSizeLimit;
    return this;
  }

  @Override
  public Account set(String fieldName, Object value) {
    return (Account) super.set(fieldName, value);
  }

  @Override
  public Account clone() {
    return (Account) super.clone();
  }

}
