/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Represents an activity group.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Activities extends com.google.api.client.json.GenericJson {

  /**
   * List of activity filters. The dimension values need to be all either of type "dfa:activity" or
   * "dfa:activityGroup".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DimensionValue> filters;

  /**
   * The kind of resource this is, in this case dfareporting#activities.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * List of names of floodlight activity metrics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> metricNames;

  /**
   * List of activity filters. The dimension values need to be all either of type "dfa:activity" or
   * "dfa:activityGroup".
   * @return value or {@code null} for none
   */
  public java.util.List<DimensionValue> getFilters() {
    return filters;
  }

  /**
   * List of activity filters. The dimension values need to be all either of type "dfa:activity" or
   * "dfa:activityGroup".
   * @param filters filters or {@code null} for none
   */
  public Activities setFilters(java.util.List<DimensionValue> filters) {
    this.filters = filters;
    return this;
  }

  /**
   * The kind of resource this is, in this case dfareporting#activities.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of resource this is, in this case dfareporting#activities.
   * @param kind kind or {@code null} for none
   */
  public Activities setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * List of names of floodlight activity metrics.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getMetricNames() {
    return metricNames;
  }

  /**
   * List of names of floodlight activity metrics.
   * @param metricNames metricNames or {@code null} for none
   */
  public Activities setMetricNames(java.util.List<java.lang.String> metricNames) {
    this.metricNames = metricNames;
    return this;
  }

  @Override
  public Activities set(String fieldName, Object value) {
    return (Activities) super.set(fieldName, value);
  }

  @Override
  public Activities clone() {
    return (Activities) super.clone();
  }

}
