/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains properties of a Campaign Manager ad.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Ad extends com.google.api.client.json.GenericJson {

  /**
   * Account ID of this ad. This is a read-only field that can be left blank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * Whether this ad is active. When true, archived must be false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean active;

  /**
   * Advertiser ID of this ad. This is a required field on insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long advertiserId;

  /**
   * Dimension value for the ID of the advertiser. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue advertiserIdDimensionValue;

  /**
   * Whether this ad is archived. When true, active must be false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean archived;

  /**
   * Audience segment ID that is being targeted for this ad. Applicable when type is
   * AD_SERVING_STANDARD_AD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long audienceSegmentId;

  /**
   * Campaign ID of this ad. This is a required field on insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long campaignId;

  /**
   * Dimension value for the ID of the campaign. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue campaignIdDimensionValue;

  /**
   * Click-through URL for this ad. This is a required field on insertion. Applicable when type is
   * AD_SERVING_CLICK_TRACKER.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ClickThroughUrl clickThroughUrl;

  /**
   * Click-through URL suffix properties for this ad. Applies to the URL in the ad or (if overriding
   * ad properties) the URL in the creative.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ClickThroughUrlSuffixProperties clickThroughUrlSuffixProperties;

  /**
   * Comments for this ad.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String comments;

  /**
   * Compatibility of this ad. Applicable when type is AD_SERVING_DEFAULT_AD. DISPLAY and
   * DISPLAY_INTERSTITIAL refer to either rendering on desktop or on mobile devices or in mobile
   * apps for regular or interstitial ads, respectively. APP and APP_INTERSTITIAL are only used for
   * existing default ads. New mobile placements must be assigned DISPLAY or DISPLAY_INTERSTITIAL
   * and default ads created for those placements will be limited to those compatibility types.
   * IN_STREAM_VIDEO refers to rendering in-stream video ads developed with the VAST standard.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String compatibility;

  /**
   * Information about the creation of this ad. This is a read-only field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LastModifiedInfo createInfo;

  /**
   * Creative group assignments for this ad. Applicable when type is AD_SERVING_CLICK_TRACKER. Only
   * one assignment per creative group number is allowed for a maximum of two assignments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CreativeGroupAssignment> creativeGroupAssignments;

  /**
   * Creative rotation for this ad. Applicable when type is AD_SERVING_DEFAULT_AD,
   * AD_SERVING_STANDARD_AD, or AD_SERVING_TRACKING. When type is AD_SERVING_DEFAULT_AD, this field
   * should have exactly one creativeAssignment .
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreativeRotation creativeRotation;

  /**
   * Time and day targeting information for this ad. This field must be left blank if the ad is
   * using a targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DayPartTargeting dayPartTargeting;

  /**
   * Default click-through event tag properties for this ad.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DefaultClickThroughEventTagProperties defaultClickThroughEventTagProperties;

  /**
   * Delivery schedule information for this ad. Applicable when type is AD_SERVING_STANDARD_AD or
   * AD_SERVING_TRACKING. This field along with subfields priority and impressionRatio are required
   * on insertion when type is AD_SERVING_STANDARD_AD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeliverySchedule deliverySchedule;

  /**
   * Whether this ad is a dynamic click tracker. Applicable when type is AD_SERVING_CLICK_TRACKER.
   * This is a required field on insert, and is read-only after insert.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean dynamicClickTracker;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime endTime;

  /**
   * Event tag overrides for this ad.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<EventTagOverride> eventTagOverrides;

  /**
   * Geographical targeting information for this ad. This field must be left blank if the ad is
   * using a targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GeoTargeting geoTargeting;

  /**
   * ID of this ad. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Dimension value for the ID of this ad. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue idDimensionValue;

  /**
   * Key-value targeting information for this ad. This field must be left blank if the ad is using a
   * targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private KeyValueTargetingExpression keyValueTargetingExpression;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#ad".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Language targeting information for this ad. This field must be left blank if the ad is using a
   * targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LanguageTargeting languageTargeting;

  /**
   * Information about the most recent modification of this ad. This is a read-only field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LastModifiedInfo lastModifiedInfo;

  /**
   * Name of this ad. This is a required field and must be less than 256 characters long.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Placement assignments for this ad.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PlacementAssignment> placementAssignments;

  /**
   * Remarketing list targeting expression for this ad. This field must be left blank if the ad is
   * using a targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ListTargetingExpression remarketingListExpression;

  /**
   * Size of this ad. Applicable when type is AD_SERVING_DEFAULT_AD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Size size;

  /**
   * Whether this ad is ssl compliant. This is a read-only field that is auto-generated when the ad
   * is inserted or updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean sslCompliant;

  /**
   * Whether this ad requires ssl. This is a read-only field that is auto-generated when the ad is
   * inserted or updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean sslRequired;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime startTime;

  /**
   * Subaccount ID of this ad. This is a read-only field that can be left blank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long subaccountId;

  /**
   * Targeting template ID, used to apply preconfigured targeting information to this ad. This
   * cannot be set while any of dayPartTargeting, geoTargeting, keyValueTargetingExpression,
   * languageTargeting, remarketingListExpression, or technologyTargeting are set. Applicable when
   * type is AD_SERVING_STANDARD_AD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long targetingTemplateId;

  /**
   * Technology platform targeting information for this ad. This field must be left blank if the ad
   * is using a targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TechnologyTargeting technologyTargeting;

  /**
   * Type of ad. This is a required field on insertion. Note that default ads (
   * AD_SERVING_DEFAULT_AD) cannot be created directly (see Creative resource).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Account ID of this ad. This is a read-only field that can be left blank.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * Account ID of this ad. This is a read-only field that can be left blank.
   * @param accountId accountId or {@code null} for none
   */
  public Ad setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Whether this ad is active. When true, archived must be false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getActive() {
    return active;
  }

  /**
   * Whether this ad is active. When true, archived must be false.
   * @param active active or {@code null} for none
   */
  public Ad setActive(java.lang.Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * Advertiser ID of this ad. This is a required field on insertion.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAdvertiserId() {
    return advertiserId;
  }

  /**
   * Advertiser ID of this ad. This is a required field on insertion.
   * @param advertiserId advertiserId or {@code null} for none
   */
  public Ad setAdvertiserId(java.lang.Long advertiserId) {
    this.advertiserId = advertiserId;
    return this;
  }

  /**
   * Dimension value for the ID of the advertiser. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getAdvertiserIdDimensionValue() {
    return advertiserIdDimensionValue;
  }

  /**
   * Dimension value for the ID of the advertiser. This is a read-only, auto-generated field.
   * @param advertiserIdDimensionValue advertiserIdDimensionValue or {@code null} for none
   */
  public Ad setAdvertiserIdDimensionValue(DimensionValue advertiserIdDimensionValue) {
    this.advertiserIdDimensionValue = advertiserIdDimensionValue;
    return this;
  }

  /**
   * Whether this ad is archived. When true, active must be false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getArchived() {
    return archived;
  }

  /**
   * Whether this ad is archived. When true, active must be false.
   * @param archived archived or {@code null} for none
   */
  public Ad setArchived(java.lang.Boolean archived) {
    this.archived = archived;
    return this;
  }

  /**
   * Audience segment ID that is being targeted for this ad. Applicable when type is
   * AD_SERVING_STANDARD_AD.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAudienceSegmentId() {
    return audienceSegmentId;
  }

  /**
   * Audience segment ID that is being targeted for this ad. Applicable when type is
   * AD_SERVING_STANDARD_AD.
   * @param audienceSegmentId audienceSegmentId or {@code null} for none
   */
  public Ad setAudienceSegmentId(java.lang.Long audienceSegmentId) {
    this.audienceSegmentId = audienceSegmentId;
    return this;
  }

  /**
   * Campaign ID of this ad. This is a required field on insertion.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCampaignId() {
    return campaignId;
  }

  /**
   * Campaign ID of this ad. This is a required field on insertion.
   * @param campaignId campaignId or {@code null} for none
   */
  public Ad setCampaignId(java.lang.Long campaignId) {
    this.campaignId = campaignId;
    return this;
  }

  /**
   * Dimension value for the ID of the campaign. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getCampaignIdDimensionValue() {
    return campaignIdDimensionValue;
  }

  /**
   * Dimension value for the ID of the campaign. This is a read-only, auto-generated field.
   * @param campaignIdDimensionValue campaignIdDimensionValue or {@code null} for none
   */
  public Ad setCampaignIdDimensionValue(DimensionValue campaignIdDimensionValue) {
    this.campaignIdDimensionValue = campaignIdDimensionValue;
    return this;
  }

  /**
   * Click-through URL for this ad. This is a required field on insertion. Applicable when type is
   * AD_SERVING_CLICK_TRACKER.
   * @return value or {@code null} for none
   */
  public ClickThroughUrl getClickThroughUrl() {
    return clickThroughUrl;
  }

  /**
   * Click-through URL for this ad. This is a required field on insertion. Applicable when type is
   * AD_SERVING_CLICK_TRACKER.
   * @param clickThroughUrl clickThroughUrl or {@code null} for none
   */
  public Ad setClickThroughUrl(ClickThroughUrl clickThroughUrl) {
    this.clickThroughUrl = clickThroughUrl;
    return this;
  }

  /**
   * Click-through URL suffix properties for this ad. Applies to the URL in the ad or (if overriding
   * ad properties) the URL in the creative.
   * @return value or {@code null} for none
   */
  public ClickThroughUrlSuffixProperties getClickThroughUrlSuffixProperties() {
    return clickThroughUrlSuffixProperties;
  }

  /**
   * Click-through URL suffix properties for this ad. Applies to the URL in the ad or (if overriding
   * ad properties) the URL in the creative.
   * @param clickThroughUrlSuffixProperties clickThroughUrlSuffixProperties or {@code null} for none
   */
  public Ad setClickThroughUrlSuffixProperties(ClickThroughUrlSuffixProperties clickThroughUrlSuffixProperties) {
    this.clickThroughUrlSuffixProperties = clickThroughUrlSuffixProperties;
    return this;
  }

  /**
   * Comments for this ad.
   * @return value or {@code null} for none
   */
  public java.lang.String getComments() {
    return comments;
  }

  /**
   * Comments for this ad.
   * @param comments comments or {@code null} for none
   */
  public Ad setComments(java.lang.String comments) {
    this.comments = comments;
    return this;
  }

  /**
   * Compatibility of this ad. Applicable when type is AD_SERVING_DEFAULT_AD. DISPLAY and
   * DISPLAY_INTERSTITIAL refer to either rendering on desktop or on mobile devices or in mobile
   * apps for regular or interstitial ads, respectively. APP and APP_INTERSTITIAL are only used for
   * existing default ads. New mobile placements must be assigned DISPLAY or DISPLAY_INTERSTITIAL
   * and default ads created for those placements will be limited to those compatibility types.
   * IN_STREAM_VIDEO refers to rendering in-stream video ads developed with the VAST standard.
   * @return value or {@code null} for none
   */
  public java.lang.String getCompatibility() {
    return compatibility;
  }

  /**
   * Compatibility of this ad. Applicable when type is AD_SERVING_DEFAULT_AD. DISPLAY and
   * DISPLAY_INTERSTITIAL refer to either rendering on desktop or on mobile devices or in mobile
   * apps for regular or interstitial ads, respectively. APP and APP_INTERSTITIAL are only used for
   * existing default ads. New mobile placements must be assigned DISPLAY or DISPLAY_INTERSTITIAL
   * and default ads created for those placements will be limited to those compatibility types.
   * IN_STREAM_VIDEO refers to rendering in-stream video ads developed with the VAST standard.
   * @param compatibility compatibility or {@code null} for none
   */
  public Ad setCompatibility(java.lang.String compatibility) {
    this.compatibility = compatibility;
    return this;
  }

  /**
   * Information about the creation of this ad. This is a read-only field.
   * @return value or {@code null} for none
   */
  public LastModifiedInfo getCreateInfo() {
    return createInfo;
  }

  /**
   * Information about the creation of this ad. This is a read-only field.
   * @param createInfo createInfo or {@code null} for none
   */
  public Ad setCreateInfo(LastModifiedInfo createInfo) {
    this.createInfo = createInfo;
    return this;
  }

  /**
   * Creative group assignments for this ad. Applicable when type is AD_SERVING_CLICK_TRACKER. Only
   * one assignment per creative group number is allowed for a maximum of two assignments.
   * @return value or {@code null} for none
   */
  public java.util.List<CreativeGroupAssignment> getCreativeGroupAssignments() {
    return creativeGroupAssignments;
  }

  /**
   * Creative group assignments for this ad. Applicable when type is AD_SERVING_CLICK_TRACKER. Only
   * one assignment per creative group number is allowed for a maximum of two assignments.
   * @param creativeGroupAssignments creativeGroupAssignments or {@code null} for none
   */
  public Ad setCreativeGroupAssignments(java.util.List<CreativeGroupAssignment> creativeGroupAssignments) {
    this.creativeGroupAssignments = creativeGroupAssignments;
    return this;
  }

  /**
   * Creative rotation for this ad. Applicable when type is AD_SERVING_DEFAULT_AD,
   * AD_SERVING_STANDARD_AD, or AD_SERVING_TRACKING. When type is AD_SERVING_DEFAULT_AD, this field
   * should have exactly one creativeAssignment .
   * @return value or {@code null} for none
   */
  public CreativeRotation getCreativeRotation() {
    return creativeRotation;
  }

  /**
   * Creative rotation for this ad. Applicable when type is AD_SERVING_DEFAULT_AD,
   * AD_SERVING_STANDARD_AD, or AD_SERVING_TRACKING. When type is AD_SERVING_DEFAULT_AD, this field
   * should have exactly one creativeAssignment .
   * @param creativeRotation creativeRotation or {@code null} for none
   */
  public Ad setCreativeRotation(CreativeRotation creativeRotation) {
    this.creativeRotation = creativeRotation;
    return this;
  }

  /**
   * Time and day targeting information for this ad. This field must be left blank if the ad is
   * using a targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * @return value or {@code null} for none
   */
  public DayPartTargeting getDayPartTargeting() {
    return dayPartTargeting;
  }

  /**
   * Time and day targeting information for this ad. This field must be left blank if the ad is
   * using a targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * @param dayPartTargeting dayPartTargeting or {@code null} for none
   */
  public Ad setDayPartTargeting(DayPartTargeting dayPartTargeting) {
    this.dayPartTargeting = dayPartTargeting;
    return this;
  }

  /**
   * Default click-through event tag properties for this ad.
   * @return value or {@code null} for none
   */
  public DefaultClickThroughEventTagProperties getDefaultClickThroughEventTagProperties() {
    return defaultClickThroughEventTagProperties;
  }

  /**
   * Default click-through event tag properties for this ad.
   * @param defaultClickThroughEventTagProperties defaultClickThroughEventTagProperties or {@code null} for none
   */
  public Ad setDefaultClickThroughEventTagProperties(DefaultClickThroughEventTagProperties defaultClickThroughEventTagProperties) {
    this.defaultClickThroughEventTagProperties = defaultClickThroughEventTagProperties;
    return this;
  }

  /**
   * Delivery schedule information for this ad. Applicable when type is AD_SERVING_STANDARD_AD or
   * AD_SERVING_TRACKING. This field along with subfields priority and impressionRatio are required
   * on insertion when type is AD_SERVING_STANDARD_AD.
   * @return value or {@code null} for none
   */
  public DeliverySchedule getDeliverySchedule() {
    return deliverySchedule;
  }

  /**
   * Delivery schedule information for this ad. Applicable when type is AD_SERVING_STANDARD_AD or
   * AD_SERVING_TRACKING. This field along with subfields priority and impressionRatio are required
   * on insertion when type is AD_SERVING_STANDARD_AD.
   * @param deliverySchedule deliverySchedule or {@code null} for none
   */
  public Ad setDeliverySchedule(DeliverySchedule deliverySchedule) {
    this.deliverySchedule = deliverySchedule;
    return this;
  }

  /**
   * Whether this ad is a dynamic click tracker. Applicable when type is AD_SERVING_CLICK_TRACKER.
   * This is a required field on insert, and is read-only after insert.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDynamicClickTracker() {
    return dynamicClickTracker;
  }

  /**
   * Whether this ad is a dynamic click tracker. Applicable when type is AD_SERVING_CLICK_TRACKER.
   * This is a required field on insert, and is read-only after insert.
   * @param dynamicClickTracker dynamicClickTracker or {@code null} for none
   */
  public Ad setDynamicClickTracker(java.lang.Boolean dynamicClickTracker) {
    this.dynamicClickTracker = dynamicClickTracker;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getEndTime() {
    return endTime;
  }

  /**
   * @param endTime endTime or {@code null} for none
   */
  public Ad setEndTime(com.google.api.client.util.DateTime endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * Event tag overrides for this ad.
   * @return value or {@code null} for none
   */
  public java.util.List<EventTagOverride> getEventTagOverrides() {
    return eventTagOverrides;
  }

  /**
   * Event tag overrides for this ad.
   * @param eventTagOverrides eventTagOverrides or {@code null} for none
   */
  public Ad setEventTagOverrides(java.util.List<EventTagOverride> eventTagOverrides) {
    this.eventTagOverrides = eventTagOverrides;
    return this;
  }

  /**
   * Geographical targeting information for this ad. This field must be left blank if the ad is
   * using a targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * @return value or {@code null} for none
   */
  public GeoTargeting getGeoTargeting() {
    return geoTargeting;
  }

  /**
   * Geographical targeting information for this ad. This field must be left blank if the ad is
   * using a targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * @param geoTargeting geoTargeting or {@code null} for none
   */
  public Ad setGeoTargeting(GeoTargeting geoTargeting) {
    this.geoTargeting = geoTargeting;
    return this;
  }

  /**
   * ID of this ad. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this ad. This is a read-only, auto-generated field.
   * @param id id or {@code null} for none
   */
  public Ad setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Dimension value for the ID of this ad. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getIdDimensionValue() {
    return idDimensionValue;
  }

  /**
   * Dimension value for the ID of this ad. This is a read-only, auto-generated field.
   * @param idDimensionValue idDimensionValue or {@code null} for none
   */
  public Ad setIdDimensionValue(DimensionValue idDimensionValue) {
    this.idDimensionValue = idDimensionValue;
    return this;
  }

  /**
   * Key-value targeting information for this ad. This field must be left blank if the ad is using a
   * targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * @return value or {@code null} for none
   */
  public KeyValueTargetingExpression getKeyValueTargetingExpression() {
    return keyValueTargetingExpression;
  }

  /**
   * Key-value targeting information for this ad. This field must be left blank if the ad is using a
   * targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * @param keyValueTargetingExpression keyValueTargetingExpression or {@code null} for none
   */
  public Ad setKeyValueTargetingExpression(KeyValueTargetingExpression keyValueTargetingExpression) {
    this.keyValueTargetingExpression = keyValueTargetingExpression;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#ad".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#ad".
   * @param kind kind or {@code null} for none
   */
  public Ad setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Language targeting information for this ad. This field must be left blank if the ad is using a
   * targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * @return value or {@code null} for none
   */
  public LanguageTargeting getLanguageTargeting() {
    return languageTargeting;
  }

  /**
   * Language targeting information for this ad. This field must be left blank if the ad is using a
   * targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * @param languageTargeting languageTargeting or {@code null} for none
   */
  public Ad setLanguageTargeting(LanguageTargeting languageTargeting) {
    this.languageTargeting = languageTargeting;
    return this;
  }

  /**
   * Information about the most recent modification of this ad. This is a read-only field.
   * @return value or {@code null} for none
   */
  public LastModifiedInfo getLastModifiedInfo() {
    return lastModifiedInfo;
  }

  /**
   * Information about the most recent modification of this ad. This is a read-only field.
   * @param lastModifiedInfo lastModifiedInfo or {@code null} for none
   */
  public Ad setLastModifiedInfo(LastModifiedInfo lastModifiedInfo) {
    this.lastModifiedInfo = lastModifiedInfo;
    return this;
  }

  /**
   * Name of this ad. This is a required field and must be less than 256 characters long.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this ad. This is a required field and must be less than 256 characters long.
   * @param name name or {@code null} for none
   */
  public Ad setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Placement assignments for this ad.
   * @return value or {@code null} for none
   */
  public java.util.List<PlacementAssignment> getPlacementAssignments() {
    return placementAssignments;
  }

  /**
   * Placement assignments for this ad.
   * @param placementAssignments placementAssignments or {@code null} for none
   */
  public Ad setPlacementAssignments(java.util.List<PlacementAssignment> placementAssignments) {
    this.placementAssignments = placementAssignments;
    return this;
  }

  /**
   * Remarketing list targeting expression for this ad. This field must be left blank if the ad is
   * using a targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * @return value or {@code null} for none
   */
  public ListTargetingExpression getRemarketingListExpression() {
    return remarketingListExpression;
  }

  /**
   * Remarketing list targeting expression for this ad. This field must be left blank if the ad is
   * using a targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * @param remarketingListExpression remarketingListExpression or {@code null} for none
   */
  public Ad setRemarketingListExpression(ListTargetingExpression remarketingListExpression) {
    this.remarketingListExpression = remarketingListExpression;
    return this;
  }

  /**
   * Size of this ad. Applicable when type is AD_SERVING_DEFAULT_AD.
   * @return value or {@code null} for none
   */
  public Size getSize() {
    return size;
  }

  /**
   * Size of this ad. Applicable when type is AD_SERVING_DEFAULT_AD.
   * @param size size or {@code null} for none
   */
  public Ad setSize(Size size) {
    this.size = size;
    return this;
  }

  /**
   * Whether this ad is ssl compliant. This is a read-only field that is auto-generated when the ad
   * is inserted or updated.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSslCompliant() {
    return sslCompliant;
  }

  /**
   * Whether this ad is ssl compliant. This is a read-only field that is auto-generated when the ad
   * is inserted or updated.
   * @param sslCompliant sslCompliant or {@code null} for none
   */
  public Ad setSslCompliant(java.lang.Boolean sslCompliant) {
    this.sslCompliant = sslCompliant;
    return this;
  }

  /**
   * Whether this ad requires ssl. This is a read-only field that is auto-generated when the ad is
   * inserted or updated.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSslRequired() {
    return sslRequired;
  }

  /**
   * Whether this ad requires ssl. This is a read-only field that is auto-generated when the ad is
   * inserted or updated.
   * @param sslRequired sslRequired or {@code null} for none
   */
  public Ad setSslRequired(java.lang.Boolean sslRequired) {
    this.sslRequired = sslRequired;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getStartTime() {
    return startTime;
  }

  /**
   * @param startTime startTime or {@code null} for none
   */
  public Ad setStartTime(com.google.api.client.util.DateTime startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * Subaccount ID of this ad. This is a read-only field that can be left blank.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSubaccountId() {
    return subaccountId;
  }

  /**
   * Subaccount ID of this ad. This is a read-only field that can be left blank.
   * @param subaccountId subaccountId or {@code null} for none
   */
  public Ad setSubaccountId(java.lang.Long subaccountId) {
    this.subaccountId = subaccountId;
    return this;
  }

  /**
   * Targeting template ID, used to apply preconfigured targeting information to this ad. This
   * cannot be set while any of dayPartTargeting, geoTargeting, keyValueTargetingExpression,
   * languageTargeting, remarketingListExpression, or technologyTargeting are set. Applicable when
   * type is AD_SERVING_STANDARD_AD.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTargetingTemplateId() {
    return targetingTemplateId;
  }

  /**
   * Targeting template ID, used to apply preconfigured targeting information to this ad. This
   * cannot be set while any of dayPartTargeting, geoTargeting, keyValueTargetingExpression,
   * languageTargeting, remarketingListExpression, or technologyTargeting are set. Applicable when
   * type is AD_SERVING_STANDARD_AD.
   * @param targetingTemplateId targetingTemplateId or {@code null} for none
   */
  public Ad setTargetingTemplateId(java.lang.Long targetingTemplateId) {
    this.targetingTemplateId = targetingTemplateId;
    return this;
  }

  /**
   * Technology platform targeting information for this ad. This field must be left blank if the ad
   * is using a targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * @return value or {@code null} for none
   */
  public TechnologyTargeting getTechnologyTargeting() {
    return technologyTargeting;
  }

  /**
   * Technology platform targeting information for this ad. This field must be left blank if the ad
   * is using a targeting template. Applicable when type is AD_SERVING_STANDARD_AD.
   * @param technologyTargeting technologyTargeting or {@code null} for none
   */
  public Ad setTechnologyTargeting(TechnologyTargeting technologyTargeting) {
    this.technologyTargeting = technologyTargeting;
    return this;
  }

  /**
   * Type of ad. This is a required field on insertion. Note that default ads (
   * AD_SERVING_DEFAULT_AD) cannot be created directly (see Creative resource).
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of ad. This is a required field on insertion. Note that default ads (
   * AD_SERVING_DEFAULT_AD) cannot be created directly (see Creative resource).
   * @param type type or {@code null} for none
   */
  public Ad setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Ad set(String fieldName, Object value) {
    return (Ad) super.set(fieldName, value);
  }

  @Override
  public Ad clone() {
    return (Ad) super.clone();
  }

}
