/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Ad Slot
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AdSlot extends com.google.api.client.json.GenericJson {

  /**
   * Comment for this ad slot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String comment;

  /**
   * Ad slot compatibility. DISPLAY and DISPLAY_INTERSTITIAL refer to rendering either on desktop,
   * mobile devices or in mobile apps for regular or interstitial ads respectively. APP and
   * APP_INTERSTITIAL are for rendering in mobile apps. IN_STREAM_VIDEO refers to rendering in in-
   * stream video ads developed with the VAST standard.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String compatibility;

  /**
   * Height of this ad slot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long height;

  /**
   * ID of the placement from an external platform that is linked to this ad slot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long linkedPlacementId;

  /**
   * Name of this ad slot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Payment source type of this ad slot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String paymentSourceType;

  /**
   * Primary ad slot of a roadblock inventory item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean primary;

  /**
   * Width of this ad slot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long width;

  /**
   * Comment for this ad slot.
   * @return value or {@code null} for none
   */
  public java.lang.String getComment() {
    return comment;
  }

  /**
   * Comment for this ad slot.
   * @param comment comment or {@code null} for none
   */
  public AdSlot setComment(java.lang.String comment) {
    this.comment = comment;
    return this;
  }

  /**
   * Ad slot compatibility. DISPLAY and DISPLAY_INTERSTITIAL refer to rendering either on desktop,
   * mobile devices or in mobile apps for regular or interstitial ads respectively. APP and
   * APP_INTERSTITIAL are for rendering in mobile apps. IN_STREAM_VIDEO refers to rendering in in-
   * stream video ads developed with the VAST standard.
   * @return value or {@code null} for none
   */
  public java.lang.String getCompatibility() {
    return compatibility;
  }

  /**
   * Ad slot compatibility. DISPLAY and DISPLAY_INTERSTITIAL refer to rendering either on desktop,
   * mobile devices or in mobile apps for regular or interstitial ads respectively. APP and
   * APP_INTERSTITIAL are for rendering in mobile apps. IN_STREAM_VIDEO refers to rendering in in-
   * stream video ads developed with the VAST standard.
   * @param compatibility compatibility or {@code null} for none
   */
  public AdSlot setCompatibility(java.lang.String compatibility) {
    this.compatibility = compatibility;
    return this;
  }

  /**
   * Height of this ad slot.
   * @return value or {@code null} for none
   */
  public java.lang.Long getHeight() {
    return height;
  }

  /**
   * Height of this ad slot.
   * @param height height or {@code null} for none
   */
  public AdSlot setHeight(java.lang.Long height) {
    this.height = height;
    return this;
  }

  /**
   * ID of the placement from an external platform that is linked to this ad slot.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLinkedPlacementId() {
    return linkedPlacementId;
  }

  /**
   * ID of the placement from an external platform that is linked to this ad slot.
   * @param linkedPlacementId linkedPlacementId or {@code null} for none
   */
  public AdSlot setLinkedPlacementId(java.lang.Long linkedPlacementId) {
    this.linkedPlacementId = linkedPlacementId;
    return this;
  }

  /**
   * Name of this ad slot.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this ad slot.
   * @param name name or {@code null} for none
   */
  public AdSlot setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Payment source type of this ad slot.
   * @return value or {@code null} for none
   */
  public java.lang.String getPaymentSourceType() {
    return paymentSourceType;
  }

  /**
   * Payment source type of this ad slot.
   * @param paymentSourceType paymentSourceType or {@code null} for none
   */
  public AdSlot setPaymentSourceType(java.lang.String paymentSourceType) {
    this.paymentSourceType = paymentSourceType;
    return this;
  }

  /**
   * Primary ad slot of a roadblock inventory item.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPrimary() {
    return primary;
  }

  /**
   * Primary ad slot of a roadblock inventory item.
   * @param primary primary or {@code null} for none
   */
  public AdSlot setPrimary(java.lang.Boolean primary) {
    this.primary = primary;
    return this;
  }

  /**
   * Width of this ad slot.
   * @return value or {@code null} for none
   */
  public java.lang.Long getWidth() {
    return width;
  }

  /**
   * Width of this ad slot.
   * @param width width or {@code null} for none
   */
  public AdSlot setWidth(java.lang.Long width) {
    this.width = width;
    return this;
  }

  @Override
  public AdSlot set(String fieldName, Object value) {
    return (AdSlot) super.set(fieldName, value);
  }

  @Override
  public AdSlot clone() {
    return (AdSlot) super.clone();
  }

}
