/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * List account, subaccount, advertiser, and campaign associated with a given Billing Profile.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BillingAssignment extends com.google.api.client.json.GenericJson {

  /**
   * ID of the account associated with the billing assignment.This is a read-only, auto-generated
   * field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountId;

  /**
   * ID of the advertiser associated with the billing assignment.Wildcard (*) means this assignment
   * is not limited to a single advertiser
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String advertiserId;

  /**
   * ID of the campaign associated with the billing assignment. Wildcard (*) means this assignment
   * is not limited to a single campaign
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String campaignId;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#billingAssignment".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * ID of the subaccount associated with the billing assignment.Wildcard (*) means this assignment
   * is not limited to a single subaccountThis is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subaccountId;

  /**
   * ID of the account associated with the billing assignment.This is a read-only, auto-generated
   * field.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountId() {
    return accountId;
  }

  /**
   * ID of the account associated with the billing assignment.This is a read-only, auto-generated
   * field.
   * @param accountId accountId or {@code null} for none
   */
  public BillingAssignment setAccountId(java.lang.String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * ID of the advertiser associated with the billing assignment.Wildcard (*) means this assignment
   * is not limited to a single advertiser
   * @return value or {@code null} for none
   */
  public java.lang.String getAdvertiserId() {
    return advertiserId;
  }

  /**
   * ID of the advertiser associated with the billing assignment.Wildcard (*) means this assignment
   * is not limited to a single advertiser
   * @param advertiserId advertiserId or {@code null} for none
   */
  public BillingAssignment setAdvertiserId(java.lang.String advertiserId) {
    this.advertiserId = advertiserId;
    return this;
  }

  /**
   * ID of the campaign associated with the billing assignment. Wildcard (*) means this assignment
   * is not limited to a single campaign
   * @return value or {@code null} for none
   */
  public java.lang.String getCampaignId() {
    return campaignId;
  }

  /**
   * ID of the campaign associated with the billing assignment. Wildcard (*) means this assignment
   * is not limited to a single campaign
   * @param campaignId campaignId or {@code null} for none
   */
  public BillingAssignment setCampaignId(java.lang.String campaignId) {
    this.campaignId = campaignId;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#billingAssignment".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#billingAssignment".
   * @param kind kind or {@code null} for none
   */
  public BillingAssignment setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * ID of the subaccount associated with the billing assignment.Wildcard (*) means this assignment
   * is not limited to a single subaccountThis is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubaccountId() {
    return subaccountId;
  }

  /**
   * ID of the subaccount associated with the billing assignment.Wildcard (*) means this assignment
   * is not limited to a single subaccountThis is a read-only, auto-generated field.
   * @param subaccountId subaccountId or {@code null} for none
   */
  public BillingAssignment setSubaccountId(java.lang.String subaccountId) {
    this.subaccountId = subaccountId;
    return this;
  }

  @Override
  public BillingAssignment set(String fieldName, Object value) {
    return (BillingAssignment) super.set(fieldName, value);
  }

  @Override
  public BillingAssignment clone() {
    return (BillingAssignment) super.clone();
  }

}
