/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Model definition for BillingRateTieredRate.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BillingRateTieredRate extends com.google.api.client.json.GenericJson {

  /**
   * The maximum for this tier range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long highValue;

  /**
   * The minimum for this tier range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long lowValue;

  /**
   * Rate in micros for this tier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long rateInMicros;

  /**
   * The maximum for this tier range.
   * @return value or {@code null} for none
   */
  public java.lang.Long getHighValue() {
    return highValue;
  }

  /**
   * The maximum for this tier range.
   * @param highValue highValue or {@code null} for none
   */
  public BillingRateTieredRate setHighValue(java.lang.Long highValue) {
    this.highValue = highValue;
    return this;
  }

  /**
   * The minimum for this tier range.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLowValue() {
    return lowValue;
  }

  /**
   * The minimum for this tier range.
   * @param lowValue lowValue or {@code null} for none
   */
  public BillingRateTieredRate setLowValue(java.lang.Long lowValue) {
    this.lowValue = lowValue;
    return this;
  }

  /**
   * Rate in micros for this tier.
   * @return value or {@code null} for none
   */
  public java.lang.Long getRateInMicros() {
    return rateInMicros;
  }

  /**
   * Rate in micros for this tier.
   * @param rateInMicros rateInMicros or {@code null} for none
   */
  public BillingRateTieredRate setRateInMicros(java.lang.Long rateInMicros) {
    this.rateInMicros = rateInMicros;
    return this;
  }

  @Override
  public BillingRateTieredRate set(String fieldName, Object value) {
    return (BillingRateTieredRate) super.set(fieldName, value);
  }

  @Override
  public BillingRateTieredRate clone() {
    return (BillingRateTieredRate) super.clone();
  }

}
