/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Represents a DfaReporting channel grouping.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChannelGrouping extends com.google.api.client.json.GenericJson {

  /**
   * ChannelGrouping fallback name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fallbackName;

  /**
   * The kind of resource this is, in this case dfareporting#channelGrouping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * ChannelGrouping name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The rules contained within this channel grouping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ChannelGroupingRule> rules;

  /**
   * ChannelGrouping fallback name.
   * @return value or {@code null} for none
   */
  public java.lang.String getFallbackName() {
    return fallbackName;
  }

  /**
   * ChannelGrouping fallback name.
   * @param fallbackName fallbackName or {@code null} for none
   */
  public ChannelGrouping setFallbackName(java.lang.String fallbackName) {
    this.fallbackName = fallbackName;
    return this;
  }

  /**
   * The kind of resource this is, in this case dfareporting#channelGrouping.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of resource this is, in this case dfareporting#channelGrouping.
   * @param kind kind or {@code null} for none
   */
  public ChannelGrouping setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * ChannelGrouping name.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * ChannelGrouping name.
   * @param name name or {@code null} for none
   */
  public ChannelGrouping setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The rules contained within this channel grouping.
   * @return value or {@code null} for none
   */
  public java.util.List<ChannelGroupingRule> getRules() {
    return rules;
  }

  /**
   * The rules contained within this channel grouping.
   * @param rules rules or {@code null} for none
   */
  public ChannelGrouping setRules(java.util.List<ChannelGroupingRule> rules) {
    this.rules = rules;
    return this;
  }

  @Override
  public ChannelGrouping set(String fieldName, Object value) {
    return (ChannelGrouping) super.set(fieldName, value);
  }

  @Override
  public ChannelGrouping clone() {
    return (ChannelGrouping) super.clone();
  }

}
