/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * The original conversion that was inserted or updated and whether there were any errors.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConversionStatus extends com.google.api.client.json.GenericJson {

  /**
   * The original conversion that was inserted or updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Conversion conversion;

  /**
   * A list of errors related to this conversion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ConversionError> errors;

  static {
    // hack to force ProGuard to consider ConversionError used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ConversionError.class);
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#conversionStatus".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The original conversion that was inserted or updated.
   * @return value or {@code null} for none
   */
  public Conversion getConversion() {
    return conversion;
  }

  /**
   * The original conversion that was inserted or updated.
   * @param conversion conversion or {@code null} for none
   */
  public ConversionStatus setConversion(Conversion conversion) {
    this.conversion = conversion;
    return this;
  }

  /**
   * A list of errors related to this conversion.
   * @return value or {@code null} for none
   */
  public java.util.List<ConversionError> getErrors() {
    return errors;
  }

  /**
   * A list of errors related to this conversion.
   * @param errors errors or {@code null} for none
   */
  public ConversionStatus setErrors(java.util.List<ConversionError> errors) {
    this.errors = errors;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#conversionStatus".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#conversionStatus".
   * @param kind kind or {@code null} for none
   */
  public ConversionStatus setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public ConversionStatus set(String fieldName, Object value) {
    return (ConversionStatus) super.set(fieldName, value);
  }

  @Override
  public ConversionStatus clone() {
    return (ConversionStatus) super.clone();
  }

}
