/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Insert Conversions Request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConversionsBatchInsertRequest extends com.google.api.client.json.GenericJson {

  /**
   * The set of conversions to insert.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Conversion> conversions;

  static {
    // hack to force ProGuard to consider Conversion used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Conversion.class);
  }

  /**
   * Describes how encryptedUserId or encryptedUserIdCandidates[] is encrypted. This is a required
   * field if encryptedUserId or encryptedUserIdCandidates[] is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EncryptionInfo encryptionInfo;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#conversionsBatchInsertRequest".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The set of conversions to insert.
   * @return value or {@code null} for none
   */
  public java.util.List<Conversion> getConversions() {
    return conversions;
  }

  /**
   * The set of conversions to insert.
   * @param conversions conversions or {@code null} for none
   */
  public ConversionsBatchInsertRequest setConversions(java.util.List<Conversion> conversions) {
    this.conversions = conversions;
    return this;
  }

  /**
   * Describes how encryptedUserId or encryptedUserIdCandidates[] is encrypted. This is a required
   * field if encryptedUserId or encryptedUserIdCandidates[] is used.
   * @return value or {@code null} for none
   */
  public EncryptionInfo getEncryptionInfo() {
    return encryptionInfo;
  }

  /**
   * Describes how encryptedUserId or encryptedUserIdCandidates[] is encrypted. This is a required
   * field if encryptedUserId or encryptedUserIdCandidates[] is used.
   * @param encryptionInfo encryptionInfo or {@code null} for none
   */
  public ConversionsBatchInsertRequest setEncryptionInfo(EncryptionInfo encryptionInfo) {
    this.encryptionInfo = encryptionInfo;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#conversionsBatchInsertRequest".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#conversionsBatchInsertRequest".
   * @param kind kind or {@code null} for none
   */
  public ConversionsBatchInsertRequest setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public ConversionsBatchInsertRequest set(String fieldName, Object value) {
    return (ConversionsBatchInsertRequest) super.set(fieldName, value);
  }

  @Override
  public ConversionsBatchInsertRequest clone() {
    return (ConversionsBatchInsertRequest) super.clone();
  }

}
