/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains properties of a creative field value.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreativeFieldValue extends com.google.api.client.json.GenericJson {

  /**
   * ID of this creative field value. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#creativeFieldValue".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Value of this creative field value. It needs to be less than 256 characters in length and
   * unique per creative field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * ID of this creative field value. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this creative field value. This is a read-only, auto-generated field.
   * @param id id or {@code null} for none
   */
  public CreativeFieldValue setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#creativeFieldValue".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#creativeFieldValue".
   * @param kind kind or {@code null} for none
   */
  public CreativeFieldValue setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Value of this creative field value. It needs to be less than 256 characters in length and
   * unique per creative field.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * Value of this creative field value. It needs to be less than 256 characters in length and
   * unique per creative field.
   * @param value value or {@code null} for none
   */
  public CreativeFieldValue setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public CreativeFieldValue set(String fieldName, Object value) {
    return (CreativeFieldValue) super.set(fieldName, value);
  }

  @Override
  public CreativeFieldValue clone() {
    return (CreativeFieldValue) super.clone();
  }

}
