/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Creative Rotation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreativeRotation extends com.google.api.client.json.GenericJson {

  /**
   * Creative assignments in this creative rotation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CreativeAssignment> creativeAssignments;

  static {
    // hack to force ProGuard to consider CreativeAssignment used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(CreativeAssignment.class);
  }

  /**
   * Creative optimization configuration that is used by this ad. It should refer to one of the
   * existing optimization configurations in the ad's campaign. If it is unset or set to 0, then the
   * campaign's default optimization configuration will be used for this ad.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long creativeOptimizationConfigurationId;

  /**
   * Type of creative rotation. Can be used to specify whether to use sequential or random rotation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Strategy for calculating weights. Used with CREATIVE_ROTATION_TYPE_RANDOM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String weightCalculationStrategy;

  /**
   * Creative assignments in this creative rotation.
   * @return value or {@code null} for none
   */
  public java.util.List<CreativeAssignment> getCreativeAssignments() {
    return creativeAssignments;
  }

  /**
   * Creative assignments in this creative rotation.
   * @param creativeAssignments creativeAssignments or {@code null} for none
   */
  public CreativeRotation setCreativeAssignments(java.util.List<CreativeAssignment> creativeAssignments) {
    this.creativeAssignments = creativeAssignments;
    return this;
  }

  /**
   * Creative optimization configuration that is used by this ad. It should refer to one of the
   * existing optimization configurations in the ad's campaign. If it is unset or set to 0, then the
   * campaign's default optimization configuration will be used for this ad.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCreativeOptimizationConfigurationId() {
    return creativeOptimizationConfigurationId;
  }

  /**
   * Creative optimization configuration that is used by this ad. It should refer to one of the
   * existing optimization configurations in the ad's campaign. If it is unset or set to 0, then the
   * campaign's default optimization configuration will be used for this ad.
   * @param creativeOptimizationConfigurationId creativeOptimizationConfigurationId or {@code null} for none
   */
  public CreativeRotation setCreativeOptimizationConfigurationId(java.lang.Long creativeOptimizationConfigurationId) {
    this.creativeOptimizationConfigurationId = creativeOptimizationConfigurationId;
    return this;
  }

  /**
   * Type of creative rotation. Can be used to specify whether to use sequential or random rotation.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of creative rotation. Can be used to specify whether to use sequential or random rotation.
   * @param type type or {@code null} for none
   */
  public CreativeRotation setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * Strategy for calculating weights. Used with CREATIVE_ROTATION_TYPE_RANDOM.
   * @return value or {@code null} for none
   */
  public java.lang.String getWeightCalculationStrategy() {
    return weightCalculationStrategy;
  }

  /**
   * Strategy for calculating weights. Used with CREATIVE_ROTATION_TYPE_RANDOM.
   * @param weightCalculationStrategy weightCalculationStrategy or {@code null} for none
   */
  public CreativeRotation setWeightCalculationStrategy(java.lang.String weightCalculationStrategy) {
    this.weightCalculationStrategy = weightCalculationStrategy;
    return this;
  }

  @Override
  public CreativeRotation set(String fieldName, Object value) {
    return (CreativeRotation) super.set(fieldName, value);
  }

  @Override
  public CreativeRotation clone() {
    return (CreativeRotation) super.clone();
  }

}
