/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * A custom floodlight variable. This field may only be used when calling batchinsert; it is not
 * supported by batchupdate.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CustomFloodlightVariable extends com.google.api.client.json.GenericJson {

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#customFloodlightVariable".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The type of custom floodlight variable to supply a value for. These map to the "u[1-20]=" in
   * the tags.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The value of the custom floodlight variable. The length of string must not exceed 100
   * characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#customFloodlightVariable".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#customFloodlightVariable".
   * @param kind kind or {@code null} for none
   */
  public CustomFloodlightVariable setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The type of custom floodlight variable to supply a value for. These map to the "u[1-20]=" in
   * the tags.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of custom floodlight variable to supply a value for. These map to the "u[1-20]=" in
   * the tags.
   * @param type type or {@code null} for none
   */
  public CustomFloodlightVariable setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * The value of the custom floodlight variable. The length of string must not exceed 100
   * characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The value of the custom floodlight variable. The length of string must not exceed 100
   * characters.
   * @param value value or {@code null} for none
   */
  public CustomFloodlightVariable setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public CustomFloodlightVariable set(String fieldName, Object value) {
    return (CustomFloodlightVariable) super.set(fieldName, value);
  }

  @Override
  public CustomFloodlightVariable clone() {
    return (CustomFloodlightVariable) super.clone();
  }

}
