/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Properties of inheriting and overriding the default click-through event tag. A campaign may
 * override the event tag defined at the advertiser level, and an ad may also override the
 * campaign's setting further.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DefaultClickThroughEventTagProperties extends com.google.api.client.json.GenericJson {

  /**
   * ID of the click-through event tag to apply to all ads in this entity's scope.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long defaultClickThroughEventTagId;

  /**
   * Whether this entity should override the inherited default click-through event tag with its own
   * defined value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean overrideInheritedEventTag;

  /**
   * ID of the click-through event tag to apply to all ads in this entity's scope.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDefaultClickThroughEventTagId() {
    return defaultClickThroughEventTagId;
  }

  /**
   * ID of the click-through event tag to apply to all ads in this entity's scope.
   * @param defaultClickThroughEventTagId defaultClickThroughEventTagId or {@code null} for none
   */
  public DefaultClickThroughEventTagProperties setDefaultClickThroughEventTagId(java.lang.Long defaultClickThroughEventTagId) {
    this.defaultClickThroughEventTagId = defaultClickThroughEventTagId;
    return this;
  }

  /**
   * Whether this entity should override the inherited default click-through event tag with its own
   * defined value.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getOverrideInheritedEventTag() {
    return overrideInheritedEventTag;
  }

  /**
   * Whether this entity should override the inherited default click-through event tag with its own
   * defined value.
   * @param overrideInheritedEventTag overrideInheritedEventTag or {@code null} for none
   */
  public DefaultClickThroughEventTagProperties setOverrideInheritedEventTag(java.lang.Boolean overrideInheritedEventTag) {
    this.overrideInheritedEventTag = overrideInheritedEventTag;
    return this;
  }

  @Override
  public DefaultClickThroughEventTagProperties set(String fieldName, Object value) {
    return (DefaultClickThroughEventTagProperties) super.set(fieldName, value);
  }

  @Override
  public DefaultClickThroughEventTagProperties clone() {
    return (DefaultClickThroughEventTagProperties) super.clone();
  }

}
