/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Geographical Targeting.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GeoTargeting extends com.google.api.client.json.GenericJson {

  /**
   * Cities to be targeted. For each city only dartId is required. The other fields are populated
   * automatically when the ad is inserted or updated. If targeting a city, do not target or exclude
   * the country of the city, and do not target the metro or region of the city.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<City> cities;

  static {
    // hack to force ProGuard to consider City used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(City.class);
  }

  /**
   * Countries to be targeted or excluded from targeting, depending on the setting of the
   * excludeCountries field. For each country only dartId is required. The other fields are
   * populated automatically when the ad is inserted or updated. If targeting or excluding a
   * country, do not target regions, cities, metros, or postal codes in the same country.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Country> countries;

  static {
    // hack to force ProGuard to consider Country used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Country.class);
  }

  /**
   * Whether or not to exclude the countries in the countries field from targeting. If false, the
   * countries field refers to countries which will be targeted by the ad.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean excludeCountries;

  /**
   * Metros to be targeted. For each metro only dmaId is required. The other fields are populated
   * automatically when the ad is inserted or updated. If targeting a metro, do not target or
   * exclude the country of the metro.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Metro> metros;

  /**
   * Postal codes to be targeted. For each postal code only id is required. The other fields are
   * populated automatically when the ad is inserted or updated. If targeting a postal code, do not
   * target or exclude the country of the postal code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PostalCode> postalCodes;

  /**
   * Regions to be targeted. For each region only dartId is required. The other fields are populated
   * automatically when the ad is inserted or updated. If targeting a region, do not target or
   * exclude the country of the region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Region> regions;

  /**
   * Cities to be targeted. For each city only dartId is required. The other fields are populated
   * automatically when the ad is inserted or updated. If targeting a city, do not target or exclude
   * the country of the city, and do not target the metro or region of the city.
   * @return value or {@code null} for none
   */
  public java.util.List<City> getCities() {
    return cities;
  }

  /**
   * Cities to be targeted. For each city only dartId is required. The other fields are populated
   * automatically when the ad is inserted or updated. If targeting a city, do not target or exclude
   * the country of the city, and do not target the metro or region of the city.
   * @param cities cities or {@code null} for none
   */
  public GeoTargeting setCities(java.util.List<City> cities) {
    this.cities = cities;
    return this;
  }

  /**
   * Countries to be targeted or excluded from targeting, depending on the setting of the
   * excludeCountries field. For each country only dartId is required. The other fields are
   * populated automatically when the ad is inserted or updated. If targeting or excluding a
   * country, do not target regions, cities, metros, or postal codes in the same country.
   * @return value or {@code null} for none
   */
  public java.util.List<Country> getCountries() {
    return countries;
  }

  /**
   * Countries to be targeted or excluded from targeting, depending on the setting of the
   * excludeCountries field. For each country only dartId is required. The other fields are
   * populated automatically when the ad is inserted or updated. If targeting or excluding a
   * country, do not target regions, cities, metros, or postal codes in the same country.
   * @param countries countries or {@code null} for none
   */
  public GeoTargeting setCountries(java.util.List<Country> countries) {
    this.countries = countries;
    return this;
  }

  /**
   * Whether or not to exclude the countries in the countries field from targeting. If false, the
   * countries field refers to countries which will be targeted by the ad.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getExcludeCountries() {
    return excludeCountries;
  }

  /**
   * Whether or not to exclude the countries in the countries field from targeting. If false, the
   * countries field refers to countries which will be targeted by the ad.
   * @param excludeCountries excludeCountries or {@code null} for none
   */
  public GeoTargeting setExcludeCountries(java.lang.Boolean excludeCountries) {
    this.excludeCountries = excludeCountries;
    return this;
  }

  /**
   * Metros to be targeted. For each metro only dmaId is required. The other fields are populated
   * automatically when the ad is inserted or updated. If targeting a metro, do not target or
   * exclude the country of the metro.
   * @return value or {@code null} for none
   */
  public java.util.List<Metro> getMetros() {
    return metros;
  }

  /**
   * Metros to be targeted. For each metro only dmaId is required. The other fields are populated
   * automatically when the ad is inserted or updated. If targeting a metro, do not target or
   * exclude the country of the metro.
   * @param metros metros or {@code null} for none
   */
  public GeoTargeting setMetros(java.util.List<Metro> metros) {
    this.metros = metros;
    return this;
  }

  /**
   * Postal codes to be targeted. For each postal code only id is required. The other fields are
   * populated automatically when the ad is inserted or updated. If targeting a postal code, do not
   * target or exclude the country of the postal code.
   * @return value or {@code null} for none
   */
  public java.util.List<PostalCode> getPostalCodes() {
    return postalCodes;
  }

  /**
   * Postal codes to be targeted. For each postal code only id is required. The other fields are
   * populated automatically when the ad is inserted or updated. If targeting a postal code, do not
   * target or exclude the country of the postal code.
   * @param postalCodes postalCodes or {@code null} for none
   */
  public GeoTargeting setPostalCodes(java.util.List<PostalCode> postalCodes) {
    this.postalCodes = postalCodes;
    return this;
  }

  /**
   * Regions to be targeted. For each region only dartId is required. The other fields are populated
   * automatically when the ad is inserted or updated. If targeting a region, do not target or
   * exclude the country of the region.
   * @return value or {@code null} for none
   */
  public java.util.List<Region> getRegions() {
    return regions;
  }

  /**
   * Regions to be targeted. For each region only dartId is required. The other fields are populated
   * automatically when the ad is inserted or updated. If targeting a region, do not target or
   * exclude the country of the region.
   * @param regions regions or {@code null} for none
   */
  public GeoTargeting setRegions(java.util.List<Region> regions) {
    this.regions = regions;
    return this;
  }

  @Override
  public GeoTargeting set(String fieldName, Object value) {
    return (GeoTargeting) super.set(fieldName, value);
  }

  @Override
  public GeoTargeting clone() {
    return (GeoTargeting) super.clone();
  }

}
