/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains information about a language that can be targeted by ads.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Campaign Manager 360 API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Language extends com.google.api.client.json.GenericJson {

  /**
   * Language ID of this language. This is the ID used for targeting and generating reports.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#language".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Format of language code is an ISO 639 two-letter language code optionally followed by an
   * underscore followed by an ISO 3166 code. Examples are "en" for English or "zh_CN" for
   * Simplified Chinese.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCode;

  /**
   * Name of this language.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Language ID of this language. This is the ID used for targeting and generating reports.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * Language ID of this language. This is the ID used for targeting and generating reports.
   * @param id id or {@code null} for none
   */
  public Language setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#language".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#language".
   * @param kind kind or {@code null} for none
   */
  public Language setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Format of language code is an ISO 639 two-letter language code optionally followed by an
   * underscore followed by an ISO 3166 code. Examples are "en" for English or "zh_CN" for
   * Simplified Chinese.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCode() {
    return languageCode;
  }

  /**
   * Format of language code is an ISO 639 two-letter language code optionally followed by an
   * underscore followed by an ISO 3166 code. Examples are "en" for English or "zh_CN" for
   * Simplified Chinese.
   * @param languageCode languageCode or {@code null} for none
   */
  public Language setLanguageCode(java.lang.String languageCode) {
    this.languageCode = languageCode;
    return this;
  }

  /**
   * Name of this language.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this language.
   * @param name name or {@code null} for none
   */
  public Language setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public Language set(String fieldName, Object value) {
    return (Language) super.set(fieldName, value);
  }

  @Override
  public Language clone() {
    return (Language) super.clone();
  }

}
